/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.fcrepo.common.Constants;
import org.fcrepo.common.PID;
import org.fcrepo.common.rdf.SimpleLiteral;
import org.fcrepo.common.rdf.SimpleTriple;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOWriter;
import org.fcrepo.server.storage.DefaultDOManager;
import org.fcrepo.server.storage.SimpleDOReader;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.XMLDatastreamProcessor;
import org.fcrepo.server.utilities.FilteredTripleIterator;
import org.fcrepo.server.validation.ValidationUtility;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;
import org.trippi.io.TripleIteratorFactory;

public class SimpleDOWriter
extends SimpleDOReader
implements Constants,
DOWriter {
    private static ObjectIntegrityException ERROR_PENDING_REMOVAL = new ObjectIntegrityException("That can't be done because you said I should remove the object and i assume that's what you want unless you call rollback()");
    private static ObjectIntegrityException ERROR_INVALIDATED = new ObjectIntegrityException("The handle is no longer valid ... this object has already been committed or explicitly invalidated.");
    private final DigitalObject m_obj;
    private final Context m_context;
    private final DefaultDOManager m_mgr;
    private boolean m_pendingRemoval = false;
    private boolean m_invalidated = false;
    private boolean m_committed = false;

    public SimpleDOWriter(Context context, DefaultDOManager mgr, DOTranslator translator, String exportFormat, String encoding, DigitalObject obj) {
        super(context, mgr, translator, exportFormat, encoding, obj);
        this.m_context = context;
        this.m_obj = obj;
        this.m_mgr = mgr;
    }

    @Override
    public void setState(String state) throws ObjectIntegrityException {
        this.assertNotInvalidated();
        this.assertNotPendingRemoval();
        this.m_obj.setState(state);
    }

    @Override
    public void setOwnerId(String ownerId) throws ObjectIntegrityException {
        this.assertNotInvalidated();
        this.assertNotPendingRemoval();
        this.m_obj.setOwnerId(ownerId);
    }

    @Override
    public void setDatastreamState(String datastreamID, String dsState) throws ServerException {
        this.assertNotInvalidated();
        this.assertNotPendingRemoval();
        for (Datastream ds : this.m_obj.datastreams(datastreamID)) {
            ds.DSState = dsState;
        }
    }

    @Override
    public void setDatastreamVersionable(String datastreamID, boolean versionable) throws ServerException {
        this.assertNotInvalidated();
        this.assertNotPendingRemoval();
        for (Datastream ds : this.m_obj.datastreams(datastreamID)) {
            ds.DSVersionable = versionable;
        }
    }

    @Override
    public void setLabel(String label) throws ObjectIntegrityException {
        this.assertNotInvalidated();
        this.assertNotPendingRemoval();
        if (label != null && label.equals("")) {
            label = null;
        }
        this.m_obj.setLabel(label);
    }

    @Override
    public void remove() throws ObjectIntegrityException {
        this.assertNotInvalidated();
        this.assertNotPendingRemoval();
        this.m_pendingRemoval = true;
    }

    @Override
    public void addDatastream(Datastream datastream, boolean addNewVersion) throws ServerException {
        this.assertNotInvalidated();
        this.assertNotPendingRemoval();
        this.m_obj.addDatastreamVersion(datastream, addNewVersion);
    }

    @Override
    public Date[] removeDatastream(String id, Date start, Date end) throws ServerException {
        this.assertNotInvalidated();
        this.assertNotPendingRemoval();
        ArrayList<Datastream> removeList = new ArrayList<Datastream>();
        for (Datastream ds : this.m_obj.datastreams(id)) {
            boolean doRemove = false;
            if (start != null) {
                if (end != null) {
                    if (ds.DSCreateDT.compareTo(start) >= 0 && ds.DSCreateDT.compareTo(end) <= 0) {
                        doRemove = true;
                    }
                } else if (ds.DSCreateDT.compareTo(start) >= 0) {
                    doRemove = true;
                }
            } else if (end != null) {
                if (ds.DSCreateDT.compareTo(end) <= 0) {
                    doRemove = true;
                }
            } else {
                doRemove = true;
            }
            if (!doRemove) continue;
            removeList.add(ds);
        }
        for (Datastream toRemove : removeList) {
            this.m_obj.removeDatastreamVersion(toRemove);
        }
        Date[] deletedDates = new Date[removeList.size()];
        for (int i = 0; i < removeList.size(); ++i) {
            deletedDates[i] = ((Datastream)removeList.get((int)i)).DSCreateDT;
        }
        return deletedDates;
    }

    private String resolveSubjectToDatastream(String subject) throws ServerException {
        String dsId = null;
        String pidURI = PID.toURI((String)this.m_obj.getPid());
        if (subject.equals(pidURI)) {
            dsId = "RELS-EXT";
        } else if (subject.startsWith(pidURI + "/")) {
            dsId = "RELS-INT";
        } else {
            throw new GeneralException("Cannot determine which relationship datastream to update for subject " + subject + ".  Relationship subjects must be the URI of the object or the URI of a datastream within the object.");
        }
        return dsId;
    }

    @Override
    public boolean addRelationship(String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        return this.addRelationship(this.resolveSubjectToDatastream(subject), subject, relationship, object, isLiteral, datatype);
    }

    @Override
    public boolean addRelationship(String dsId, String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        block21: {
            Triple toAdd = SimpleDOWriter.createTriple(subject, relationship, object, isLiteral, datatype);
            Datastream relsDatastream = this.GetDatastream(dsId, null);
            XMLDatastreamProcessor dsxml = null;
            if (relsDatastream == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                HashMap<String, String> map = new HashMap<String, String>();
                if (dsId.equals("RELS-EXT")) {
                    map.put(SimpleDOWriter.RELS_EXT.prefix, SimpleDOWriter.RELS_EXT.uri);
                    map.put(SimpleDOWriter.MODEL.prefix, SimpleDOWriter.MODEL.uri);
                }
                map.put(SimpleDOWriter.RDF.prefix, SimpleDOWriter.RDF.uri);
                try {
                    FilteredTripleIterator triples = new FilteredTripleIterator(map, toAdd, true);
                    triples.toStream(out, RDFFormat.RDF_XML, false);
                }
                catch (TrippiException e) {
                    throw new GeneralException(e.getMessage(), e);
                }
                dsxml = new XMLDatastreamProcessor(dsId);
                Datastream newds = dsxml.getDatastream();
                newds.DatastreamAltIDs = new String[0];
                if (dsId.equals("RELS-EXT")) {
                    newds.DSFormatURI = SimpleDOWriter.RELS_EXT1_0.uri;
                } else if (dsId.equals("RELS-INT")) {
                    newds.DSFormatURI = SimpleDOWriter.RELS_INT1_0.uri;
                }
                newds.DSMIME = "application/rdf+xml";
                newds.DSInfoType = null;
                newds.DSState = "A";
                newds.DSVersionable = false;
                newds.DSVersionID = dsId + ".0";
                newds.DSLabel = "Relationships";
                newds.DSCreateDT = Server.getCurrentDate(this.m_context);
                newds.DSLocation = null;
                newds.DSLocationType = null;
                newds.DSChecksumType = Datastream.getDefaultChecksumType();
                dsxml.setXMLContent(out.toByteArray());
                newds.DSSize = dsxml.getXMLContent().length;
                ValidationUtility.validateReservedDatastream(PID.getInstance((String)this.m_obj.getPid()), newds.DatastreamID, newds);
                this.addDatastream(newds, false);
            } else {
                dsxml = new XMLDatastreamProcessor(relsDatastream);
                FilteredTripleIterator newIter = null;
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    TripleIterator iter = TripleIteratorFactory.defaultInstance().fromStream(relsDatastream.getContentStream(), RDFFormat.RDF_XML);
                    newIter = new FilteredTripleIterator(iter, toAdd, true);
                    newIter.toStream(out, RDFFormat.RDF_XML, false);
                    if (newIter.wasChangeMade()) {
                        XMLDatastreamProcessor newdsxml = dsxml.newVersion();
                        Datastream newds = newdsxml.getDatastream();
                        newdsxml.setDSMDClass(dsxml.getDSMDClass());
                        newds.DatastreamID = relsDatastream.DatastreamID;
                        newds.DatastreamAltIDs = relsDatastream.DatastreamAltIDs;
                        newds.DSFormatURI = relsDatastream.DSFormatURI;
                        newds.DSMIME = relsDatastream.DSMIME;
                        newds.DSInfoType = relsDatastream.DSInfoType;
                        newds.DSState = relsDatastream.DSState;
                        newds.DSVersionable = relsDatastream.DSVersionable;
                        newds.DSVersionID = this.newDatastreamID(dsId);
                        newds.DSLabel = relsDatastream.DSLabel;
                        newds.DSCreateDT = Server.getCurrentDate(this.m_context);
                        newds.DSLocation = null;
                        newds.DSLocationType = null;
                        newds.DSChecksumType = relsDatastream.DSChecksumType;
                        newdsxml.setXMLContent(out.toByteArray());
                        newds.DSSize = newdsxml.getXMLContent().length;
                        ValidationUtility.validateReservedDatastream(PID.getInstance((String)this.m_obj.getPid()), newds.DatastreamID, newds);
                        this.addDatastream(newds, newds.DSVersionable);
                        break block21;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (TrippiException e) {
                    throw new GeneralException(e.getMessage(), e);
                }
                finally {
                    try {
                        if (newIter != null) {
                            newIter.close();
                        }
                    }
                    catch (TrippiException e) {
                        throw new GeneralException(e.getMessage(), e);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean purgeRelationship(String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        return this.purgeRelationship(this.resolveSubjectToDatastream(subject), subject, relationship, object, isLiteral, datatype);
    }

    @Override
    public boolean purgeRelationship(String dsId, String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        block14: {
            Triple toPurge = SimpleDOWriter.createTriple(subject, relationship, object, isLiteral, datatype);
            Datastream relsDatastream = this.GetDatastream(dsId, null);
            if (relsDatastream == null) {
                return false;
            }
            XMLDatastreamProcessor dsxml = new XMLDatastreamProcessor(relsDatastream);
            InputStream relsDatastreamIS = relsDatastream.getContentStream();
            TripleIterator iter = null;
            FilteredTripleIterator newIter = null;
            try {
                iter = TripleIteratorFactory.defaultInstance().fromStream(relsDatastreamIS, RDFFormat.RDF_XML);
                newIter = new FilteredTripleIterator(iter, toPurge, false);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                newIter.toStream(out, RDFFormat.RDF_XML, false);
                if (newIter.wasChangeMade()) {
                    XMLDatastreamProcessor newdsxml = dsxml.newVersion();
                    Datastream newds = newdsxml.getDatastream();
                    newdsxml.setDSMDClass(dsxml.getDSMDClass());
                    newds.DatastreamID = dsId;
                    newds.DatastreamAltIDs = relsDatastream.DatastreamAltIDs;
                    newds.DSFormatURI = relsDatastream.DSFormatURI;
                    newds.DSMIME = relsDatastream.DSMIME;
                    newds.DSInfoType = relsDatastream.DSInfoType;
                    newds.DSState = relsDatastream.DSState;
                    newds.DSVersionable = relsDatastream.DSVersionable;
                    newds.DSVersionID = this.newDatastreamID(dsId);
                    newds.DSLabel = relsDatastream.DSLabel;
                    newds.DSCreateDT = Server.getCurrentDate(this.m_context);
                    newds.DSLocation = null;
                    newds.DSLocationType = null;
                    newds.DSChecksumType = relsDatastream.DSChecksumType;
                    newdsxml.setXMLContent(out.toByteArray());
                    newds.DSSize = newdsxml.getXMLContent().length;
                    ValidationUtility.validateReservedDatastream(PID.getInstance((String)this.m_obj.getPid()), newds.DatastreamID, newds);
                    this.addDatastream(newds, newds.DSVersionable);
                    break block14;
                }
                boolean bl = false;
                return bl;
            }
            catch (TrippiException e) {
                throw new GeneralException(e.getMessage(), e);
            }
            finally {
                try {
                    if (newIter != null) {
                        newIter.close();
                    }
                }
                catch (TrippiException e) {
                    throw new GeneralException(e.getMessage(), e);
                }
            }
        }
        return true;
    }

    private static Triple createTriple(String subject, String predicate, String object, boolean isLiteral, String datatype) throws ServerException {
        Object o = null;
        try {
            o = isLiteral ? (datatype == null || datatype.length() == 0 ? new SimpleLiteral(object) : new SimpleLiteral(object, new URI(datatype))) : new SimpleURIReference(new URI(object));
            return new SimpleTriple((SubjectNode)new SimpleURIReference(new URI(subject)), (PredicateNode)new SimpleURIReference(new URI(predicate)), (ObjectNode)o);
        }
        catch (URISyntaxException e) {
            throw new GeneralException(e.getMessage(), e);
        }
    }

    @Override
    public void commit(String logMessage) throws ServerException {
        this.assertNotInvalidated();
        this.m_mgr.doCommit(false, this.m_context, this.m_obj, logMessage, this.m_pendingRemoval);
        this.m_committed = true;
        this.invalidate();
    }

    @Override
    public void invalidate() {
        this.m_invalidated = true;
    }

    @Override
    public String newDatastreamID() {
        return this.m_obj.newDatastreamID();
    }

    @Override
    public String newDatastreamID(String dsID) {
        return this.m_obj.newDatastreamID(dsID);
    }

    @Override
    public String newAuditRecordID() {
        return this.m_obj.newAuditRecordID();
    }

    private void assertNotPendingRemoval() throws ObjectIntegrityException {
        if (this.m_pendingRemoval) {
            throw ERROR_PENDING_REMOVAL;
        }
    }

    private void assertNotInvalidated() throws ObjectIntegrityException {
        if (this.m_invalidated) {
            throw ERROR_INVALIDATED;
        }
    }

    @Override
    public boolean isCommitted() {
        return this.m_committed;
    }

    @Override
    public boolean isNew() {
        return this.m_obj.isNew();
    }
}

