/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.storage.lowlevel.FileSystem;
import org.fcrepo.utilities.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileSystem
extends FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(GenericFileSystem.class);

    public GenericFileSystem(Map<String, ?> configuration) {
        super(configuration);
    }

    private final File wrappedNewFile(File file, String suffix) throws LowlevelStorageException {
        File temp;
        String path = "";
        try {
            path = file.getCanonicalPath() + suffix;
            temp = new File(path);
        }
        catch (Exception e) {
            throw new LowlevelStorageException(true, "GenericFileSystem.wrappedNewFile(): couldn't create File for [" + path + "]", e);
        }
        return temp;
    }

    private final String getPath(File file) {
        String temp;
        try {
            temp = file.getCanonicalPath();
        }
        catch (Exception eCaughtFiles) {
            temp = "";
        }
        return temp;
    }

    @Override
    public final void write(File file, InputStream content) throws LowlevelStorageException {
        try {
            this.writeIntoExistingDirectory(file, content);
        }
        catch (LowlevelStorageException eCaught) {
            File containingDirectories = null;
            try {
                containingDirectories = file.getParentFile();
                containingDirectories.mkdirs();
            }
            catch (Exception e) {
                throw new LowlevelStorageException(true, "GenericFileSystem.write(): couldn't make directories for [" + this.getPath(file) + "]", e);
            }
            this.writeIntoExistingDirectory(file, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeIntoExistingDirectory(File file, InputStream content) throws LowlevelStorageException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception eCaughtFileNotCreated) {
            throw new LowlevelStorageException(true, "couldn't create file " + this.getPath(file), eCaughtFileNotCreated);
        }
        try {
            boolean fileCopySuccessful = FileUtils.copy((InputStream)content, (OutputStream)fileOutputStream);
            if (!fileCopySuccessful) {
                throw new LowlevelStorageException(true, "couldn't write new file " + this.getPath(file));
            }
        }
        finally {
            try {
                fileOutputStream.close();
                content.close();
            }
            catch (Exception eCaughtFileNotClosed) {
                throw new LowlevelStorageException(true, "couldn't close new file " + this.getPath(file), eCaughtFileNotClosed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewrite(File file, InputStream content) throws LowlevelStorageException {
        File backupFile = this.wrappedNewFile(file, ".bak");
        if (!file.renameTo(backupFile)) {
            try {
                content.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new LowlevelStorageException(true, "failed to rename with .bak extension " + this.getPath(file));
        }
        boolean needToRevert = false;
        String err = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            boolean fileCopySuccessful = FileUtils.copy((InputStream)content, (OutputStream)out);
            if (!fileCopySuccessful) {
                needToRevert = true;
                err = "failed to write content to file " + file.getPath();
            }
        }
        catch (IOException e) {
            needToRevert = true;
            err = "failed to write content to file " + file.getPath();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("Could not close file for writing " + file.getPath(), (Throwable)e);
                }
            }
            try {
                content.close();
            }
            catch (IOException e) {
                logger.warn("Could not close content stream for reading", (Throwable)e);
            }
        }
        if (needToRevert) {
            err = backupFile.renameTo(file) ? err + ", so reverted to original" : err + ", AND failed to revert to original from .bak!";
            throw new LowlevelStorageException(true, err);
        }
        if (!backupFile.delete()) {
            logger.warn("Could not delete backup file {}", (Object)backupFile.getPath());
        }
    }

    @Override
    public final InputStream read(File file) throws LowlevelStorageException {
        FileInputStream fileInputStream = null;
        if (!file.exists()) {
            throw new LowlevelStorageException(true, "file " + this.getPath(file) + "doesn't exist for reading");
        }
        if (!file.canRead()) {
            throw new LowlevelStorageException(true, "file " + this.getPath(file) + "not readable");
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException eCaughtOpenFile) {
            throw new LowlevelStorageException(true, "file " + this.getPath(file) + "couldn't be opened for reading", eCaughtOpenFile);
        }
        return fileInputStream;
    }

    @Override
    public final void delete(File file) throws LowlevelStorageException {
        file.delete();
    }

    @Override
    public String[] list(File d) {
        return d.list();
    }

    @Override
    public boolean isDirectory(File f) {
        return f.isDirectory();
    }
}

