/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel;

import java.util.Map;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.MalformedPidException;

public abstract class PathAlgorithm {
    public PathAlgorithm(Map<String, ?> configuration) {
    }

    public abstract String get(String var1) throws LowlevelStorageException;

    public static String encode(String unencoded) throws LowlevelStorageException {
        try {
            int i = unencoded.indexOf("+");
            if (i != -1) {
                return Server.getPID(unencoded.substring(0, i)).toFilename() + unencoded.substring(i);
            }
            return Server.getPID(unencoded).toFilename();
        }
        catch (MalformedPidException e) {
            throw new LowlevelStorageException(true, e.getMessage(), e);
        }
    }

    public static String decode(String encoded) throws LowlevelStorageException {
        try {
            int i = encoded.indexOf("+");
            if (i != -1) {
                return Server.pidFromFilename(encoded.substring(0, i)).toString() + encoded.substring(i);
            }
            return Server.pidFromFilename(encoded).toString();
        }
        catch (MalformedPidException e) {
            throw new LowlevelStorageException(true, e.getMessage(), e);
        }
    }
}

