/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.LowlevelStorageInconsistencyException;
import org.fcrepo.server.storage.lowlevel.PathAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PathRegistry.class);
    protected static final int NO_REPORT = 0;
    protected static final int ERROR_REPORT = 1;
    protected static final int FULL_REPORT = 2;
    protected static final int REPORT_FILES = 0;
    protected static final int AUDIT_FILES = 1;
    protected static final int REBUILD = 2;
    protected final String registryName;
    protected final String[] storeBases;

    public PathRegistry(Map<String, ?> configuration) {
        this.registryName = (String)configuration.get("registryName");
        this.storeBases = (String[])configuration.get("storeBases");
    }

    public abstract String get(String var1) throws LowlevelStorageException;

    public abstract void put(String var1, String var2) throws LowlevelStorageException;

    public abstract void remove(String var1) throws LowlevelStorageException;

    public abstract void rebuild() throws LowlevelStorageException;

    public abstract void auditFiles() throws LowlevelStorageException;

    public void auditRegistry() throws LowlevelStorageException {
        logger.info("begin audit:  registry-against-files");
        Enumeration<String> keys = this.keys();
        while (keys.hasMoreElements()) {
            String pid = keys.nextElement();
            try {
                String path = this.get(pid);
                File file = new File(path);
                boolean fileExists = file.exists();
                logger.info((fileExists ? "" : "ERROR: ") + "registry has [" + pid + "] => [" + path + "] " + (fileExists ? "and" : "BUT") + " file does " + (fileExists ? "" : "NOT") + "exist");
            }
            catch (LowlevelStorageException e) {
                logger.error("ERROR: registry has [" + pid + "] => []", (Throwable)e);
            }
        }
        logger.info("end audit:  registry-against-files (ending normally)");
    }

    protected final String getRegistryName() {
        return this.registryName;
    }

    public static final boolean stringNull(String string) {
        return null == string || string.equals("");
    }

    private final void traverseFiles(File[] files, int operation, boolean stopOnError, int report) throws LowlevelStorageException {
        block9: for (File element : files) {
            String path;
            String filename;
            block14: {
                if (!element.exists()) continue;
                if (element.isDirectory()) {
                    this.traverseFiles(element.listFiles(), operation, stopOnError, report);
                    continue;
                }
                filename = element.getName();
                path = null;
                try {
                    path = element.getCanonicalPath();
                }
                catch (IOException e) {
                    if (report != 0) {
                        logger.error("couldn't get File path", (Throwable)e);
                    }
                    if (!stopOnError) break block14;
                    throw new LowlevelStorageException(true, "couldn't get File path", e);
                }
            }
            if (path == null) continue;
            String pid = PathAlgorithm.decode(filename);
            if (pid == null) {
                if (report != 0) {
                    logger.error("unexpected file at [" + path + "]");
                }
                if (!stopOnError) continue;
                throw new LowlevelStorageException(true, "unexpected file traversing object store at [" + path + "]");
            }
            switch (operation) {
                case 0: {
                    if (report != 2) continue block9;
                    logger.info("file [" + path + "] would have pid [" + pid + "]");
                    continue block9;
                }
                case 2: {
                    this.put(pid, path);
                    if (report != 2) continue block9;
                    logger.info("added to registry: [" + pid + "] ==> [" + path + "]");
                    continue block9;
                }
                case 1: {
                    String rpath = null;
                    try {
                        rpath = this.get(pid);
                    }
                    catch (LowlevelStorageException e) {
                        // empty catch block
                    }
                    boolean matches = rpath.equals(path);
                    if (report != 2 && matches) continue block9;
                    logger.info((matches ? "" : "ERROR: ") + "[" + path + "] " + (matches ? "" : "NOT ") + "in registry" + (matches ? "" : "; pid [" + pid + "] instead registered as [" + (rpath == null ? "[OBJECT NOT IN STORE]" : rpath) + "]"));
                }
            }
        }
    }

    public void traverseFiles(String[] storeBases, int operation, boolean stopOnError, int report) throws LowlevelStorageException {
        File[] files;
        try {
            files = new File[storeBases.length];
            for (int i = 0; i < storeBases.length; ++i) {
                files[i] = new File(storeBases[i]);
            }
        }
        catch (Exception e) {
            throw new LowlevelStorageException(true, "couldn't rebuild VolatilePathRegistry", e);
        }
        this.traverseFiles(files, operation, stopOnError, report);
    }

    protected abstract Enumeration<String> keys() throws LowlevelStorageException, LowlevelStorageInconsistencyException;
}

