/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.storage.lowlevel.PathRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimplePathRegistry
extends PathRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PathRegistry.class);
    private Hashtable<String, String> hashtable = null;

    public SimplePathRegistry(Map<String, ?> configuration) throws LowlevelStorageException {
        super(configuration);
        this.rebuild();
    }

    @Override
    public String get(String pid) throws LowlevelStorageException {
        String result;
        try {
            result = this.hashtable.get(pid);
        }
        catch (Exception e) {
            throw new LowlevelStorageException(true, "SimplePathRegistry.get(" + pid + ")", e);
        }
        if (null == result || 0 == result.length()) {
            throw new ObjectNotInLowlevelStorageException("SimplePathRegistry.get(" + pid + "): object not found");
        }
        return result;
    }

    @Override
    public void put(String pid, String path) throws LowlevelStorageException {
        try {
            this.hashtable.put(pid, path);
        }
        catch (Exception e) {
            throw new LowlevelStorageException(true, "SimplePathRegistry.put(" + pid + ")", e);
        }
    }

    @Override
    public void remove(String pid) throws LowlevelStorageException {
        try {
            this.hashtable.remove(pid);
        }
        catch (Exception e) {
            throw new LowlevelStorageException(true, "SimplePathRegistry.remove(" + pid + ")", e);
        }
    }

    @Override
    public void auditFiles() throws LowlevelStorageException {
        logger.info("begin audit:  files-against-registry");
        this.traverseFiles(this.storeBases, 1, false, 2);
        logger.info("end audit:  files-against-registry (ending normally)");
    }

    @Override
    public void rebuild() throws LowlevelStorageException {
        int report = 2;
        Hashtable<String, String> temp = this.hashtable;
        this.hashtable = new Hashtable();
        try {
            logger.info("begin rebuilding registry from files");
            this.traverseFiles(this.storeBases, 2, false, report);
            logger.info("end rebuilding registry from files (ending normally)");
        }
        catch (Exception e) {
            this.hashtable = temp;
            if (report != 0) {
                logger.error("ending rebuild unsuccessfully", (Throwable)e);
            }
            throw new LowlevelStorageException(true, "ending rebuild unsuccessfully", e);
        }
    }

    @Override
    protected Enumeration<String> keys() throws LowlevelStorageException {
        return this.hashtable.keys();
    }
}

