/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel.akubra;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.akubraproject.Blob;
import org.akubraproject.BlobStore;
import org.akubraproject.BlobStoreConnection;
import org.akubraproject.DuplicateBlobException;
import org.akubraproject.MissingBlobException;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.common.FaultException;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ObjectAlreadyInLowlevelStorageException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.storage.lowlevel.IListable;
import org.fcrepo.server.storage.lowlevel.ILowlevelStorage;
import org.fcrepo.server.storage.lowlevel.ISizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AkubraLowlevelStorage
implements ILowlevelStorage,
IListable,
ISizable {
    private static final Logger logger = LoggerFactory.getLogger(AkubraLowlevelStorage.class);
    private final BlobStore objectStore;
    private final BlobStore datastreamStore;
    private final boolean forceSafeObjectOverwrites;
    private final boolean forceSafeDatastreamOverwrites;

    public AkubraLowlevelStorage(BlobStore objectStore, BlobStore datastreamStore, boolean forceSafeObjectOverwrites, boolean forceSafeDatastreamOverwrites) {
        this.objectStore = objectStore;
        this.datastreamStore = datastreamStore;
        this.forceSafeObjectOverwrites = forceSafeObjectOverwrites;
        this.forceSafeDatastreamOverwrites = forceSafeDatastreamOverwrites;
    }

    @Override
    public long addDatastream(String dsKey, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        return AkubraLowlevelStorage.add(this.datastreamStore, dsKey, content, hints);
    }

    public long addDatastream(String pid, InputStream content) throws LowlevelStorageException {
        return this.addDatastream(pid, content, null);
    }

    @Override
    public void addObject(String objectKey, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        AkubraLowlevelStorage.add(this.objectStore, objectKey, content, hints);
    }

    public void addObject(String pid, InputStream content) throws LowlevelStorageException {
        this.addObject(pid, content, null);
    }

    @Override
    public void auditDatastream() throws LowlevelStorageException {
        AkubraLowlevelStorage.audit(this.datastreamStore);
    }

    @Override
    public void auditObject() throws LowlevelStorageException {
        AkubraLowlevelStorage.audit(this.objectStore);
    }

    @Override
    public void rebuildDatastream() throws LowlevelStorageException {
        AkubraLowlevelStorage.rebuild(this.datastreamStore);
    }

    @Override
    public void rebuildObject() throws LowlevelStorageException {
        AkubraLowlevelStorage.rebuild(this.objectStore);
    }

    @Override
    public void removeDatastream(String dsKey) throws LowlevelStorageException {
        AkubraLowlevelStorage.remove(this.datastreamStore, dsKey);
    }

    @Override
    public void removeObject(String objectKey) throws LowlevelStorageException {
        AkubraLowlevelStorage.remove(this.objectStore, objectKey);
    }

    @Override
    public long replaceDatastream(String dsKey, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        return AkubraLowlevelStorage.replace(this.datastreamStore, dsKey, content, this.forceSafeDatastreamOverwrites, hints);
    }

    public long replaceDatastream(String pid, InputStream content) throws LowlevelStorageException {
        return this.replaceDatastream(pid, content, null);
    }

    @Override
    public void replaceObject(String objectKey, InputStream content, Map<String, String> hints) throws LowlevelStorageException {
        AkubraLowlevelStorage.replace(this.objectStore, objectKey, content, this.forceSafeObjectOverwrites, hints);
    }

    public void replaceObject(String pid, InputStream content) throws LowlevelStorageException {
        this.replaceObject(pid, content, null);
    }

    @Override
    public InputStream retrieveDatastream(String dsKey) throws LowlevelStorageException {
        return AkubraLowlevelStorage.retrieve(this.datastreamStore, dsKey);
    }

    @Override
    public InputStream retrieveObject(String objectKey) throws LowlevelStorageException {
        return AkubraLowlevelStorage.retrieve(this.objectStore, objectKey);
    }

    @Override
    public Iterator<String> listDatastreams() {
        return AkubraLowlevelStorage.list(this.datastreamStore);
    }

    @Override
    public Iterator<String> listObjects() {
        return AkubraLowlevelStorage.list(this.objectStore);
    }

    @Override
    public long getDatastreamSize(String dsKey) throws LowlevelStorageException {
        return AkubraLowlevelStorage.getSize(this.datastreamStore, dsKey);
    }

    /*
     * Exception decompiling
     */
    private static long add(BlobStore store, String key, InputStream content, Map<String, String> hints) throws ObjectAlreadyInLowlevelStorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void audit(BlobStore store) {
    }

    private static void rebuild(BlobStore store) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(BlobStore store, String key) throws ObjectNotInLowlevelStorageException {
        BlobStoreConnection connection = null;
        try {
            URI blobId = AkubraLowlevelStorage.getBlobId(key);
            connection = AkubraLowlevelStorage.getConnection(store, null);
            Blob blob = AkubraLowlevelStorage.getBlob(connection, blobId, null);
            if (!AkubraLowlevelStorage.exists(blob)) {
                throw new ObjectNotInLowlevelStorageException("Object not found in low-level storage: " + key);
            }
            AkubraLowlevelStorage.delete(blob);
        }
        catch (Throwable throwable) {
            AkubraLowlevelStorage.closeConnection(connection);
            throw throwable;
        }
        AkubraLowlevelStorage.closeConnection(connection);
    }

    /*
     * Exception decompiling
     */
    private static long replace(BlobStore store, String key, InputStream content, boolean forceSafeOverwrite, Map<String, String> hints) throws LowlevelStorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> list(BlobStore store) {
        BlobStoreConnection connection = null;
        boolean successful = false;
        try {
            connection = AkubraLowlevelStorage.getConnection(store, null);
            Iterator<URI> blobIds = AkubraLowlevelStorage.listBlobIds(connection);
            successful = true;
            ConnectionClosingKeyIterator connectionClosingKeyIterator = new ConnectionClosingKeyIterator(connection, blobIds);
            return connectionClosingKeyIterator;
        }
        finally {
            if (!successful) {
                AkubraLowlevelStorage.closeConnection(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safeOverwrite(Blob origBlob, InputStream content) {
        BlobStoreConnection connection = origBlob.getConnection();
        String origId = origBlob.getId().toString();
        Blob newBlob = null;
        try {
            newBlob = connection.getBlob(new URI(origId + "/new"), null);
            AkubraLowlevelStorage.copy(content, newBlob.openOutputStream(-1L, false));
        }
        catch (Throwable th) {
            throw new FaultException(th);
        }
        Blob oldBlob = null;
        try {
            oldBlob = AkubraLowlevelStorage.rename(origBlob, origId + "/old");
        }
        finally {
            if (oldBlob == null) {
                try {
                    AkubraLowlevelStorage.delete(newBlob);
                }
                catch (Throwable th) {
                    logger.error("Failed to delete " + newBlob.getId() + " while" + " recovering from rename failure during safe" + " overwrite", th);
                }
            }
        }
        boolean successful = false;
        try {
            AkubraLowlevelStorage.rename(newBlob, origId);
            successful = true;
        }
        finally {
            if (!successful) {
                try {
                    AkubraLowlevelStorage.rename(oldBlob, origId);
                }
                catch (Throwable th) {
                    logger.error("Failed to rename " + oldBlob.getId() + " to " + origId + " while recovering from rename" + " failure during safe overwrite", th);
                }
                try {
                    newBlob.delete();
                }
                catch (Throwable th) {
                    logger.error("Failed to delete " + newBlob.getId() + " while recovering from rename" + " failure during safe overwrite", th);
                }
            }
        }
        try {
            AkubraLowlevelStorage.delete(oldBlob);
        }
        catch (Throwable th) {
            logger.error("Failed to delete " + oldBlob.getId() + " while cleaning up after committed" + " safe overwrite", th);
        }
    }

    private static Blob rename(Blob blob, String newId) {
        try {
            return blob.moveTo(new URI(newId), null);
        }
        catch (IOException e) {
            throw new FaultException((Throwable)e);
        }
        catch (URISyntaxException wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
    }

    private static InputStream retrieve(BlobStore store, String key) throws ObjectNotInLowlevelStorageException {
        ConnectionClosingInputStream connectionClosingInputStream;
        block5: {
            BlobStoreConnection connection = null;
            InputStream content = null;
            boolean successful = false;
            try {
                URI blobId = AkubraLowlevelStorage.getBlobId(key);
                connection = AkubraLowlevelStorage.getConnection(store, null);
                Blob blob = AkubraLowlevelStorage.getBlob(connection, blobId, null);
                content = AkubraLowlevelStorage.openInputStream(blob);
                successful = true;
                connectionClosingInputStream = new ConnectionClosingInputStream(connection, content);
                if (successful) break block5;
            }
            catch (MissingBlobException e) {
                try {
                    throw new ObjectNotInLowlevelStorageException("Object not found in low-level storage: " + key);
                }
                catch (Throwable throwable) {
                    if (!successful) {
                        IOUtils.closeQuietly(content);
                        AkubraLowlevelStorage.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)content);
            AkubraLowlevelStorage.closeConnection(connection);
        }
        return connectionClosingInputStream;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getSize(BlobStore store, String key) throws ObjectNotInLowlevelStorageException {
        long l;
        block6: {
            BlobStoreConnection connection = null;
            boolean successful = false;
            try {
                URI blobId = AkubraLowlevelStorage.getBlobId(key);
                connection = AkubraLowlevelStorage.getConnection(store, null);
                Blob blob = AkubraLowlevelStorage.getBlob(connection, blobId, null);
                l = blob.getSize();
                if (successful) break block6;
            }
            catch (MissingBlobException e) {
                try {
                    throw new ObjectNotInLowlevelStorageException("Object not found in low-level storage: " + key);
                    catch (IOException e2) {
                        throw new RuntimeException("Error reading blob size: " + e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    if (!successful) {
                        AkubraLowlevelStorage.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            AkubraLowlevelStorage.closeConnection(connection);
        }
        return l;
    }

    private static BlobStoreConnection getConnection(BlobStore store, Map<String, String> hints) {
        try {
            return store.openConnection(null, hints);
        }
        catch (IOException e) {
            throw new FaultException("System error getting blob store connection", (Throwable)e);
        }
    }

    private static void closeConnection(BlobStoreConnection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable th) {
            logger.warn("Unexpected error closing blob store connection", th);
        }
    }

    private static Blob getBlob(BlobStoreConnection connection, URI blobId, Map<String, String> hints) {
        try {
            return connection.getBlob(blobId, hints);
        }
        catch (Exception e) {
            logger.error(e.toString(), (Throwable)e);
            throw new FaultException("System error getting blob handle", (Throwable)e);
        }
    }

    private static InputStream openInputStream(Blob blob) throws MissingBlobException {
        try {
            return blob.openInputStream();
        }
        catch (MissingBlobException e) {
            throw e;
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new FaultException("System error opening input stream", (Throwable)e);
        }
    }

    private static OutputStream openOutputStream(Blob blob, long estimatedSize, boolean overwrite) throws DuplicateBlobException {
        try {
            return blob.openOutputStream(estimatedSize, overwrite);
        }
        catch (DuplicateBlobException e) {
            throw e;
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new FaultException("System error opening output stream", (Throwable)e);
        }
    }

    private static boolean exists(Blob blob) {
        try {
            return blob.exists();
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new FaultException("System error determining existence of blob", (Throwable)e);
        }
    }

    private static void delete(Blob blob) {
        try {
            if (blob.exists()) {
                blob.delete();
            } else {
                logger.warn("Attempted to delete non-existent blob " + blob.getCanonicalId());
            }
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new FaultException("System error deleting blob", (Throwable)e);
        }
    }

    private static Iterator<URI> listBlobIds(BlobStoreConnection connection) {
        try {
            return connection.listBlobIds(null);
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new FaultException("System error listing blob ids", (Throwable)e);
        }
    }

    private static long copy(InputStream source, OutputStream sink) {
        try {
            long l = IOUtils.copyLarge((InputStream)source, (OutputStream)sink);
            return l;
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new FaultException("System error copying stream", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)source);
            IOUtils.closeQuietly((OutputStream)sink);
        }
    }

    private static URI getBlobId(String token) {
        try {
            int i = token.indexOf(43);
            if (i == -1) {
                return new URI(new PID(token).toURI());
            }
            String[] dsParts = token.substring(i + 1).split("\\+");
            if (dsParts.length != 2) {
                throw new IllegalArgumentException("Malformed datastream token: " + token);
            }
            return new URI(Constants.FEDORA.uri + token.substring(0, i) + "/" + AkubraLowlevelStorage.uriEncode(dsParts[0]) + "/" + AkubraLowlevelStorage.uriEncode(dsParts[1]));
        }
        catch (MalformedPIDException e) {
            throw new IllegalArgumentException("Malformed object token: " + token, e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed object or datastream token: " + token, e);
        }
    }

    private static String getToken(URI blobId) {
        String[] parts = blobId.getSchemeSpecificPart().split("/");
        if (parts.length == 2) {
            return parts[1];
        }
        if (parts.length == 4) {
            return parts[1] + "+" + AkubraLowlevelStorage.uriDecode(parts[2]) + "+" + AkubraLowlevelStorage.uriDecode(parts[3]);
        }
        throw new IllegalArgumentException("Malformed token-as-blobId: " + blobId);
    }

    private static String uriEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
    }

    private static String uriDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
    }

    static class ConnectionClosingKeyIterator
    implements Iterator<String> {
        private final BlobStoreConnection connection;
        private final Iterator<URI> blobIds;

        public ConnectionClosingKeyIterator(BlobStoreConnection connection, Iterator<URI> blobIds) {
            this.connection = connection;
            this.blobIds = blobIds;
        }

        @Override
        public boolean hasNext() {
            if (!this.blobIds.hasNext()) {
                this.connection.close();
                return false;
            }
            return true;
        }

        @Override
        public String next() {
            return AkubraLowlevelStorage.getToken(this.blobIds.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void finalize() {
            this.connection.close();
        }
    }

    static class ConnectionClosingInputStream
    extends FilterInputStream {
        private final BlobStoreConnection connection;

        public ConnectionClosingInputStream(BlobStoreConnection connection, InputStream wrapped) {
            super(wrapped);
            this.connection = connection;
        }

        @Override
        public void close() {
            if (!this.connection.isClosed()) {
                try {
                    super.close();
                }
                catch (IOException e) {
                    throw new FaultException("System error closing stream", (Throwable)e);
                }
                finally {
                    this.connection.close();
                }
            }
        }

        protected void finalize() {
            this.close();
        }
    }
}

