/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel.akubra;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.akubraproject.map.IdMapper;
import org.fcrepo.server.utilities.MD5Utility;

public class HashPathIdMapper
implements IdMapper {
    private static final String internalScheme = "file";
    private final String pattern;

    public HashPathIdMapper(String pattern) {
        this.pattern = HashPathIdMapper.validatePattern(pattern);
    }

    public URI getExternalId(URI internalId) throws NullPointerException {
        String fullPath = internalId.toString().substring(internalScheme.length() + 1);
        int i = fullPath.lastIndexOf(47);
        String encodedURI = i == -1 ? fullPath : fullPath.substring(i + 1);
        return URI.create(HashPathIdMapper.decode(encodedURI));
    }

    public URI getInternalId(URI externalId) throws NullPointerException {
        if (externalId == null) {
            throw new NullPointerException();
        }
        String uri = externalId.toString();
        return URI.create("file:" + this.getPath(uri) + HashPathIdMapper.encode(uri));
    }

    public String getInternalPrefix(String externalPrefix) throws NullPointerException {
        if (externalPrefix == null) {
            throw new NullPointerException();
        }
        if (this.pattern.length() == 0) {
            return "file:" + HashPathIdMapper.encode(externalPrefix);
        }
        return null;
    }

    private String getPath(String uri) {
        if (this.pattern.length() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String hash = HashPathIdMapper.getHash(uri);
        int hashPos = 0;
        for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            if (c == '#') {
                builder.append(hash.charAt(hashPos++));
                continue;
            }
            builder.append(c);
        }
        builder.append('/');
        return builder.toString();
    }

    private static String getHash(String uri) {
        return MD5Utility.getBase16Hash(uri);
    }

    private static String encode(String uri) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c >= 'a' && c <= 'z') {
                out.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                out.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                out.append(c);
                continue;
            }
            if (c == '-' || c == '=' || c == '(' || c == ')' || c == '[' || c == ']' || c == ';') {
                out.append(c);
                continue;
            }
            if (c == ':') {
                out.append("%3A");
                continue;
            }
            if (c == ' ') {
                out.append("%20");
                continue;
            }
            if (c == '+') {
                out.append("%2B");
                continue;
            }
            if (c == '_') {
                out.append("%5F");
                continue;
            }
            if (c == '*') {
                out.append("%2A");
                continue;
            }
            if (c == '.') {
                if (i == uri.length() - 1) {
                    out.append("%2E");
                    continue;
                }
                out.append(".");
                continue;
            }
            try {
                out.append(URLEncoder.encode("" + c, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException wontHappen) {
                throw new RuntimeException(wontHappen);
            }
        }
        return out.toString();
    }

    private static String decode(String encodedURI) {
        if (encodedURI.endsWith("%2E")) {
            encodedURI = encodedURI.substring(0, encodedURI.length() - 3) + ".";
        }
        try {
            return URLDecoder.decode(encodedURI, "UTF-8");
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new RuntimeException(wontHappen);
        }
    }

    private static String validatePattern(String pattern) {
        if (pattern == null) {
            return "";
        }
        int count = 0;
        boolean prevWasSlash = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '#') {
                ++count;
                prevWasSlash = false;
                continue;
            }
            if (c == '/') {
                if (i == 0 || i == pattern.length() - 1) {
                    throw new IllegalArgumentException("Pattern must not begin or end with '/'");
                }
                if (prevWasSlash) {
                    throw new IllegalArgumentException("Pattern must not contain consecutive '/' characters");
                }
                prevWasSlash = true;
                continue;
            }
            throw new IllegalArgumentException("Illegal character in pattern: " + c);
        }
        if (count > 32) {
            throw new IllegalArgumentException("Pattern must not contain more than 32 '#' characters");
        }
        return pattern;
    }
}

