/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.service;

import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.storage.types.DeploymentDSBindRule;
import org.fcrepo.server.storage.types.DeploymentDSBindSpec;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DSInputSpecParser
extends DefaultHandler
implements Constants {
    private HashMap<String, String> nsPrefixMap;
    private boolean inDSInputLabel = false;
    private boolean inDSInputInstructions = false;
    private boolean inDSInputMIME = false;
    private DeploymentDSBindSpec dsInputSpec;
    private DeploymentDSBindRule dsInputRule;
    private final String sDepPID;
    private Vector<DeploymentDSBindRule> tmp_InputRules;

    public DSInputSpecParser(String parentPID) {
        this.sDepPID = parentPID;
    }

    public DSInputSpecParser(String parentPID, InputStream in) throws RepositoryConfigurationException, ObjectIntegrityException {
        this.sDepPID = parentPID;
        XMLReader xmlReader = null;
        try {
            SAXParserFactory saxfactory = SAXParserFactory.newInstance();
            saxfactory.setValidating(false);
            SAXParser parser = saxfactory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Internal SAX error while preparing for DSInputSpec datastream deserialization: " + e.getMessage());
        }
        try {
            xmlReader.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ObjectIntegrityException("Error parsing DSInputSpec datastream" + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public DeploymentDSBindSpec getServiceDSInputSpec() {
        return this.dsInputSpec;
    }

    @Override
    public void startDocument() throws SAXException {
        this.nsPrefixMap = new HashMap();
        this.tmp_InputRules = new Vector();
        this.dsInputSpec = new DeploymentDSBindSpec();
    }

    @Override
    public void endDocument() throws SAXException {
        this.dsInputSpec.dsBindRules = this.tmp_InputRules.toArray(new DeploymentDSBindRule[0]);
        this.tmp_InputRules = null;
        this.nsPrefixMap = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsPrefixMap.put(uri, prefix);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        StringBuffer sb = new StringBuffer();
        sb.append('&');
        sb.append(name);
        sb.append(';');
        char[] text = new char[sb.length()];
        sb.getChars(0, sb.length(), text, 0);
        this.characters(text, 0, text.length);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inDSInputLabel) {
            this.dsInputRule.bindingLabel = new String(ch, start, length);
        } else if (this.inDSInputInstructions) {
            this.dsInputRule.bindingInstruction = new String(ch, start, length);
        } else if (this.inDSInputMIME) {
            StringTokenizer st = new StringTokenizer(new String(ch, start, length), " ");
            String[] MIMETypes = new String[st.countTokens()];
            for (int i = 0; i < MIMETypes.length; ++i) {
                MIMETypes[i] = st.nextToken();
            }
            this.dsInputRule.bindingMIMETypes = MIMETypes;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSInputSpec")) {
            this.dsInputSpec.serviceDeploymentPID = this.sDepPID;
            this.dsInputSpec.bindSpecLabel = attrs.getValue("label");
        } else if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSInput")) {
            this.dsInputRule = new DeploymentDSBindRule();
            if (attrs.getValue("pid") != null) {
                this.dsInputRule.pid = attrs.getValue("pid");
            }
            this.dsInputRule.bindingKeyName = attrs.getValue("wsdlMsgPartName");
            this.dsInputRule.maxNumBindings = new Integer(attrs.getValue("DSMax"));
            this.dsInputRule.minNumBindings = new Integer(attrs.getValue("DSMin"));
            this.dsInputRule.ordinality = Boolean.parseBoolean(attrs.getValue("DSOrdinality"));
        } else if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSInputLabel")) {
            this.inDSInputLabel = true;
        } else if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSInputInstruction")) {
            this.inDSInputInstructions = true;
        } else if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSMIME")) {
            this.inDSInputMIME = true;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) || !localName.equalsIgnoreCase("DSInputSpec")) {
            if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSInput")) {
                this.tmp_InputRules.add(this.dsInputRule);
                this.dsInputRule = null;
            } else if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSInputLabel")) {
                this.inDSInputLabel = false;
            } else if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSInputInstruction")) {
                this.inDSInputInstructions = false;
            } else if (namespaceURI.equalsIgnoreCase(DSInputSpecParser.BINDING_SPEC.uri) && localName.equalsIgnoreCase("DSMIME")) {
                this.inDSInputMIME = false;
            }
        }
    }
}

