/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.service;

import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.storage.service.Binding;
import org.fcrepo.server.storage.service.DSInputSpecParser;
import org.fcrepo.server.storage.service.HTTPBinding;
import org.fcrepo.server.storage.service.HTTPOperationInOut;
import org.fcrepo.server.storage.service.MIMEContent;
import org.fcrepo.server.storage.service.Mmap;
import org.fcrepo.server.storage.service.MmapMethodDef;
import org.fcrepo.server.storage.service.MmapMethodParmDef;
import org.fcrepo.server.storage.service.MmapParser;
import org.fcrepo.server.storage.service.Port;
import org.fcrepo.server.storage.service.Service;
import org.fcrepo.server.storage.service.WSDLParser;
import org.fcrepo.server.storage.types.DeploymentDSBindSpec;
import org.fcrepo.server.storage.types.MethodDef;
import org.fcrepo.server.storage.types.MethodDefOperationBind;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceMapper {
    private WSDLParser wsdlHandler;
    private MmapParser methodMapHandler;
    private DSInputSpecParser dsInputSpecHandler;
    private final String parentPID;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("usage: java ServiceMapper wsdlLocation methodMapLocation \n  wsdlLocation: the file path of the wsdl to be parsed\n  methodMapLocation: the file path of the method map to be parsed.\n  dsInputSpecLocation: the file path of the datastream input spec to be parsed.  pid: the PID of the sDef or sDep object for the above files.");
            System.exit(1);
        }
        try {
            ServiceMapper mapper = new ServiceMapper(args[3]);
            InputSource wsdl = new InputSource(new FileInputStream(new File(args[0])));
            InputSource mmap = new InputSource(new FileInputStream(new File(args[1])));
            InputSource dsSpec = new InputSource(new FileInputStream(new File(args[2])));
            mapper.getMethodDefs(mmap);
            mapper.getMethodDefBindings(wsdl, mmap);
            mapper.getDSInputSpec(dsSpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public ServiceMapper(String behaviorObjectPID) {
        this.parentPID = behaviorObjectPID;
    }

    public MethodDef[] getMethodDefs(InputSource methodMapSource) throws ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        Mmap methodMap = this.getMethodMap(methodMapSource);
        return methodMap.mmapMethods;
    }

    public MethodDefOperationBind[] getMethodDefBindings(InputSource wsdlSource, InputSource methodMapSource) throws ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        return this.merge(this.getService(wsdlSource), this.getMethodMap(methodMapSource));
    }

    public DeploymentDSBindSpec getDSInputSpec(InputSource dsInputSpecSource) throws ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        if (this.dsInputSpecHandler == null) {
            this.dsInputSpecHandler = (DSInputSpecParser)this.parse(dsInputSpecSource, new DSInputSpecParser(this.parentPID));
        }
        return this.dsInputSpecHandler.getServiceDSInputSpec();
    }

    private Mmap getMethodMap(InputSource methodMapSource) throws ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        if (this.methodMapHandler == null) {
            this.methodMapHandler = (MmapParser)this.parse(methodMapSource, new MmapParser(this.parentPID));
        }
        return this.methodMapHandler.getMethodMap();
    }

    private Service getService(InputSource wsdlSource) throws ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        if (this.wsdlHandler == null) {
            this.wsdlHandler = (WSDLParser)this.parse(wsdlSource, new WSDLParser());
        }
        return this.wsdlHandler.getService();
    }

    private DefaultHandler parse(InputSource xml, DefaultHandler eventHandler) throws ObjectIntegrityException, RepositoryConfigurationException, GeneralException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            SAXParser sp = spf.newSAXParser();
            DefaultHandler handler = eventHandler;
            XMLReader xmlreader = sp.getXMLReader();
            xmlreader.setContentHandler(handler);
            xmlreader.parse(xml);
            return handler;
        }
        catch (ParserConfigurationException e) {
            String msg = "ServiceMapper returned parser error. The underlying exception was a " + e.getClass().getName() + ".  " + "The message was " + "\"" + e.getMessage() + "\"";
            throw new RepositoryConfigurationException(msg);
        }
        catch (SAXException e) {
            String msg = "ServiceMapper returned SAXException. The underlying exception was a " + e.getClass().getName() + ".  " + "The message was " + "\"" + e.getMessage() + "\"";
            throw new ObjectIntegrityException(msg);
        }
        catch (Exception e) {
            String msg = "ServiceMapper returned error. The underlying error was a " + e.getClass().getName() + ".  " + "The message was " + "\"" + e.getMessage() + "\"";
            e.printStackTrace();
            throw new GeneralException(msg);
        }
    }

    private MethodDefOperationBind[] merge(Service service, Mmap methodMap) throws ObjectIntegrityException, GeneralException {
        Port port = null;
        Binding binding = null;
        MethodDefOperationBind[] fedoraMethodDefBindings = new MethodDefOperationBind[]{};
        port = service.ports.length > 1 ? this.choosePort(service) : service.ports[0];
        binding = port.binding;
        if (binding.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.service.HTTPBinding")) {
            fedoraMethodDefBindings = new MethodDefOperationBind[((HTTPBinding)binding).operations.length];
            for (int i = 0; i < ((HTTPBinding)binding).operations.length; ++i) {
                MmapMethodDef methodDef = (MmapMethodDef)methodMap.wsdlOperationToMethodDef.get(((HTTPBinding)binding).operations[i].operationName);
                fedoraMethodDefBindings[i] = new MethodDefOperationBind();
                fedoraMethodDefBindings[i].methodName = methodDef.methodName;
                fedoraMethodDefBindings[i].methodLabel = methodDef.methodLabel;
                fedoraMethodDefBindings[i].methodParms = methodDef.methodParms;
                fedoraMethodDefBindings[i].serviceBindingAddress = port.portBaseURL;
                fedoraMethodDefBindings[i].protocolType = "HTTP";
                fedoraMethodDefBindings[i].operationLocation = ((HTTPBinding)binding).operations[i].operationLocation;
                fedoraMethodDefBindings[i].operationURL = fedoraMethodDefBindings[i].serviceBindingAddress.concat(fedoraMethodDefBindings[i].operationLocation);
                MmapMethodParmDef[] parms = methodDef.wsdlMsgParts;
                Vector<String> tmp_dsInputKeys = new Vector<String>();
                for (MmapMethodParmDef element : parms) {
                    if (!element.parmType.equalsIgnoreCase("fedora:datastreamInputType")) continue;
                    tmp_dsInputKeys.add(element.parmName);
                }
                fedoraMethodDefBindings[i].dsBindingKeys = tmp_dsInputKeys.toArray(new String[0]);
                HTTPOperationInOut oBind = ((HTTPBinding)binding).operations[i].outputBinding;
                if (oBind == null) continue;
                Vector<String> tmp_outputMIMETypes = new Vector<String>();
                for (MIMEContent element : oBind.ioMIMEContent) {
                    tmp_outputMIMETypes.add(element.mimeType);
                }
                fedoraMethodDefBindings[i].outputMIMETypes = tmp_outputMIMETypes.toArray(new String[0]);
            }
        } else if (binding.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.service.SOAPBinding")) {
            // empty if block
        }
        return fedoraMethodDefBindings;
    }

    private Port choosePort(Service service) {
        for (Port element : service.ports) {
            Binding binding = element.binding;
            if (!binding.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.service.HTTPBinding")) continue;
            return element;
        }
        return service.ports[0];
    }
}

