/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.service;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.storage.service.AbstractOperation;
import org.fcrepo.server.storage.service.Binding;
import org.fcrepo.server.storage.service.HTTPBinding;
import org.fcrepo.server.storage.service.HTTPOperation;
import org.fcrepo.server.storage.service.HTTPOperationInOut;
import org.fcrepo.server.storage.service.MIMEContent;
import org.fcrepo.server.storage.service.Message;
import org.fcrepo.server.storage.service.Part;
import org.fcrepo.server.storage.service.Port;
import org.fcrepo.server.storage.service.PortType;
import org.fcrepo.server.storage.service.SOAPBinding;
import org.fcrepo.server.storage.service.SOAPOperation;
import org.fcrepo.server.storage.service.Service;
import org.fcrepo.server.storage.service.SimpleType;
import org.fcrepo.server.storage.service.Type;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class WSDLParser
extends DefaultHandler
implements Constants {
    private HashMap<String, String> nsPrefixMap;
    private boolean inWSDLTypes = false;
    private boolean inSimpleType = false;
    private boolean inRestriction = false;
    private boolean inMessage = false;
    private boolean inPortType = false;
    private boolean inAbstractOperation = false;
    private boolean inService = false;
    private boolean inBinding = false;
    private boolean isHTTPOperation = false;
    private boolean isSOAPOperation = false;
    private boolean inInput = false;
    private boolean inOutput = false;
    private SimpleType wsdlSimpleType;
    private Message wsdlMessage;
    private Part wsdlMessagePart;
    private PortType wsdlPortType;
    private Port wsdlPort;
    private AbstractOperation wsdlOperation;
    private HTTPOperationInOut wsdlHTTPOpInOut;
    private Binding wsdlBinding;
    private Service wsdlService;
    private Hashtable<String, SimpleType> wsdlTypeTbl;
    private Hashtable<String, Message> wsdlMessageTbl;
    private Hashtable<String, String> wsdlPortBindingTbl;
    private Hashtable<String, Binding> wsdlBindingTbl;
    private Hashtable<String, AbstractOperation> wsdlAbstrOperTbl;
    private Vector<String> tmp_enum;
    private Vector<Part> tmp_parts;
    private Vector<AbstractOperation> tmp_operations;
    private String tmp_portBindingName;
    private String tmp_portBindingLocalName;
    private Vector<Port> tmp_ports;
    private String tmp_operationName;
    private String tmp_bindingName;
    private String tmp_bindingPortTypeName;
    private String tmp_bindingPortTypeLocalName;
    private Vector<AbstractOperation> tmp_bindOperations;
    private Vector<MIMEContent> tmp_MIMEContent;

    public WSDLParser() {
    }

    public WSDLParser(InputStream in) throws RepositoryConfigurationException, ObjectIntegrityException {
        XMLReader xmlReader = null;
        try {
            SAXParserFactory saxfactory = SAXParserFactory.newInstance();
            saxfactory.setValidating(false);
            SAXParser parser = saxfactory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Internal SAX error while preparing for WSDL datastream parsing: " + e.getMessage());
        }
        try {
            xmlReader.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ObjectIntegrityException("Error parsing WSDL datastream" + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public Service getService() {
        return this.wsdlService;
    }

    @Override
    public void startDocument() throws SAXException {
        this.nsPrefixMap = new HashMap();
        this.wsdlTypeTbl = new Hashtable();
        this.wsdlMessageTbl = new Hashtable();
        this.wsdlPortBindingTbl = new Hashtable();
        this.wsdlBindingTbl = new Hashtable();
        this.wsdlAbstrOperTbl = new Hashtable();
    }

    @Override
    public void endDocument() throws SAXException {
        this.doServiceJoins();
        this.wsdlTypeTbl = null;
        this.wsdlMessageTbl = null;
        this.wsdlPortBindingTbl = null;
        this.wsdlBindingTbl = null;
        this.wsdlAbstrOperTbl = null;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.nsPrefixMap.put(uri, prefix);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        StringBuffer sb = new StringBuffer();
        sb.append('&');
        sb.append(name);
        sb.append(';');
        char[] text = new char[sb.length()];
        sb.getChars(0, sb.length(), text, 0);
        this.characters(text, 0, text.length);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.checkForUnsupportedPattern(namespaceURI, localName, qName, attrs);
        if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("types")) {
            this.inWSDLTypes = true;
            return;
        } else if (this.inWSDLTypes) {
            if (namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) && localName.equalsIgnoreCase("simpleType")) {
                this.inSimpleType = true;
                this.wsdlSimpleType = new SimpleType();
                this.wsdlSimpleType.typeName = attrs.getValue("name");
                return;
            } else {
                if (!this.inSimpleType) return;
                if (namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) && localName.equalsIgnoreCase("restriction")) {
                    this.inRestriction = true;
                    this.tmp_enum = new Vector();
                    this.wsdlSimpleType.baseTypeName = attrs.getValue("base");
                    String nsprefix = null;
                    StringTokenizer st = new StringTokenizer(this.wsdlSimpleType.baseTypeName, ":");
                    if (st.hasMoreTokens()) {
                        nsprefix = st.nextToken();
                        this.wsdlSimpleType.baseTypeLocalName = st.nextToken();
                    } else {
                        this.wsdlSimpleType.baseTypeLocalName = this.wsdlSimpleType.baseTypeName;
                    }
                    if (!nsprefix.equalsIgnoreCase(this.nsPrefixMap.get(WSDLParser.XML_XSD.uri))) throw new SAXException("WSDLParser: base for simpleType cannot be other than XSD type" + this.wsdlSimpleType.baseTypeName);
                    this.wsdlSimpleType.baseTypeNamespaceURI = WSDLParser.XML_XSD.uri;
                    return;
                } else {
                    if (!this.inRestriction || !namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) || !localName.equalsIgnoreCase("enumeration")) return;
                    this.tmp_enum.add(attrs.getValue("value"));
                }
            }
            return;
        } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("message")) {
            this.inMessage = true;
            this.wsdlMessage = new Message();
            this.wsdlMessage.messageName = attrs.getValue("name");
            this.tmp_parts = new Vector();
            return;
        } else if (this.inMessage && namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("part")) {
            this.wsdlMessagePart = new Part();
            this.wsdlMessagePart.partName = attrs.getValue("name");
            this.wsdlMessagePart.partTypeName = attrs.getValue("type");
            return;
        } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("portType")) {
            this.inPortType = true;
            this.wsdlPortType = new PortType();
            this.wsdlPortType.portTypeName = attrs.getValue("name");
            this.tmp_operations = new Vector();
            return;
        } else if (this.inPortType) {
            if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("operation")) {
                this.inAbstractOperation = true;
                this.wsdlOperation = new AbstractOperation();
                this.wsdlOperation.operationName = attrs.getValue("name");
                return;
            } else {
                if (!this.inAbstractOperation) return;
                if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("input")) {
                    this.wsdlOperation.inputMessage = new Message();
                    this.wsdlOperation.inputMessage.messageName = attrs.getValue("message");
                    StringTokenizer st = new StringTokenizer(this.wsdlOperation.inputMessage.messageName, ":");
                    if (!st.hasMoreTokens()) return;
                    st.nextToken();
                    this.wsdlOperation.inputMessage.messageName = st.nextToken();
                    return;
                } else {
                    if (!namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) || !localName.equalsIgnoreCase("output")) return;
                    this.wsdlOperation.outputMessage = new Message();
                    this.wsdlOperation.outputMessage.messageName = attrs.getValue("message");
                    StringTokenizer st = new StringTokenizer(this.wsdlOperation.outputMessage.messageName, ":");
                    if (!st.hasMoreTokens()) return;
                    st.nextToken();
                    this.wsdlOperation.outputMessage.messageName = st.nextToken();
                }
            }
            return;
        } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("service")) {
            this.inService = true;
            this.wsdlService = new Service();
            this.wsdlService.serviceName = attrs.getValue("name");
            this.tmp_ports = new Vector();
            return;
        } else if (this.inService) {
            if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("port")) {
                this.wsdlPort = new Port();
                this.wsdlPort.portName = attrs.getValue("name");
                this.tmp_portBindingName = attrs.getValue("binding");
                String nsprefix = null;
                this.tmp_portBindingLocalName = null;
                StringTokenizer st = new StringTokenizer(this.tmp_portBindingName, ":");
                if (st.hasMoreTokens()) {
                    nsprefix = st.nextToken();
                    this.tmp_portBindingLocalName = st.nextToken();
                    return;
                } else {
                    this.tmp_portBindingLocalName = this.tmp_portBindingName;
                }
                return;
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_HTTP.uri) && localName.equalsIgnoreCase("address")) {
                this.wsdlPort.portBaseURL = attrs.getValue("location");
                return;
            } else {
                if (!namespaceURI.equalsIgnoreCase(WSDLParser.SOAP.uri) || !localName.equalsIgnoreCase("address")) return;
                this.wsdlPort.portBaseURL = attrs.getValue("location");
            }
            return;
        } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("binding")) {
            this.inBinding = true;
            this.tmp_bindingName = attrs.getValue("name");
            this.tmp_bindingPortTypeName = attrs.getValue("type");
            this.tmp_bindingPortTypeLocalName = null;
            StringTokenizer st = new StringTokenizer(this.tmp_bindingPortTypeName, ":");
            if (st.hasMoreTokens()) {
                String nsprefix = st.nextToken();
                this.tmp_bindingPortTypeLocalName = st.nextToken();
                return;
            } else {
                this.tmp_bindingPortTypeLocalName = this.tmp_bindingPortTypeName;
            }
            return;
        } else {
            if (!this.inBinding) return;
            if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_HTTP.uri) && localName.equalsIgnoreCase("binding")) {
                this.wsdlBinding = new HTTPBinding();
                this.wsdlBinding.bindingName = this.tmp_bindingName;
                this.wsdlBinding.portTypeLocalName = this.tmp_bindingPortTypeLocalName;
                ((HTTPBinding)this.wsdlBinding).bindingVerb = attrs.getValue("verb");
                this.tmp_bindOperations = new Vector();
                return;
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.SOAP.uri) && localName.equalsIgnoreCase("binding")) {
                this.wsdlBinding = new SOAPBinding();
                this.wsdlBinding.bindingName = this.tmp_bindingName;
                this.wsdlBinding.portTypeLocalName = this.tmp_bindingPortTypeLocalName;
                ((SOAPBinding)this.wsdlBinding).bindingStyle = attrs.getValue("style");
                ((SOAPBinding)this.wsdlBinding).bindingTransport = attrs.getValue("transport");
                this.tmp_bindOperations = new Vector();
                return;
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("operation")) {
                this.tmp_operationName = attrs.getValue("name");
                return;
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_HTTP.uri) && localName.equalsIgnoreCase("operation")) {
                this.wsdlOperation = new HTTPOperation();
                this.wsdlOperation.operationName = this.tmp_operationName;
                ((HTTPOperation)this.wsdlOperation).operationLocation = attrs.getValue("location");
                this.isHTTPOperation = true;
                return;
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.SOAP.uri) && localName.equalsIgnoreCase("operation")) {
                this.wsdlOperation = new SOAPOperation();
                this.wsdlOperation.operationName = this.tmp_operationName;
                ((SOAPOperation)this.wsdlOperation).soapAction = attrs.getValue("soapAction");
                ((SOAPOperation)this.wsdlOperation).soapActionStyle = attrs.getValue("style");
                this.isSOAPOperation = true;
                return;
            } else if (this.isHTTPOperation) {
                if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("input")) {
                    this.inInput = true;
                    this.wsdlHTTPOpInOut = new HTTPOperationInOut();
                    this.tmp_MIMEContent = new Vector();
                    return;
                } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("output")) {
                    this.inOutput = true;
                    this.wsdlHTTPOpInOut = new HTTPOperationInOut();
                    this.tmp_MIMEContent = new Vector();
                    return;
                } else {
                    if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("fault")) return;
                    if (this.inInput) {
                        if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_HTTP.uri) && localName.equalsIgnoreCase("urlReplacement")) {
                            this.wsdlHTTPOpInOut.ioBindingType = "URL_REPLACE";
                            this.wsdlHTTPOpInOut.ioMIMEContent = null;
                            return;
                        } else {
                            if (!namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_MIME.uri)) throw new SAXException("WSDLParser: Found an input extension element on HTTP operation that Fedora does not yet support: " + qName);
                            this.wsdlHTTPOpInOut.ioBindingType = "MIME";
                            this.tmp_MIMEContent.add(this.parseMIMEBinding(namespaceURI, localName, qName, attrs));
                        }
                        return;
                    } else {
                        if (!this.inOutput) return;
                        if (!namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_MIME.uri)) throw new SAXException("WSDLParser: Found an output extension element on HTTP operation that Fedora does not yet support: " + qName);
                        this.wsdlHTTPOpInOut.ioBindingType = "MIME";
                        this.tmp_MIMEContent.add(this.parseMIMEBinding(namespaceURI, localName, qName, attrs));
                    }
                }
                return;
            } else if (!this.isSOAPOperation) return;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.inWSDLTypes) {
            if (this.inSimpleType) {
                if (this.inRestriction) {
                    if (namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) && localName.equalsIgnoreCase("restriction")) {
                        this.wsdlSimpleType.enumerationOfValues = this.tmp_enum;
                        this.tmp_enum = null;
                        this.inRestriction = false;
                    }
                } else if (namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) && localName.equalsIgnoreCase("simpleType")) {
                    this.wsdlTypeTbl.put(this.wsdlSimpleType.typeName, this.wsdlSimpleType);
                    this.wsdlSimpleType = null;
                    this.inSimpleType = false;
                }
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("types")) {
                this.inWSDLTypes = false;
            }
        } else if (this.inMessage) {
            if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("part")) {
                this.tmp_parts.add(this.wsdlMessagePart);
                this.wsdlMessagePart = null;
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("message")) {
                this.wsdlMessage.messageParts = this.tmp_parts.toArray(new Part[0]);
                this.wsdlMessageTbl.put(this.wsdlMessage.messageName, this.wsdlMessage);
                this.wsdlMessage = null;
                this.tmp_parts = null;
                this.inMessage = false;
            }
        } else if (this.inPortType) {
            if (this.inAbstractOperation) {
                if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("operation")) {
                    this.tmp_operations.add(this.wsdlOperation);
                    this.wsdlOperation = null;
                    this.inAbstractOperation = false;
                }
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("portType")) {
                this.wsdlPortType.operations = this.tmp_operations.toArray(new AbstractOperation[0]);
                this.tmp_operations = null;
                this.inPortType = false;
            }
        } else if (this.inService) {
            if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("port")) {
                this.tmp_ports.add(this.wsdlPort);
                this.wsdlPortBindingTbl.put(this.wsdlPort.portName, this.tmp_portBindingLocalName);
                this.wsdlPort = null;
                this.tmp_portBindingLocalName = null;
                this.tmp_portBindingName = null;
            } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("service")) {
                this.wsdlService.ports = this.tmp_ports.toArray(new Port[0]);
                this.tmp_ports = null;
                this.inService = false;
            }
        } else if (this.inBinding) {
            if (this.isHTTPOperation) {
                if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("input")) {
                    this.wsdlHTTPOpInOut.ioMIMEContent = this.tmp_MIMEContent.toArray(new MIMEContent[0]);
                    ((HTTPOperation)this.wsdlOperation).inputBinding = this.wsdlHTTPOpInOut;
                    this.tmp_MIMEContent = null;
                    this.wsdlHTTPOpInOut = null;
                    this.inInput = false;
                } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("output")) {
                    this.wsdlHTTPOpInOut.ioMIMEContent = this.tmp_MIMEContent.toArray(new MIMEContent[0]);
                    ((HTTPOperation)this.wsdlOperation).outputBinding = this.wsdlHTTPOpInOut;
                    this.tmp_MIMEContent = null;
                    this.wsdlHTTPOpInOut = null;
                    this.inOutput = false;
                } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("operation")) {
                    this.tmp_bindOperations.add(this.wsdlOperation);
                    this.tmp_operationName = null;
                    this.isHTTPOperation = false;
                    this.wsdlOperation = null;
                }
            } else if (!this.isSOAPOperation && namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("binding")) {
                if (this.wsdlBinding.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.service.HTTPBinding")) {
                    ((HTTPBinding)this.wsdlBinding).operations = this.tmp_bindOperations.toArray(new HTTPOperation[0]);
                    this.tmp_bindOperations = null;
                } else if (this.wsdlBinding.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.service.SOAPBinding")) {
                    ((SOAPBinding)this.wsdlBinding).operations = this.tmp_bindOperations.toArray(new SOAPOperation[0]);
                    this.tmp_bindOperations = null;
                }
                this.wsdlBindingTbl.put(this.wsdlBinding.bindingName, this.wsdlBinding);
                this.wsdlBinding = null;
                this.tmp_bindingName = null;
                this.tmp_bindingPortTypeName = null;
                this.tmp_bindingPortTypeLocalName = null;
                this.inBinding = false;
            }
        }
    }

    private MIMEContent parseMIMEBinding(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        MIMEContent content = new MIMEContent();
        content.elementType = localName;
        content.messagePartName = attrs.getValue("part");
        if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_MIME.uri) && localName.equalsIgnoreCase("content")) {
            content.mimeType = attrs.getValue("type");
        } else if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_MIME.uri) && localName.equalsIgnoreCase("mimeXml")) {
            content.mimeType = "text/xml";
        } else {
            throw new SAXException("WSDLParser: Detected a MIME Binding that Fedora does not yet support:" + qName);
        }
        return content;
    }

    private void doServiceJoins() throws SAXException {
        this.doPortTypeToMessageJoin();
        this.doPortToMessageJoin();
    }

    private void doPortTypeToMessageJoin() throws SAXException {
        AbstractOperation[] absOps = this.wsdlPortType.operations;
        for (int i = 0; i < absOps.length; ++i) {
            absOps[i].inputMessage = this.doMessageToTypeJoin(this.wsdlMessageTbl.get(absOps[i].inputMessage.messageName));
            this.wsdlAbstrOperTbl.put(absOps[i].operationName, absOps[i]);
            absOps[i].outputMessage = this.doMessageToTypeJoin(this.wsdlMessageTbl.get(absOps[i].outputMessage.messageName));
            this.wsdlAbstrOperTbl.put(absOps[i].operationName, absOps[i]);
        }
        this.wsdlPortType.operations = absOps;
        this.wsdlService.portType = this.wsdlPortType;
        this.wsdlPortType = null;
    }

    private void doPortToMessageJoin() throws SAXException {
        for (int i = 0; i < this.wsdlService.ports.length; ++i) {
            this.wsdlService.ports[i].binding = this.wsdlBindingTbl.get(this.wsdlPortBindingTbl.get(this.wsdlService.ports[i].portName));
            if (this.wsdlService.ports[i].binding.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.service.HTTPBinding")) {
                for (int j = 0; j < ((HTTPBinding)this.wsdlService.ports[i].binding).operations.length; ++j) {
                    String opName = ((HTTPBinding)this.wsdlService.ports[i].binding).operations[j].operationName;
                    AbstractOperation absOp = this.wsdlAbstrOperTbl.get(opName);
                    ((HTTPBinding)this.wsdlService.ports[i].binding).operations[j].inputMessage = absOp.inputMessage;
                    ((HTTPBinding)this.wsdlService.ports[i].binding).operations[j].outputMessage = absOp.outputMessage;
                }
                continue;
            }
            if (!this.wsdlService.ports[i].binding.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.service.SOAPBinding")) continue;
        }
    }

    private Message doMessageToTypeJoin(Message msg) throws SAXException {
        for (int i = 0; i < msg.messageParts.length; ++i) {
            Type schemaType = null;
            String nsprefix = null;
            String partTypeLocalName = null;
            StringTokenizer st = new StringTokenizer(msg.messageParts[i].partTypeName, ":");
            if (st.hasMoreTokens()) {
                nsprefix = st.nextToken();
                partTypeLocalName = st.nextToken();
            } else {
                partTypeLocalName = msg.messageParts[i].partTypeName;
            }
            if (nsprefix.equalsIgnoreCase(this.nsPrefixMap.get(WSDLParser.XML_XSD.uri))) {
                msg.messageParts[i].partBaseTypeNamespaceURI = WSDLParser.XML_XSD.uri;
                msg.messageParts[i].partBaseTypeLocalName = partTypeLocalName;
                continue;
            }
            schemaType = this.wsdlTypeTbl.get(partTypeLocalName);
            if (schemaType != null) {
                if (!schemaType.getClass().getName().equalsIgnoreCase("org.fcrepo.server.storage.service.SimpleType")) continue;
                msg.messageParts[i].partBaseTypeNamespaceURI = schemaType.baseTypeNamespaceURI;
                msg.messageParts[i].partBaseTypeLocalName = schemaType.baseTypeLocalName;
                msg.messageParts[i].enumerationOfValues = ((SimpleType)schemaType).enumerationOfValues;
                continue;
            }
            throw new SAXException("WSDLParser: message part type must be XSD type or defined in WSDL as simpleType" + msg.messageParts[i].partTypeName);
        }
        return msg;
    }

    private void checkForUnsupportedPattern(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) && localName.equalsIgnoreCase("complexType")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) && localName.equalsIgnoreCase("element")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) && localName.equalsIgnoreCase("list")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.XML_XSD.uri) && localName.equalsIgnoreCase("union")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("import")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("fault")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL.uri) && localName.equalsIgnoreCase("part") && attrs.getValue("element") != null) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName + " element attr");
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.SOAP.uri) && localName.equalsIgnoreCase("binding")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_MIME.uri) && localName.equalsIgnoreCase("multipartRelated")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
        if (namespaceURI.equalsIgnoreCase(WSDLParser.WSDL_HTTP.uri) && localName.equalsIgnoreCase("urlEncoded")) {
            throw new SAXException("WSDLParser: Detected a WSDL pattern that Fedora does not yet support: " + qName);
        }
    }
}

