/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.rdf.RDFName;
import org.fcrepo.common.xml.namespace.QName;
import org.fcrepo.server.Server;
import org.fcrepo.server.config.Parameter;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.Disseminator;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.utilities.DateUtility;
import org.jrdf.graph.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DOTranslationUtility
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(DOTranslationUtility.class);
    public static final int DESERIALIZE_INSTANCE = 0;
    public static final int SERIALIZE_EXPORT_PUBLIC = 1;
    public static final int SERIALIZE_EXPORT_MIGRATE = 2;
    public static final int SERIALIZE_STORAGE_INTERNAL = 3;
    public static final int SERIALIZE_EXPORT_ARCHIVE = 4;
    public static final int AS_IS = 5;
    private static final Pattern s_fedoraLocalPattern = Pattern.compile("http://local.fedora.server/");
    private static final Pattern s_fedoraLocalAppContextPattern = Pattern.compile("http://local.fedora.server/fedora/");
    public static Pattern s_getItemPattern = Pattern.compile("/fedora-system:3/getItem\\?itemID=");
    private static Pattern s_concreteLocalUrl;
    private static Pattern s_concreteLocalUrlAppContext;
    private static Pattern s_concreteLocalUrlNoPort;
    private static Pattern s_concreteLocalUrlAppContextNoPort;
    private static String s_localDissemUrlStart;
    private static String s_hostInfo;
    private static String s_hostContextInfo;
    private static boolean m_serverOnPort80;
    private static boolean m_serverOnRedirectPort443;
    private static XMLInputFactory m_xmlInputFactory;

    public static String makeAbsoluteURLs(String input) {
        String output = input;
        output = s_fedoraLocalAppContextPattern.matcher(output).replaceAll(s_hostContextInfo);
        output = s_fedoraLocalPattern.matcher(output).replaceAll(s_hostInfo);
        logger.debug("makeAbsoluteURLs: input=" + input + ", output=" + output);
        return output;
    }

    public static String makeFedoraLocalURLs(String input) {
        String output = input;
        if (m_serverOnPort80 || m_serverOnRedirectPort443) {
            output = s_concreteLocalUrlAppContextNoPort.matcher(output).replaceAll(s_fedoraLocalAppContextPattern.pattern());
            output = s_concreteLocalUrlNoPort.matcher(output).replaceAll(s_fedoraLocalPattern.pattern());
        } else {
            output = s_concreteLocalUrlAppContext.matcher(output).replaceAll(s_fedoraLocalAppContextPattern.pattern());
            output = s_concreteLocalUrl.matcher(output).replaceAll(s_fedoraLocalPattern.pattern());
        }
        logger.debug("makeFedoraLocalURLs: input=" + input + ", output=" + output);
        return output;
    }

    private static String convertGetItemURLs(String input) {
        String output = input;
        output = s_getItemPattern.matcher(input).replaceAll("/");
        logger.debug("convertGetItemURLs: input=" + input + ", output=" + output);
        return output;
    }

    public static Datastream normalizeDSLocationURLs(String PID2, Datastream origDS, int transContext) {
        Datastream ds = origDS.copy();
        if (transContext == 5) {
            return ds;
        }
        if (transContext == 0) {
            if (ds.DSControlGrp.equals("E") || ds.DSControlGrp.equals("R")) {
                ds.DSLocation = DOTranslationUtility.makeAbsoluteURLs(ds.DSLocation);
            }
        } else if (transContext == 1) {
            if (ds.DSControlGrp.equals("E") || ds.DSControlGrp.equals("R")) {
                ds.DSLocation = DOTranslationUtility.makeAbsoluteURLs(ds.DSLocation);
            } else if (ds.DSControlGrp.equals("M")) {
                ds.DSLocation = ds.DSCreateDT == null ? s_localDissemUrlStart + PID2 + "/" + ds.DatastreamID : s_localDissemUrlStart + PID2 + "/" + ds.DatastreamID + "/" + DateUtility.convertDateToString((Date)ds.DSCreateDT);
            }
        } else if (transContext == 2) {
            if (ds.DSControlGrp.equals("E") || ds.DSControlGrp.equals("R")) {
                ds.DSLocation = DOTranslationUtility.makeFedoraLocalURLs(ds.DSLocation);
            } else if (ds.DSControlGrp.equals("M")) {
                ds.DSLocation = ds.DSCreateDT == null ? s_localDissemUrlStart + PID2 + "/" + ds.DatastreamID : s_localDissemUrlStart + PID2 + "/" + ds.DatastreamID + "/" + DateUtility.convertDateToString((Date)ds.DSCreateDT);
            }
        } else if (transContext == 3) {
            if (ds.DSControlGrp.equals("E") || ds.DSControlGrp.equals("R")) {
                ds.DSLocation = DOTranslationUtility.makeFedoraLocalURLs(ds.DSLocation);
            } else if (ds.DSControlGrp.equals("M")) {
                ds.DSLocation = PID2 + "+" + ds.DatastreamID + "+" + ds.DSVersionID;
            }
        } else if (transContext == 4) {
            if (ds.DSControlGrp.equals("E") || ds.DSControlGrp.equals("R")) {
                ds.DSLocation = DOTranslationUtility.makeFedoraLocalURLs(ds.DSLocation);
            } else if (ds.DSControlGrp.equals("M")) {
                ds.DSLocation = ds.DSCreateDT == null ? s_localDissemUrlStart + PID2 + "/" + ds.DatastreamID : s_localDissemUrlStart + PID2 + "/" + ds.DatastreamID + "/" + DateUtility.convertDateToString((Date)ds.DSCreateDT);
            }
        }
        if (ds.DSControlGrp.equals("E") || ds.DSControlGrp.equals("R")) {
            ds.DSLocation = DOTranslationUtility.convertGetItemURLs(ds.DSLocation);
        }
        return ds;
    }

    public static String normalizeInlineXML(String xml, int transContext) {
        if (transContext == 5) {
            return xml;
        }
        if (transContext == 0) {
            return DOTranslationUtility.makeAbsoluteURLs(xml);
        }
        if (transContext == 1) {
            return DOTranslationUtility.makeAbsoluteURLs(xml);
        }
        if (transContext == 2) {
            return DOTranslationUtility.makeFedoraLocalURLs(xml);
        }
        if (transContext == 3) {
            return DOTranslationUtility.makeFedoraLocalURLs(xml);
        }
        if (transContext == 4) {
            return DOTranslationUtility.makeFedoraLocalURLs(xml);
        }
        return xml;
    }

    public static Datastream setDatastreamDefaults(Datastream ds) throws ObjectIntegrityException {
        if ((ds.DSMIME == null || ds.DSMIME.equals("")) && ds.DSControlGrp.equalsIgnoreCase("X")) {
            ds.DSMIME = "text/xml";
        }
        if (ds.DSState == null || ds.DSState.equals("")) {
            ds.DSState = "A";
        }
        if (ds.DSInfoType == null || ds.DSInfoType.equals("") || ds.DSInfoType.equalsIgnoreCase("OTHER")) {
            ds.DSInfoType = "UNSPECIFIED";
        }
        if (ds.DSControlGrp.equalsIgnoreCase("X") && ((DatastreamXMLMetadata)ds).DSMDClass != 0 && ds.DSFormatURI == null) {
            String mdClassName = "";
            String mdType = ds.DSInfoType;
            String otherType = "";
            if (((DatastreamXMLMetadata)ds).DSMDClass == 1) {
                mdClassName = "techMD";
            } else if (((DatastreamXMLMetadata)ds).DSMDClass == 2) {
                mdClassName = "sourceMD";
            } else if (((DatastreamXMLMetadata)ds).DSMDClass == 3) {
                mdClassName = "rightsMD";
            } else if (((DatastreamXMLMetadata)ds).DSMDClass == 4) {
                mdClassName = "digiprovMD";
            } else if (((DatastreamXMLMetadata)ds).DSMDClass == 5) {
                mdClassName = "descMD";
            }
            if (!(mdType.equals("MARC") || mdType.equals("EAD") || mdType.equals("DC") || mdType.equals("NISOIMG") || mdType.equals("LC-AV") || mdType.equals("VRA") || mdType.equals("TEIHDR") || mdType.equals("DDI") || mdType.equals("FGDC"))) {
                mdType = "OTHER";
                otherType = ds.DSInfoType;
            }
            ds.DSFormatURI = "info:fedora/fedora-system:format/xml.mets." + mdClassName + "." + mdType + "." + otherType;
        }
        return ds;
    }

    protected static void appendXMLStream(InputStream in, PrintWriter writer, String encoding) throws ObjectIntegrityException, UnsupportedEncodingException, StreamIOException {
        if (in == null) {
            throw new ObjectIntegrityException("Object's inline xml stream cannot be null.");
        }
        try {
            int len;
            InputStreamReader chars = new InputStreamReader(in, Charset.forName(encoding));
            char[] charBuf = new char[4096];
            char[] wsBuf = new char[4096];
            int wsLen = 0;
            boolean atBeginning = true;
            while ((len = chars.read(charBuf)) != -1) {
                int start;
                int end = len - 1;
                if (atBeginning) {
                    for (start = 0; start < len && charBuf[start] <= ' '; ++start) {
                    }
                    if (start < len) {
                        atBeginning = false;
                    }
                }
                if (wsLen > 0) {
                    writer.write(wsBuf, 0, wsLen);
                    wsLen = 0;
                }
                while (end > start && charBuf[end] <= ' ') {
                    wsBuf[wsLen] = charBuf[end];
                    ++wsLen;
                    --end;
                }
                if (start >= len) continue;
                writer.write(charBuf, start, end + 1 - start);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw uee;
        }
        catch (IOException ioe) {
            throw new StreamIOException("Error reading from inline xml datastream.");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException closeProb) {
                throw new StreamIOException("Error closing read stream.");
            }
        }
    }

    public static void normalizeDatastreams(DigitalObject obj, int transContext, String characterEncoding) throws UnsupportedEncodingException {
        if (transContext == 5) {
            return;
        }
        if (obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) {
            Iterator<String> datastreams = obj.datastreamIdIterator();
            while (datastreams.hasNext()) {
                String dsid = datastreams.next();
                if (!dsid.equals("WSDL") && !dsid.equals("SERVICE-PROFILE")) continue;
                for (Datastream d : obj.datastreams(dsid)) {
                    if (!(d instanceof DatastreamXMLMetadata)) {
                        logger.warn(obj.getPid() + " : Refusing to normalize URLs in datastream " + dsid + " because it is not inline XML");
                        continue;
                    }
                    DatastreamXMLMetadata xd = (DatastreamXMLMetadata)d;
                    if (logger.isDebugEnabled()) {
                        logger.debug(obj.getPid() + " : normalising URLs in " + dsid);
                    }
                    xd.xmlContent = DOTranslationUtility.normalizeInlineXML(new String(xd.xmlContent, "UTF-8"), transContext).getBytes(characterEncoding);
                }
            }
        }
    }

    @Deprecated
    public static Disseminator setDisseminatorDefaults(Disseminator diss) throws ObjectIntegrityException {
        diss.dissVersionable = true;
        if (diss.dissState == null || diss.dissState.equals("")) {
            diss.dissState = "A";
        }
        return diss;
    }

    protected static String oneString(String[] idList) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < idList.length; ++i) {
            if (i > 0) {
                out.append(' ');
            }
            out.append(idList[i]);
        }
        return out.toString();
    }

    public static String getStateAttribute(DigitalObject obj) throws ObjectIntegrityException {
        if (obj.getState() == null || obj.getState().equals("")) {
            return DOTranslationUtility.MODEL.ACTIVE.localName;
        }
        switch (obj.getState().charAt(0)) {
            case 'D': {
                return DOTranslationUtility.MODEL.DELETED.localName;
            }
            case 'I': {
                return DOTranslationUtility.MODEL.INACTIVE.localName;
            }
            case 'A': {
                return DOTranslationUtility.MODEL.ACTIVE.localName;
            }
        }
        throw new ObjectIntegrityException("Could not determine state attribute from '" + obj.getState() + "'");
    }

    public static String readStateAttribute(String rawValue) throws ParseException {
        if (DOTranslationUtility.MODEL.DELETED.looselyMatches(rawValue, true)) {
            return "D";
        }
        if (DOTranslationUtility.MODEL.INACTIVE.looselyMatches(rawValue, true)) {
            return "I";
        }
        if (DOTranslationUtility.MODEL.ACTIVE.looselyMatches(rawValue, true) || rawValue == null || rawValue.equals("")) {
            return "A";
        }
        throw new ParseException("Could not interpret state value of '" + rawValue + "'", 0);
    }

    public static RDFName getTypeAttribute(DigitalObject obj) throws ObjectIntegrityException {
        if (obj.hasContentModel((ObjectNode)Models.SERVICE_DEFINITION_3_0)) {
            return DOTranslationUtility.MODEL.BDEF_OBJECT;
        }
        if (obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) {
            return DOTranslationUtility.MODEL.BMECH_OBJECT;
        }
        if (obj.hasContentModel((ObjectNode)Models.CONTENT_MODEL_3_0)) {
            return DOTranslationUtility.MODEL.DATA_OBJECT;
        }
        if (obj.hasContentModel((ObjectNode)Models.FEDORA_OBJECT_3_0)) {
            return DOTranslationUtility.MODEL.DATA_OBJECT;
        }
        return null;
    }

    protected static void validateAudit(AuditRecord audit) throws ObjectIntegrityException {
        if (audit.id == null || audit.id.equals("")) {
            throw new ObjectIntegrityException("Audit record must have id.");
        }
        if (audit.date == null || audit.date.equals("")) {
            throw new ObjectIntegrityException("Audit record must have date.");
        }
        if (audit.processType == null || audit.processType.equals("")) {
            throw new ObjectIntegrityException("Audit record must have processType.");
        }
        if (audit.action == null || audit.action.equals("")) {
            throw new ObjectIntegrityException("Audit record must have action.");
        }
        if (audit.componentID == null) {
            audit.componentID = "";
        }
        if (audit.responsibility == null || audit.responsibility.equals("")) {
            throw new ObjectIntegrityException("Audit record must have responsibility.");
        }
    }

    protected static String getAuditTrail(DigitalObject obj) throws ObjectIntegrityException {
        StringWriter buf = new StringWriter();
        DOTranslationUtility.appendAuditTrail(obj, new PrintWriter(buf));
        return buf.toString();
    }

    protected static void appendAuditTrail(DigitalObject obj, PrintWriter writer) throws ObjectIntegrityException {
        DOTranslationUtility.appendOpenElement(writer, DOTranslationUtility.AUDIT.AUDIT_TRAIL, true);
        for (AuditRecord audit : obj.getAuditRecords()) {
            DOTranslationUtility.validateAudit(audit);
            DOTranslationUtility.appendOpenElement(writer, DOTranslationUtility.AUDIT.RECORD, DOTranslationUtility.AUDIT.ID, audit.id);
            DOTranslationUtility.appendFullElement(writer, DOTranslationUtility.AUDIT.PROCESS, DOTranslationUtility.AUDIT.TYPE, audit.processType);
            DOTranslationUtility.appendFullElement(writer, DOTranslationUtility.AUDIT.ACTION, audit.action);
            DOTranslationUtility.appendFullElement(writer, DOTranslationUtility.AUDIT.COMPONENT_ID, audit.componentID);
            DOTranslationUtility.appendFullElement(writer, DOTranslationUtility.AUDIT.RESPONSIBILITY, audit.responsibility);
            DOTranslationUtility.appendFullElement(writer, DOTranslationUtility.AUDIT.DATE, DateUtility.convertDateToString((Date)audit.date));
            DOTranslationUtility.appendFullElement(writer, DOTranslationUtility.AUDIT.JUSTIFICATION, audit.justification);
            DOTranslationUtility.appendCloseElement(writer, DOTranslationUtility.AUDIT.RECORD);
        }
        DOTranslationUtility.appendCloseElement(writer, DOTranslationUtility.AUDIT.AUDIT_TRAIL);
    }

    protected static List<AuditRecord> getAuditRecords(XMLEventReader reader) throws XMLStreamException {
        ArrayList<AuditRecord> records = new ArrayList<AuditRecord>();
        String inElement = null;
        while (reader.hasNext()) {
            AuditRecord record;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement element = (StartElement)event;
                inElement = element.getName().getLocalPart();
                if (inElement.equals(DOTranslationUtility.AUDIT.RECORD.localName)) {
                    record = new AuditRecord();
                    Iterator<Attribute> it = element.getAttributes();
                    while (it.hasNext()) {
                        Attribute attr = it.next();
                        if (!attr.getName().getLocalPart().equals(DOTranslationUtility.AUDIT.ID.localName)) continue;
                        record.id = attr.getValue();
                    }
                    records.add(record);
                } else if (inElement.equals(DOTranslationUtility.AUDIT.PROCESS.localName)) {
                    Iterator<Attribute> it = element.getAttributes();
                    while (it.hasNext()) {
                        Attribute attr = it.next();
                        if (!attr.getName().getLocalPart().equals(DOTranslationUtility.AUDIT.TYPE.localName)) continue;
                        ((AuditRecord)records.get((int)(records.size() - 1))).processType = attr.getValue();
                    }
                }
            }
            if (event.isEndElement()) {
                inElement = "";
            }
            if (!event.isCharacters()) continue;
            Characters characters = (Characters)event;
            if (records.isEmpty()) continue;
            record = (AuditRecord)records.get(records.size() - 1);
            if (inElement.equals(DOTranslationUtility.AUDIT.ACTION.localName)) {
                record.action = characters.getData();
                continue;
            }
            if (inElement.equals(DOTranslationUtility.AUDIT.COMPONENT_ID.localName)) {
                record.componentID = characters.getData();
                continue;
            }
            if (inElement.equals(DOTranslationUtility.AUDIT.DATE.localName)) {
                record.date = DateUtility.convertStringToDate((String)characters.getData());
                continue;
            }
            if (inElement.equals(DOTranslationUtility.AUDIT.JUSTIFICATION.localName)) {
                record.justification = characters.getData();
                continue;
            }
            if (!inElement.equals(DOTranslationUtility.AUDIT.RESPONSIBILITY.localName)) continue;
            record.responsibility = characters.getData();
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<AuditRecord> getAuditRecords(InputStream auditTrail) throws XMLStreamException {
        XMLEventReader eventReader;
        XMLInputFactory xMLInputFactory = m_xmlInputFactory;
        synchronized (xMLInputFactory) {
            eventReader = m_xmlInputFactory.createXMLEventReader(auditTrail);
        }
        List<AuditRecord> records = DOTranslationUtility.getAuditRecords(eventReader);
        eventReader.close();
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<AuditRecord> getAuditRecords(Reader auditTrail) throws XMLStreamException {
        XMLEventReader eventReader;
        XMLInputFactory xMLInputFactory = m_xmlInputFactory;
        synchronized (xMLInputFactory) {
            eventReader = m_xmlInputFactory.createXMLEventReader(auditTrail);
        }
        List<AuditRecord> records = DOTranslationUtility.getAuditRecords(eventReader);
        eventReader.close();
        return records;
    }

    private static void appendOpenElement(PrintWriter writer, QName element, boolean declareNamespace) {
        writer.print("<");
        writer.print(element.qName);
        if (declareNamespace) {
            writer.print(" xmlns:");
            writer.print(element.namespace.prefix);
            writer.print("=\"");
            writer.print(element.namespace.uri);
            writer.print("\"");
        }
        writer.print(">\n");
    }

    private static void appendOpenElement(PrintWriter writer, QName element, QName attribute, String attributeContent) {
        writer.print("<");
        writer.print(element.qName);
        writer.print(" ");
        writer.print(attribute.localName);
        writer.print("=\"");
        writer.print(StreamUtility.enc(attributeContent));
        writer.print("\">\n");
    }

    private static void appendCloseElement(PrintWriter writer, QName element) {
        writer.print("</");
        writer.print(element.qName);
        writer.print(">\n");
    }

    private static void appendFullElement(PrintWriter writer, QName element, QName attribute, String attributeContent) {
        writer.print("<");
        writer.print(element.qName);
        writer.print(" ");
        writer.print(attribute.localName);
        writer.print("=\"");
        writer.print(StreamUtility.enc(attributeContent));
        writer.print("\"/>\n");
    }

    private static void appendFullElement(PrintWriter writer, QName element, String elementContent) {
        writer.print("<");
        writer.print(element.qName);
        writer.print(">");
        writer.print(StreamUtility.enc(elementContent));
        writer.print("</");
        writer.print(element.qName);
        writer.print(">\n");
    }

    static {
        s_hostInfo = null;
        m_serverOnPort80 = false;
        m_serverOnRedirectPort443 = false;
        m_xmlInputFactory = XMLInputFactory.newInstance();
        String fedoraServerHost = System.getProperty("fedora.hostname");
        String fedoraServerPort = System.getProperty("fedora.port");
        String fedoraServerPortSSL = System.getProperty("fedoraRedirectPort");
        String fedoraAppServerContext = System.getProperty("fedora.appServerContext");
        if (fedoraServerPort != null && fedoraServerPort.equals("80")) {
            m_serverOnPort80 = true;
        }
        if (fedoraServerPortSSL != null && fedoraServerPortSSL.equals("443")) {
            m_serverOnRedirectPort443 = true;
        }
        if (fedoraServerHost == null || fedoraServerPort == null || fedoraAppServerContext == null) {
            ServerConfiguration config = Server.getConfig();
            fedoraServerHost = config.getParameter("fedoraServerHost", Parameter.class).getValue();
            fedoraServerPort = config.getParameter("fedoraServerPort", Parameter.class).getValue();
            fedoraAppServerContext = config.getParameter("fedoraAppServerContext", Parameter.class).getValue();
            fedoraServerPortSSL = config.getParameter("fedoraRedirectPort", Parameter.class).getValue();
            if (fedoraServerPort.equals("80")) {
                m_serverOnPort80 = true;
            }
            if (fedoraServerPortSSL.equals("443")) {
                m_serverOnRedirectPort443 = true;
            }
        }
        s_hostInfo = "http://" + fedoraServerHost;
        if (!fedoraServerPort.equals("80") && !fedoraServerPort.equals("443")) {
            s_hostInfo = s_hostInfo + ":" + fedoraServerPort;
        }
        s_hostInfo = s_hostInfo + "/";
        s_hostContextInfo = s_hostInfo + fedoraAppServerContext + "/";
        s_localDissemUrlStart = s_hostInfo + fedoraAppServerContext + "/get/";
        s_concreteLocalUrl = Pattern.compile("https?://(localhost|" + fedoraServerHost + "):" + fedoraServerPort + "/");
        s_concreteLocalUrlAppContext = Pattern.compile("https?://(localhost|" + fedoraServerHost + "):" + fedoraServerPort + "/(" + fedoraAppServerContext + "|fedora)/");
        s_concreteLocalUrlNoPort = Pattern.compile("https?://(localhost|" + fedoraServerHost + ")/");
        s_concreteLocalUrlAppContextNoPort = Pattern.compile("https?://(localhost|" + fedoraServerHost + ")/(" + fedoraAppServerContext + "|fedora)/");
    }
}

