/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.UnsupportedTranslationException;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.DOTranslator;
import org.fcrepo.server.storage.types.DigitalObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOTranslatorImpl
implements DOTranslator {
    private static final Logger logger = LoggerFactory.getLogger(DOTranslatorImpl.class);
    private final Map<String, DOSerializer> m_serializers;
    private final Map<String, DODeserializer> m_deserializers;

    public DOTranslatorImpl(Map<String, DOSerializer> serializers, Map<String, DODeserializer> deserializers) {
        this.m_serializers = serializers;
        this.m_deserializers = deserializers;
    }

    @Override
    public void deserialize(InputStream in, DigitalObject obj, String format, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        try {
            logger.debug("Grabbing deserializer for: " + format);
            DODeserializer des = this.m_deserializers.get(format);
            if (des == null) {
                throw new UnsupportedTranslationException("No deserializer exists for format: " + format);
            }
            DODeserializer newDes = des.getInstance();
            newDes.deserialize(in, obj, encoding, transContext);
        }
        catch (UnsupportedEncodingException uee) {
            throw new UnsupportedTranslationException("Deserializer for format: " + format + " does not support encoding: " + encoding);
        }
    }

    @Override
    public void serialize(DigitalObject obj, OutputStream out, String format, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedTranslationException, ServerException {
        try {
            logger.debug("Grabbing serializer for: " + format);
            DOSerializer ser = this.m_serializers.get(format);
            if (ser == null) {
                throw new UnsupportedTranslationException("No serializer exists for format: " + format);
            }
            DOSerializer newSer = ser.getInstance();
            newSer.serialize(obj, out, encoding, transContext);
        }
        catch (UnsupportedEncodingException uee) {
            throw new UnsupportedTranslationException("Serializer for format: " + format + " does not support encoding: " + encoding);
        }
    }
}

