/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.rdf.RDFName;
import org.fcrepo.common.xml.format.XMLFormat;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.DOTranslationUtility;
import org.fcrepo.server.storage.types.DSBinding;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.Disseminator;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.utilities.StringUtility;
import org.fcrepo.utilities.Base64;
import org.fcrepo.utilities.DateUtility;
import org.jrdf.graph.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FOXMLDOSerializer
implements DOSerializer,
Constants {
    public static final XMLFormat DEFAULT_FORMAT = FOXML1_1;
    private static final Logger logger = LoggerFactory.getLogger(FOXMLDOSerializer.class);
    private final XMLFormat m_format;
    private int m_transContext;

    public FOXMLDOSerializer() {
        this.m_format = DEFAULT_FORMAT;
    }

    public FOXMLDOSerializer(XMLFormat format) {
        if (!format.equals((Object)FOXML1_0) && !format.equals((Object)FOXML1_1)) {
            throw new IllegalArgumentException("Not a FOXML format: " + format.uri);
        }
        this.m_format = format;
    }

    @Override
    public DOSerializer getInstance() {
        return new FOXMLDOSerializer(this.m_format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(DigitalObject obj, OutputStream out, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedEncodingException {
        logger.debug("Serializing " + this.m_format.uri + " for transContext: " + transContext);
        this.m_transContext = transContext;
        OutputStreamWriter osWriter = new OutputStreamWriter(out, encoding);
        PrintWriter writer = new PrintWriter(new BufferedWriter(osWriter));
        try {
            this.appendXMLDeclaration(obj, encoding, writer);
            this.appendRootElementStart(obj, writer);
            this.appendProperties(obj, writer, encoding);
            this.appendAudit(obj, writer, encoding);
            this.appendDatastreams(obj, writer, encoding);
            if (this.m_format.equals((Object)FOXML1_0)) {
                this.appendDisseminators(obj, writer);
            }
            this.appendRootElementEnd(writer);
        }
        finally {
            writer.close();
        }
    }

    private void appendXMLDeclaration(DigitalObject obj, String encoding, PrintWriter writer) {
        writer.print("<?xml version=\"1.0\" encoding=\"");
        writer.print(encoding);
        writer.print("\"?>\n");
    }

    private void appendRootElementStart(DigitalObject obj, PrintWriter writer) throws ObjectIntegrityException {
        writer.print("<");
        writer.print(FOXMLDOSerializer.FOXML.DIGITAL_OBJECT.qName);
        if (this.m_format.equals((Object)FOXML1_1)) {
            writer.print(" ");
            writer.print(FOXMLDOSerializer.FOXML.VERSION.localName);
            writer.print("=\"1.1\"");
        }
        writer.print(" ");
        writer.print(FOXMLDOSerializer.FOXML.PID.localName);
        writer.print("=\"");
        writer.print(obj.getPid());
        writer.print("\"");
        if (this.m_transContext == 1) {
            writer.print(" ");
            writer.print(FOXMLDOSerializer.FOXML.FEDORA_URI.localName);
            writer.print("=\"info:fedora/");
            writer.print(obj.getPid());
            writer.print("\"");
        }
        writer.print("\nxmlns:");
        writer.print(FOXMLDOSerializer.FOXML.prefix);
        writer.print("=\"");
        writer.print(FOXMLDOSerializer.FOXML.uri);
        writer.print("\"\nxmlns:");
        writer.print(FOXMLDOSerializer.XSI.prefix);
        writer.print("=\"");
        writer.print(FOXMLDOSerializer.XSI.uri);
        writer.print("\"\n");
        writer.print(FOXMLDOSerializer.XSI.SCHEMA_LOCATION.qName);
        writer.print("=\"");
        writer.print(FOXMLDOSerializer.FOXML.uri);
        writer.print(" ");
        writer.print(this.m_format.xsdLocation);
        writer.print("\">\n");
    }

    private void appendProperties(DigitalObject obj, PrintWriter writer, String encoding) throws ObjectIntegrityException {
        RDFName ftype;
        writer.print("<");
        writer.print(FOXMLDOSerializer.FOXML.prefix);
        writer.print(":objectProperties>\n");
        if (this.m_format.equals((Object)FOXML1_0) && (ftype = DOTranslationUtility.getTypeAttribute(obj)) != null) {
            FOXMLDOSerializer.appendProperty(FOXMLDOSerializer.RDF.TYPE.uri, ftype.uri, writer, false);
        }
        FOXMLDOSerializer.appendProperty(FOXMLDOSerializer.MODEL.STATE.uri, DOTranslationUtility.getStateAttribute(obj), writer, false);
        FOXMLDOSerializer.appendProperty(FOXMLDOSerializer.MODEL.LABEL.uri, obj.getLabel(), writer, false);
        FOXMLDOSerializer.appendProperty(FOXMLDOSerializer.MODEL.OWNER.uri, obj.getOwnerId(), writer, false);
        FOXMLDOSerializer.appendProperty(FOXMLDOSerializer.MODEL.CREATED_DATE.uri, obj.getCreateDate(), writer);
        FOXMLDOSerializer.appendProperty(FOXMLDOSerializer.VIEW.LAST_MODIFIED_DATE.uri, obj.getLastModDate(), writer);
        for (String name : obj.getExtProperties().keySet()) {
            FOXMLDOSerializer.appendProperty(name, obj.getExtProperty(name), writer, true);
        }
        writer.print("</");
        writer.print(FOXMLDOSerializer.FOXML.prefix);
        writer.print(":objectProperties>\n");
    }

    private static void appendProperty(String uri, String value, PrintWriter writer, boolean extProperty) {
        if (value != null) {
            writer.print("<");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(':');
            if (extProperty) {
                writer.print("ext");
            }
            writer.print("property NAME=\"");
            writer.print(uri);
            writer.print("\" VALUE=\"");
            writer.print(StreamUtility.enc(value));
            writer.print("\"/>\n");
        }
    }

    private static void appendProperty(String uri, Date value, PrintWriter writer) {
        if (value != null) {
            FOXMLDOSerializer.appendProperty(uri, DateUtility.convertDateToString((Date)value), writer, false);
        }
    }

    private void appendDatastreams(DigitalObject obj, PrintWriter writer, String encoding) throws ObjectIntegrityException, UnsupportedEncodingException, StreamIOException {
        Iterator<String> iter = obj.datastreamIdIterator();
        while (iter.hasNext()) {
            String dsid = iter.next();
            boolean haveWrittenCommonAttributes = false;
            if (dsid.equals("AUDIT") || dsid.equals("FEDORA-AUDITTRAIL")) continue;
            for (Datastream v : obj.datastreams(dsid)) {
                String urls;
                String altIds;
                Datastream vds = DOTranslationUtility.setDatastreamDefaults(v);
                if (!haveWrittenCommonAttributes) {
                    writer.print("<");
                    writer.print(FOXMLDOSerializer.FOXML.prefix);
                    writer.print(":datastream ID=\"");
                    writer.print(vds.DatastreamID);
                    writer.print("\"");
                    if (this.m_transContext == 1) {
                        writer.print(" FEDORA_URI=\"");
                        writer.print("info:fedora/");
                        writer.print(obj.getPid());
                        writer.print("/");
                        writer.print(vds.DatastreamID);
                        writer.print("\"");
                    }
                    writer.print(" STATE=\"");
                    writer.print(vds.DSState);
                    writer.print("\"");
                    writer.print(" CONTROL_GROUP=\"");
                    writer.print(vds.DSControlGrp);
                    writer.print("\"");
                    writer.print(" VERSIONABLE=\"");
                    writer.print(vds.DSVersionable);
                    writer.print("\">\n");
                    haveWrittenCommonAttributes = true;
                }
                writer.print("<");
                writer.print(FOXMLDOSerializer.FOXML.prefix);
                writer.print(":datastreamVersion ID=\"");
                writer.print(vds.DSVersionID);
                writer.print("\"");
                writer.print(" LABEL=\"");
                writer.print(StreamUtility.enc(vds.DSLabel));
                writer.print("\"");
                if (vds.DSCreateDT != null) {
                    writer.print(" CREATED=\"");
                    writer.print(DateUtility.convertDateToString((Date)vds.DSCreateDT));
                    writer.print("\"");
                }
                if ((altIds = DOTranslationUtility.oneString(vds.DatastreamAltIDs)) != null && !altIds.equals("")) {
                    writer.print(" ALT_IDS=\"");
                    writer.print(StreamUtility.enc(altIds));
                    writer.print("\"");
                }
                writer.print(" MIMETYPE=\"");
                writer.print(StreamUtility.enc(vds.DSMIME));
                writer.print("\"");
                if (vds.DSFormatURI != null && !vds.DSFormatURI.equals("")) {
                    writer.print(" FORMAT_URI=\"");
                    writer.print(StreamUtility.enc(vds.DSFormatURI));
                    writer.print("\"");
                }
                if (vds.DSSize != 0L) {
                    writer.print(" SIZE=\"");
                    writer.print(vds.DSSize);
                    writer.print("\"");
                }
                writer.print(">\n");
                String csType = vds.getChecksumType();
                if (csType != null && csType.length() > 0 && !csType.equals("DISABLED")) {
                    writer.print("<");
                    writer.print(FOXMLDOSerializer.FOXML.prefix);
                    writer.print(":contentDigest TYPE=\"");
                    writer.print(csType);
                    writer.print("\"");
                    writer.print(" DIGEST=\"");
                    writer.print(vds.getChecksum());
                    writer.print("\"/>\n");
                }
                if (vds.DSControlGrp.equalsIgnoreCase("E") || vds.DSControlGrp.equalsIgnoreCase("R")) {
                    writer.print("<");
                    writer.print(FOXMLDOSerializer.FOXML.prefix);
                    writer.print(":contentLocation TYPE=\"");
                    writer.print("URL");
                    writer.print("\" REF=\"");
                    urls = DOTranslationUtility.normalizeDSLocationURLs((String)obj.getPid(), (Datastream)vds, (int)this.m_transContext).DSLocation;
                    writer.print(StreamUtility.enc(urls));
                    writer.print("\"/>\n");
                } else if (vds.DSControlGrp.equalsIgnoreCase("M")) {
                    if (this.m_transContext == 4) {
                        writer.print("<");
                        writer.print(FOXMLDOSerializer.FOXML.prefix);
                        writer.print(":binaryContent> \n");
                        String encoded = Base64.encodeToString((InputStream)vds.getContentStream());
                        writer.print(StringUtility.splitAndIndent(encoded, 14, 80));
                        writer.print("</");
                        writer.print(FOXMLDOSerializer.FOXML.prefix);
                        writer.print(":binaryContent> \n");
                    } else {
                        writer.print("<");
                        writer.print(FOXMLDOSerializer.FOXML.prefix);
                        writer.print(":contentLocation TYPE=\"");
                        writer.print("INTERNAL_ID");
                        writer.print("\" REF=\"");
                        urls = DOTranslationUtility.normalizeDSLocationURLs((String)obj.getPid(), (Datastream)vds, (int)this.m_transContext).DSLocation;
                        writer.print(StreamUtility.enc(urls));
                        writer.print("\"/>\n");
                    }
                } else if (vds.DSControlGrp.equalsIgnoreCase("X")) {
                    this.appendInlineXML(obj, (DatastreamXMLMetadata)vds, writer, encoding);
                }
                writer.print("</");
                writer.print(FOXMLDOSerializer.FOXML.prefix);
                writer.print(":datastreamVersion>\n");
            }
            writer.print("</");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(":datastream>\n");
        }
    }

    private void appendAudit(DigitalObject obj, PrintWriter writer, String encoding) throws ObjectIntegrityException {
        if (obj.getAuditRecords().size() > 0) {
            writer.print("<");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(":datastream ID=\"");
            writer.print("AUDIT\"");
            if (this.m_transContext == 1) {
                writer.print(" FEDORA_URI=\"info:fedora/");
                writer.print(obj.getPid());
                writer.print("/AUDIT\"");
            }
            writer.print(" STATE=\"A\" CONTROL_GROUP=\"X\" VERSIONABLE=\"false\">\n");
            writer.print("<");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(":datastreamVersion ID=\"AUDIT.0\" LABEL=\"");
            writer.print("Audit Trail for this object\" CREATED=\"");
            writer.print(DateUtility.convertDateToString((Date)obj.getCreateDate()));
            writer.print("\" MIMETYPE=\"text/xml\" FORMAT_URI=\"");
            writer.print(FOXMLDOSerializer.AUDIT1_0.uri);
            writer.print("\">\n");
            writer.print("<");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(":xmlContent>\n");
            DOTranslationUtility.appendAuditTrail(obj, writer);
            writer.print("</");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(":xmlContent>\n");
            writer.print("</");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(":datastreamVersion>\n");
            writer.print("</");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(":datastream>\n");
        }
    }

    private void appendInlineXML(DigitalObject obj, DatastreamXMLMetadata ds, PrintWriter writer, String encoding) throws ObjectIntegrityException, UnsupportedEncodingException, StreamIOException {
        writer.print("<");
        writer.print(FOXMLDOSerializer.FOXML.prefix);
        writer.print(":xmlContent>\n");
        if (obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0) && (ds.DatastreamID.equals("SERVICE-PROFILE") || ds.DatastreamID.equals("WSDL"))) {
            writer.print(DOTranslationUtility.normalizeInlineXML(new String(ds.xmlContent, "UTF-8").trim(), this.m_transContext));
        } else {
            DOTranslationUtility.appendXMLStream(ds.getContentStream(), writer, encoding);
        }
        writer.print("\n</");
        writer.print(FOXMLDOSerializer.FOXML.prefix);
        writer.print(":xmlContent>\n");
    }

    private void appendDisseminators(DigitalObject obj, PrintWriter writer) throws ObjectIntegrityException {
        Iterator<String> dissIdIter = obj.disseminatorIdIterator();
        while (dissIdIter.hasNext()) {
            String did = dissIdIter.next();
            List<Disseminator> dissList = obj.disseminators(did);
            for (int i = 0; i < dissList.size(); ++i) {
                Disseminator vdiss = DOTranslationUtility.setDisseminatorDefaults(obj.disseminators(did).get(i));
                if (i == 0) {
                    writer.print("<");
                    writer.print(FOXMLDOSerializer.FOXML.prefix);
                    writer.print(":disseminator ID=\"");
                    writer.print(did);
                    writer.print("\" BDEF_CONTRACT_PID=\"");
                    writer.print(vdiss.bDefID);
                    writer.print("\" STATE=\"");
                    writer.print(vdiss.dissState);
                    writer.print("\" VERSIONABLE=\"");
                    writer.print(vdiss.dissVersionable);
                    writer.print("\">\n");
                }
                writer.print("<");
                writer.print(FOXMLDOSerializer.FOXML.prefix);
                writer.print(":disseminatorVersion ID=\"");
                writer.print(vdiss.dissVersionID);
                writer.print("\"");
                if (vdiss.dissLabel != null && !vdiss.dissLabel.equals("")) {
                    writer.print(" LABEL=\"");
                    writer.print(StreamUtility.enc(vdiss.dissLabel));
                    writer.print("\"");
                }
                writer.print(" BMECH_SERVICE_PID=\"");
                writer.print(vdiss.sDepID);
                writer.print("\"");
                if (vdiss.dissCreateDT != null) {
                    writer.print(" CREATED=\"");
                    writer.print(DateUtility.convertDateToString((Date)vdiss.dissCreateDT));
                    writer.print("\"");
                }
                writer.print(">\n");
                DSBinding[] bindings = vdiss.dsBindMap.dsBindings;
                writer.print("<");
                writer.print(FOXMLDOSerializer.FOXML.prefix);
                writer.print(":serviceInputMap>\n");
                for (int j = 0; j < bindings.length; ++j) {
                    if (bindings[j].seqNo == null) {
                        bindings[j].seqNo = "";
                    }
                    writer.print("<");
                    writer.print(FOXMLDOSerializer.FOXML.prefix);
                    writer.print(":datastreamBinding KEY=\"");
                    writer.print(bindings[j].bindKeyName);
                    writer.print("\" DATASTREAM_ID=\"");
                    writer.print(bindings[j].datastreamID);
                    writer.print("\"");
                    if (bindings[j].bindLabel != null && !bindings[j].bindLabel.equals("")) {
                        writer.print(" LABEL=\"");
                        writer.print(StreamUtility.enc(bindings[j].bindLabel));
                        writer.print("\"");
                    }
                    if (bindings[j].seqNo != null && !bindings[j].seqNo.equals("")) {
                        writer.print(" ORDER=\"");
                        writer.print(bindings[j].seqNo);
                        writer.print("\"");
                    }
                    writer.print("/>\n");
                }
                writer.print("</");
                writer.print(FOXMLDOSerializer.FOXML.prefix);
                writer.print(":serviceInputMap>\n");
                writer.print("</");
                writer.print(FOXMLDOSerializer.FOXML.prefix);
                writer.print(":disseminatorVersion>\n");
            }
            writer.print("</");
            writer.print(FOXMLDOSerializer.FOXML.prefix);
            writer.print(":disseminator>\n");
        }
    }

    private void appendRootElementEnd(PrintWriter writer) {
        writer.print("</");
        writer.print(FOXMLDOSerializer.FOXML.prefix);
        writer.print(":digitalObject>");
    }
}

