/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.InitializationException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.lowlevel.ILowlevelStorage;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.validation.ValidationUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastreamManagedContent
extends Datastream {
    private static final Logger logger = LoggerFactory.getLogger(DatastreamManagedContent.class);
    public static final String COPY_SCHEME = "copy://";
    public static final String TEMP_SCHEME = "temp://";
    public static final String UPLOADED_SCHEME = "uploaded://";
    private static ILowlevelStorage s_llstore;
    private static Server m_server;
    private static ExternalContentManager s_ecm;
    private static File m_tempUploadDir;
    public int DSMDClass = 0;

    @Override
    public Datastream copy() {
        DatastreamManagedContent ds = new DatastreamManagedContent();
        this.copy(ds);
        return ds;
    }

    private ILowlevelStorage getLLStore() throws Exception {
        if (s_llstore == null) {
            try {
                s_llstore = (ILowlevelStorage)((Object)this.getServer().getModule("org.fcrepo.server.storage.lowlevel.ILowlevelStorage"));
            }
            catch (InitializationException ie) {
                throw new Exception("Unable to get LLStore Module: " + ie.getMessage(), ie);
            }
        }
        return s_llstore;
    }

    private File getTempUploadDir() throws Exception {
        if (m_tempUploadDir == null) {
            try {
                m_tempUploadDir = this.getServer().getUploadDir();
            }
            catch (InitializationException e) {
                throw new Exception("Unable to get server: " + e.getMessage(), e);
            }
        }
        return m_tempUploadDir;
    }

    private Server getServer() throws Exception {
        if (m_server == null) {
            try {
                m_server = Server.getInstance(new File(Constants.FEDORA_HOME), false);
            }
            catch (InitializationException e) {
                throw new Exception("Unable to get Server: " + e.getMessage(), e);
            }
        }
        return m_server;
    }

    private ExternalContentManager getExternalContentManager() throws Exception {
        if (s_ecm == null) {
            try {
                s_ecm = (ExternalContentManager)((Object)this.getServer().getModule("org.fcrepo.server.storage.ExternalContentManager"));
            }
            catch (InitializationException e) {
                throw new Exception("Unable to get ExternalContentManager Module: " + e.getMessage(), e);
            }
        }
        return s_ecm;
    }

    @Override
    public InputStream getContentStream(Context ctx) throws StreamIOException {
        try {
            if (this.DSLocation.startsWith(UPLOADED_SCHEME)) {
                String internalId = this.DSLocation.substring(UPLOADED_SCHEME.length());
                File uploadedFile = new File(this.getTempUploadDir(), internalId);
                if (uploadedFile.exists()) {
                    return new FileInputStream(uploadedFile);
                }
                throw new StreamIOException("Uploaded file " + this.DSLocation + " no longer exists.");
            }
            if (this.DSLocation.startsWith(TEMP_SCHEME)) {
                String fileName = this.DSLocation.substring(TEMP_SCHEME.length());
                File tempFile = new File(fileName);
                if (tempFile.exists()) {
                    return new FileInputStream(tempFile);
                }
                throw new StreamIOException("Temp file " + this.DSLocation + " no longer exists.");
            }
            if ("INTERNAL_ID".equals(this.DSLocationType)) {
                return this.getLLStore().retrieveDatastream(this.DSLocation);
            }
            if ("URL".equals(this.DSLocationType)) {
                ValidationUtility.validateURL(this.DSLocation, this.DSControlGrp);
                if (ctx == null) {
                    ctx = ReadOnlyContext.getContext(null, null, "", false);
                }
                ContentManagerParams params = new ContentManagerParams(this.DSLocation);
                params.setContext(ctx);
                MIMETypedStream stream = this.getExternalContentManager().getExternalContent(params);
                File tempFile = File.createTempFile("managedcontentupdate", null);
                FileOutputStream os = new FileOutputStream(tempFile);
                StreamUtility.pipeStream(stream.getStream(), os, 32768);
                this.DSLocation = TEMP_SCHEME + tempFile.getAbsolutePath();
                return new FileInputStream(new File(tempFile.getAbsolutePath()));
            }
        }
        catch (Throwable th) {
            throw new StreamIOException("[DatastreamManagedContent] returned  the error: \"" + th.getClass().getName() + "\". Reason: " + th.getMessage(), th);
        }
        throw new StreamIOException("[DatastreamManagedContent] could not resolve dsLocation " + this.DSLocation + " dsLocationType " + this.DSLocationType);
    }

    public void putContentStream(MIMETypedStream stream) throws StreamIOException {
        String oldDSLocation = this.DSLocation;
        try {
            File tempFile = File.createTempFile("managedcontentupdate", null);
            FileOutputStream os = new FileOutputStream(tempFile);
            StreamUtility.pipeStream(stream.getStream(), os, 32768);
            this.DSLocation = TEMP_SCHEME + tempFile.getAbsolutePath();
        }
        catch (Exception e) {
            throw new StreamIOException("Error creating new temp file for updated managed content (existing content is:" + oldDSLocation + ")", e);
        }
        if (oldDSLocation != null && oldDSLocation.startsWith(TEMP_SCHEME)) {
            File oldFile;
            try {
                oldFile = new File(oldDSLocation.substring(TEMP_SCHEME.length()));
            }
            catch (Exception e) {
                throw new StreamIOException("Error removing old temp file while updating managed content (location: " + oldDSLocation + ")", e);
            }
            if (oldFile.exists()) {
                if (!oldFile.delete()) {
                    logger.warn("Failed to delete temp file, marked for deletion when VM closes " + oldFile.getAbsolutePath());
                    oldFile.deleteOnExit();
                }
            } else {
                logger.warn("Cannot delete temp file as it no longer exists " + oldFile.getAbsolutePath());
            }
        }
    }
}

