/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import org.fcrepo.common.Constants;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;

public abstract class DigitalObjectUtil
implements Constants {
    public static void updateLegacyDatastreams(DigitalObject obj) {
        String xml = "text/xml";
        String rdf = "application/rdf+xml";
        DigitalObjectUtil.updateLegacyDatastream(obj, "DC", "text/xml", DigitalObjectUtil.OAI_DC2_0.uri);
        DigitalObjectUtil.updateLegacyDatastream(obj, "RELS-EXT", "application/rdf+xml", DigitalObjectUtil.RELS_EXT1_0.uri);
        DigitalObjectUtil.updateLegacyDatastream(obj, "RELS-INT", "application/rdf+xml", DigitalObjectUtil.RELS_INT1_0.uri);
        DigitalObjectUtil.updateLegacyDatastream(obj, "POLICY", "text/xml", DigitalObjectUtil.XACML_POLICY1_0.uri);
        String fType = obj.getExtProperty(DigitalObjectUtil.RDF.TYPE.uri);
        if (DigitalObjectUtil.MODEL.BDEF_OBJECT.looselyMatches(fType, false)) {
            DigitalObjectUtil.updateLegacyDatastream(obj, "METHODMAP", "text/xml", DigitalObjectUtil.SDEF_METHOD_MAP1_0.uri);
        } else if (DigitalObjectUtil.MODEL.BMECH_OBJECT.looselyMatches(fType, false)) {
            DigitalObjectUtil.updateLegacyDatastream(obj, "METHODMAP", "text/xml", DigitalObjectUtil.SDEP_METHOD_MAP1_1.uri);
            DigitalObjectUtil.updateLegacyDatastream(obj, "DSINPUTSPEC", "text/xml", DigitalObjectUtil.DS_INPUT_SPEC1_1.uri);
            DigitalObjectUtil.updateLegacyDatastream(obj, "WSDL", "text/xml", DigitalObjectUtil.WSDL.uri);
        }
    }

    private static void updateLegacyDatastream(DigitalObject obj, String dsId, String mimeType, String formatURI) {
        for (Datastream ds : obj.datastreams(dsId)) {
            ds.DSMIME = mimeType;
            ds.DSFormatURI = formatURI;
        }
    }
}

