/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.rdf.SimpleLiteral;
import org.fcrepo.common.rdf.SimpleTriple;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;

public class TupleArrayTripleIterator
extends TripleIterator {
    int size = 0;
    int index = 0;
    ArrayList<RelationshipTuple> m_TupleArray = null;
    Map<String, String> m_map = null;

    public TupleArrayTripleIterator(ArrayList<RelationshipTuple> array, Map<String, String> map) {
        this.m_TupleArray = array;
        this.size = array.size();
        this.m_map = map;
    }

    public TupleArrayTripleIterator(ArrayList<RelationshipTuple> array) {
        this.m_TupleArray = array;
        this.size = array.size();
        this.m_map = new HashMap<String, String>();
        this.m_map.put("rel", "info:fedora/fedora-system:def/relations-external#");
        this.m_map.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    }

    public boolean hasNext() throws TrippiException {
        return this.index < this.size;
    }

    public Triple next() throws TrippiException {
        RelationshipTuple tuple = this.m_TupleArray.get(this.index++);
        try {
            SimpleTriple triple = new SimpleTriple((SubjectNode)new SimpleURIReference(new URI(tuple.subject)), TupleArrayTripleIterator.makePredicateResourceFromRel(tuple.predicate, this.m_map), TupleArrayTripleIterator.makeObjectFromURIandLiteral(tuple.object, tuple.isLiteral, tuple.datatype));
            return triple;
        }
        catch (URISyntaxException e) {
            throw new TrippiException("Invalid URI in Triple", (Throwable)e);
        }
    }

    public static ObjectNode makeObjectFromURIandLiteral(String objURI, boolean isLiteral, String literalType) throws URISyntaxException {
        Object obj = null;
        obj = isLiteral ? (literalType == null || literalType.length() == 0 ? new SimpleLiteral(objURI) : new SimpleLiteral(objURI, new URI(literalType))) : new SimpleURIReference(new URI(objURI));
        return obj;
    }

    public static PredicateNode makePredicateResourceFromRel(String predicate, Map<String, String> map) throws URISyntaxException {
        URI predURI = TupleArrayTripleIterator.makePredicateFromRel(predicate, map);
        SimpleURIReference node = new SimpleURIReference(predURI);
        return node;
    }

    public static URI makePredicateFromRel(String relationship, Map map) throws URISyntaxException {
        String predicate = relationship;
        Set keys = map.keySet();
        for (String key : keys) {
            if (!predicate.startsWith(key + ":")) continue;
            predicate = predicate.replaceFirst(key + ":", (String)map.get(key));
        }
        URI retVal = null;
        retVal = new URI(predicate);
        return retVal;
    }

    public void close() throws TrippiException {
    }
}

