/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.test;

import java.util.Date;
import junit.framework.TestCase;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;

public class DigitalObjectTest
extends TestCase {
    private DigitalObject m_obj;
    private DigitalObject m_sdef;
    private DigitalObject m_sdep;
    private Date m_startTime;
    private Datastream m_ds1_0;
    private Datastream m_ds1_1;
    private Datastream m_ds2_0;
    private AuditRecord m_audit1;
    private AuditRecord m_audit2;
    private AuditRecord m_audit3;
    private AuditRecord m_audit4;
    private AuditRecord m_audit5;
    private AuditRecord m_audit6;
    private AuditRecord m_audit7;

    public DigitalObjectTest(String label) {
        super(label);
    }

    public void setUp() {
        this.m_startTime = new Date();
        this.m_obj = new BasicDigitalObject();
        this.m_obj.setCreateDate(this.m_startTime);
        this.m_obj.setLabel("Test Object");
        this.m_obj.setLastModDate(this.m_startTime);
        this.m_obj.setOwnerId("userId1");
        this.m_obj.setPid("test:1");
        this.m_obj.setState("A");
        this.m_ds1_0 = new Datastream();
        this.m_ds1_0.DatastreamID = "DS1.0";
        this.m_ds1_0.DSVersionID = "DS1";
        this.m_ds1_1 = new Datastream();
        this.m_ds1_1.DatastreamID = "DS1.1";
        this.m_ds1_1.DSVersionID = "DS1";
        this.m_ds2_0 = new Datastream();
        this.m_ds2_0.DatastreamID = "DS2.0";
        this.m_ds2_0.DSVersionID = "DS2";
        this.m_audit1 = new AuditRecord();
        this.m_audit1.id = "AUDIT1";
        this.m_audit1.action = "Object Created";
        this.m_audit2 = new AuditRecord();
        this.m_audit2.id = "AUDIT2";
        this.m_audit2.action = "Datastream 1 Added";
        this.m_audit3 = new AuditRecord();
        this.m_audit3.id = "AUDIT3";
        this.m_audit3.action = "Datastream 1 Versioned";
        this.m_audit4 = new AuditRecord();
        this.m_audit4.id = "AUDIT4";
        this.m_audit4.action = "Datastream 2 Added";
        this.m_audit5 = new AuditRecord();
        this.m_audit5.id = "AUDIT5";
        this.m_audit5.action = "Disseminator 1 Added";
        this.m_audit6 = new AuditRecord();
        this.m_audit6.id = "AUDIT6";
        this.m_audit6.action = "Disseminator 1 Versioned";
        this.m_audit7 = new AuditRecord();
        this.m_audit7.id = "AUDIT7";
        this.m_audit7.action = "Disseminator 2 Added";
        this.m_sdef = new BasicDigitalObject();
        this.m_sdef.setCreateDate(this.m_startTime);
        this.m_sdef.setLabel("Test Service Definition Object");
        this.m_sdef.setLastModDate(this.m_startTime);
        this.m_sdef.setOwnerId("userId2");
        this.m_sdef.setPid("test:2");
        this.m_sdef.setState("W");
        this.m_sdep = new BasicDigitalObject();
        this.m_sdep.setCreateDate(this.m_startTime);
        this.m_sdep.setLabel("Test Service Deployment Object");
        this.m_sdep.setLastModDate(this.m_startTime);
        this.m_sdep.setOwnerId("userId3");
        this.m_sdep.setPid("test:3");
        this.m_sdep.setState("D");
    }

    public void testSimpleParts() {
        DigitalObjectTest.assertEquals((Object)this.m_obj.getCreateDate(), (Object)this.m_startTime);
        DigitalObjectTest.assertEquals((Object)this.m_sdef.getCreateDate(), (Object)this.m_startTime);
        DigitalObjectTest.assertEquals((Object)this.m_sdep.getCreateDate(), (Object)this.m_startTime);
        DigitalObjectTest.assertEquals((String)this.m_obj.getLabel(), (String)"Test Object");
        DigitalObjectTest.assertEquals((String)this.m_sdef.getLabel(), (String)"Test Service Deployment Object");
        DigitalObjectTest.assertEquals((String)this.m_sdep.getLabel(), (String)"Test Service Deployment Object");
        DigitalObjectTest.assertEquals((Object)this.m_obj.getLastModDate(), (Object)this.m_startTime);
        DigitalObjectTest.assertEquals((Object)this.m_sdef.getLastModDate(), (Object)this.m_startTime);
        DigitalObjectTest.assertEquals((Object)this.m_sdep.getLastModDate(), (Object)this.m_startTime);
        DigitalObjectTest.assertEquals((String)this.m_obj.getOwnerId(), (String)"userId1");
        DigitalObjectTest.assertEquals((String)this.m_sdef.getOwnerId(), (String)"userId2");
        DigitalObjectTest.assertEquals((String)this.m_sdep.getOwnerId(), (String)"userId3");
        DigitalObjectTest.assertEquals((String)this.m_obj.getPid(), (String)"test:1");
        DigitalObjectTest.assertEquals((String)this.m_sdef.getPid(), (String)"test:2");
        DigitalObjectTest.assertEquals((String)this.m_sdep.getPid(), (String)"test:3");
        DigitalObjectTest.assertEquals((String)this.m_obj.getState(), (String)"A");
        DigitalObjectTest.assertEquals((String)this.m_sdef.getState(), (String)"W");
        DigitalObjectTest.assertEquals((String)this.m_sdep.getState(), (String)"D");
    }

    public void testAuditRecordComposition() {
        this.m_obj.getAuditRecords().add(this.m_audit1);
    }

    public void testDatastreamComposition() {
        this.m_obj.getAuditRecords().add(this.m_audit2);
        this.m_obj.addDatastreamVersion(this.m_ds1_0, true);
        this.m_obj.getAuditRecords().add(this.m_audit3);
        this.m_obj.addDatastreamVersion(this.m_ds1_1, true);
        this.m_obj.getAuditRecords().add(this.m_audit4);
        this.m_obj.addDatastreamVersion(this.m_ds2_0, true);
    }

    public void testDisseminatorComposition() {
    }
}

