/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.DOTranslatorImpl;
import org.fcrepo.server.storage.translation.FOXML1_1DODeserializer;
import org.fcrepo.server.storage.translation.FOXML1_1DOSerializer;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.DigitalObject;

public class FOXMLInOutTest
extends TestCase
implements Constants {
    protected File inFile = null;
    protected File outFile = null;
    protected DigitalObject obj = null;

    protected void setUp() {
        this.inFile = new File("TestIngestFiles/foxml-simple-nodissem.xml");
        this.outFile = new File("TestExportFiles/STORE-foxml.xml");
        System.setProperty("fedoraServerHost", "localhost");
        System.setProperty("fedoraServerPort", "8080");
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.inFile);
        }
        catch (IOException ioe) {
            System.out.println("Error on FOXML file inputstream: " + ioe.getMessage());
            ioe.printStackTrace();
        }
        try {
            FOXML1_1DODeserializer deser = new FOXML1_1DODeserializer();
            FOXML1_1DOSerializer ser = new FOXML1_1DOSerializer();
            HashMap<String, DODeserializer> desermap = new HashMap<String, DODeserializer>();
            HashMap<String, DOSerializer> sermap = new HashMap<String, DOSerializer>();
            desermap.put(FOXMLInOutTest.FOXML1_1.uri, deser);
            DOTranslatorImpl trans = new DOTranslatorImpl(sermap, desermap);
            this.obj = new BasicDigitalObject();
            System.out.println("Deserializing...");
            trans.deserialize(in, this.obj, FOXMLInOutTest.FOXML1_1.uri, "UTF-8", 0);
            System.out.println("Digital Object PID= " + this.obj.getPid());
            sermap.put(FOXMLInOutTest.FOXML1_1.uri, ser);
            System.out.println("Re-serializing...");
            System.out.println("Writing file to... " + this.outFile.getPath());
            FileOutputStream out = new FileOutputStream(this.outFile);
            int m_transContext = 2;
            trans.serialize(this.obj, out, FOXMLInOutTest.FOXML1_1.uri, "UTF-8", m_transContext);
            System.out.println("Done. Serialized for context: " + m_transContext);
        }
        catch (ServerException e) {
            System.out.println("ServerException: suppressing info not available without running server.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception: (" + e.getClass().getName() + "):" + e.getMessage());
        }
    }

    public void testDigitalObject() {
    }
}

