/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.fcrepo.server.journal.helpers.DecodingBase64OutputStream;
import org.fcrepo.server.journal.helpers.EncodingBase64InputStream;

public class JournalBase64Test
extends TestCase {
    private static final String WHITE_SPACE_CHARACTERS = " \t\n\r";
    private static final String BASE64_ENCODING_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public JournalBase64Test(String name) {
        super(name);
    }

    public void testOnArbitraryBytes() throws IOException {
        File source = this.createTempFile();
        FileOutputStream os = new FileOutputStream(source);
        for (int i = -128; i <= 127; ++i) {
            ((OutputStream)os).write(i);
        }
        ((OutputStream)os).close();
        this.encodeAndDecodeWithAssertions(source);
    }

    public void testOnUTF8Characters() throws IOException {
        File source = this.createTempFile();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(source), "UTF-8");
        int charValue = 0;
        for (int i = 0; i < 256; ++i) {
            ((Writer)writer).write(charValue);
            charValue += 131;
        }
        ((Writer)writer).close();
        this.encodeAndDecodeWithAssertions(source);
    }

    public void testOnKnownProblemFile() throws IOException {
        byte[] problemData = new byte[]{115, 0, 111, 0, 117, 0, 114, 0, 99, 0, 101, 0, 115, 0, 32, 0, 97, 0, 110, 0, 100, 0, 32, 0, 108, 0, 101, 0, 97, 0, 114, 0, 110, 0, 105, 0, 110, 0, 103, 0, 32, 0, 97, 0, 99, 0, 116, 0, 105, 0, 118, 0, 105, 0, 116, 0, 105, 0, 101, 0, 115, 0, 32, 0, 116, 0, 104, 0, 97, 0, 116, 0, 32, 0, 114, 0, 101, 0, 102, 0, 108, 0, 101, 0, 99, 0, 116, 0, 32, 0, 116, 0, 104, 0, 101, 0, 32, 0, 109, 0, 117, 0, 115, 0, 101, 0, 117, 0, 109, 0, -30, 0, -84, 32, 34, 33, 115, 0, 32, 0, 102, 0, 111, 0, 117, 0, 110, 0, 100, 0, 97, 0, 116, 0, 105, 0, 111, 0, 110, 0, 32, 0, 111, 0, 102, 0, 32, 0, 112, 0, 108, 0, 97, 0, 121, 0, 102, 0, 117, 0, 108, 0, 32, 0, 101, 0, 120, 0, 104, 0, 105, 0, 98, 0, 105, 0, 116, 0, 45, 0, 98, 0, 97, 0, 115, 0, 101, 0, 100, 0, 32, 0, 105, 0, 110, 0, 113, 0, 117, 0, 105, 0, 114, 0, 121, 0, 32, 0};
        File source = this.createTempFile();
        FileOutputStream os = new FileOutputStream(source);
        ((OutputStream)os).write(problemData);
        ((OutputStream)os).close();
        this.encodeAndDecodeWithAssertions(source);
    }

    private File createTempFile() throws IOException {
        File file = File.createTempFile("test", null);
        System.out.println(file.getPath());
        file.deleteOnExit();
        return file;
    }

    private void encodeAndDecodeWithAssertions(File source) throws FileNotFoundException, IOException {
        String encodedString = this.readClearFileCreateEncodedString(source);
        this.assertStringContainsValidBase64(encodedString);
        File target = this.createTempFile();
        this.writeClearFileFromEncodedString(target, encodedString);
        this.assertFileContentsAreEqual(source, target);
    }

    private String readClearFileCreateEncodedString(File source) throws IOException {
        String chunk;
        EncodingBase64InputStream encoder = new EncodingBase64InputStream(new FileInputStream(source), 61);
        StringBuffer encoded = new StringBuffer();
        while (null != (chunk = encoder.read(35))) {
            encoded.append(chunk);
        }
        encoder.close();
        String encodedString = encoded.toString();
        return encodedString;
    }

    private void writeClearFileFromEncodedString(File target, String encodedString) throws FileNotFoundException, IOException {
        int remainder;
        int maxChunkSize = 61;
        int length = encodedString.length();
        DecodingBase64OutputStream decoder = new DecodingBase64OutputStream(new FileOutputStream(target));
        int start = 0;
        while (0 < (remainder = length - start)) {
            int chunkSize = Math.min(remainder, maxChunkSize);
            String chunk = encodedString.substring(start, start + chunkSize);
            decoder.write(chunk);
            start += chunkSize;
        }
        decoder.close();
    }

    private void assertStringContainsValidBase64(String string) {
        int totalCharacters;
        int howManyEqualsSigns = 0;
        int howManyEncodingCharacters = 0;
        for (int i = 0; i < string.length(); ++i) {
            char thisChar = string.charAt(i);
            if (thisChar == '=') {
                ++howManyEqualsSigns;
                continue;
            }
            if (BASE64_ENCODING_CHARACTERS.indexOf(thisChar) != -1) {
                ++howManyEncodingCharacters;
                if (howManyEqualsSigns <= 0) continue;
                JournalBase64Test.fail((String)("Encoding character at " + i + " follows an equals sign."));
                continue;
            }
            if (WHITE_SPACE_CHARACTERS.indexOf(thisChar) != -1) continue;
            JournalBase64Test.fail((String)("Character '" + thisChar + "' at " + i + " is not an encoding character, " + "an equals sign, or white space."));
        }
        if (howManyEqualsSigns > 2) {
            JournalBase64Test.fail((String)("Too many equals signs: " + howManyEqualsSigns));
        }
        if (0 != (totalCharacters = howManyEqualsSigns + howManyEncodingCharacters) % 4) {
            JournalBase64Test.fail((String)("Number of encoding characters plus equals signs must be a multiple of 4, not " + totalCharacters));
        }
    }

    private void assertFileContentsAreEqual(File source, File target) throws IOException {
        BufferedInputStream sourceStream = new BufferedInputStream(new FileInputStream(source));
        BufferedInputStream targetStream = new BufferedInputStream(new FileInputStream(target));
        int i = 0;
        while (true) {
            int sourceByte = ((InputStream)sourceStream).read();
            int targetByte = ((InputStream)targetStream).read();
            if (sourceByte == -1) {
                if (targetByte == -1) break;
                JournalBase64Test.fail((String)"source file is shorter than target file.");
            } else if (targetByte == -1) {
                JournalBase64Test.fail((String)"target file is shorter than source file.");
            } else if (sourceByte != targetByte) {
                JournalBase64Test.fail((String)("files don't match at byte " + i + ": source=" + sourceByte + ", target=" + targetByte));
            }
            ++i;
        }
    }
}

