/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.test;

import java.io.File;
import java.util.HashMap;
import junit.framework.TestCase;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.DirectoryBasedRepositoryReader;
import org.fcrepo.server.storage.ServiceDefinitionReader;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.DOTranslatorImpl;
import org.fcrepo.server.storage.translation.METSFedoraExt1_1DODeserializer;
import org.fcrepo.server.storage.translation.METSFedoraExt1_1DOSerializer;
import org.jrdf.graph.ObjectNode;

public class RepositoryReaderTest
extends TestCase
implements Constants {
    private final File m_repoDir;
    private DirectoryBasedRepositoryReader m_repoReader;

    public RepositoryReaderTest(String fedoraHome, String label) {
        super(label);
        this.m_repoDir = new File(new File(fedoraHome), "demo");
    }

    public void setUp() {
        try {
            String mets = RepositoryReaderTest.METS_EXT1_1.uri;
            HashMap<String, DOSerializer> sers = new HashMap<String, DOSerializer>();
            sers.put(mets, new METSFedoraExt1_1DOSerializer());
            HashMap<String, DODeserializer> desers = new HashMap<String, DODeserializer>();
            desers.put(mets, new METSFedoraExt1_1DODeserializer());
            DOTranslatorImpl translator = new DOTranslatorImpl(sers, desers);
            this.m_repoReader = new DirectoryBasedRepositoryReader(this.m_repoDir, translator, mets, mets, "UTF-8");
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void testList() {
        try {
            String[] pids = this.m_repoReader.listObjectPIDs(null);
            System.out.println("Repository has " + pids.length + " objects.");
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void testGetReader() {
        try {
            String[] pids;
            for (String element : pids = this.m_repoReader.listObjectPIDs(null)) {
                DOReader r = this.m_repoReader.getReader(false, null, element);
                System.out.println(r.GetObjectPID() + " found via DOReader.");
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void testGetSDefReader() {
        try {
            String[] pids;
            for (String element : pids = this.m_repoReader.listObjectPIDs(null)) {
                DOReader r = this.m_repoReader.getReader(false, null, element);
                if (!r.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) continue;
                ServiceDefinitionReader dr = this.m_repoReader.getServiceDefinitionReader(false, null, element);
                System.out.println(dr.GetObjectPID() + " found via getSDefReader.");
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public void testGetSDepReader() {
        try {
            String[] pids;
            for (String element : pids = this.m_repoReader.listObjectPIDs(null)) {
                DOReader r = this.m_repoReader.getReader(false, null, element);
                if (!r.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) continue;
                ServiceDeploymentReader mr = this.m_repoReader.getServiceDeploymentReader(false, null, element);
                System.out.println(mr.GetObjectPID() + " found via getSDepReader.");
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        RepositoryReaderTest test = new RepositoryReaderTest(Constants.FEDORA_HOME, "Testing DirectoryBasedRepositoryReader");
        test.setUp();
        test.testList();
        test.testGetReader();
        test.testGetSDefReader();
        test.testGetSDepReader();
    }
}

