/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.net.URL;
import java.net.URLConnection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class CleanupContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent event) {
        try {
            String osName = System.getProperty("os.name");
            if (osName != null && osName.toLowerCase().contains("windows")) {
                URL url = new URL("http://localhost/");
                URLConnection urlConn = url.openConnection();
                urlConn.setDefaultUseCaches(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                Driver driver = e.nextElement();
                if (driver.getClass().getClassLoader() != this.getClass().getClassLoader()) continue;
                DriverManager.deregisterDriver(driver);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

