/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.common.rdf.RDFName;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.RepositoryConfigurationException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.utilities.DCField;
import org.fcrepo.server.utilities.StreamUtility;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DCFields
extends DefaultHandler
implements Constants {
    private final ArrayList<DCField> m_titles = new ArrayList();
    private final ArrayList<DCField> m_creators = new ArrayList();
    private final ArrayList<DCField> m_subjects = new ArrayList();
    private final ArrayList<DCField> m_descriptions = new ArrayList();
    private final ArrayList<DCField> m_publishers = new ArrayList();
    private final ArrayList<DCField> m_contributors = new ArrayList();
    private final ArrayList<DCField> m_dates = new ArrayList();
    private final ArrayList<DCField> m_types = new ArrayList();
    private final ArrayList<DCField> m_formats = new ArrayList();
    private final ArrayList<DCField> m_identifiers = new ArrayList();
    private final ArrayList<DCField> m_sources = new ArrayList();
    private final ArrayList<DCField> m_languages = new ArrayList();
    private final ArrayList<DCField> m_relations = new ArrayList();
    private final ArrayList<DCField> m_coverages = new ArrayList();
    private final ArrayList<DCField> m_rights = new ArrayList();
    private StringBuffer m_currentContent;
    private String m_lang;

    public DCFields() {
    }

    public DCFields(InputStream in) throws RepositoryConfigurationException, ObjectIntegrityException, StreamIOException {
        SAXParser parser = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            parser = spf.newSAXParser();
        }
        catch (Exception e) {
            throw new RepositoryConfigurationException("Error getting SAX parser for DC metadata: " + e.getClass().getName() + ": " + e.getMessage());
        }
        try {
            parser.parse(in, (DefaultHandler)this);
        }
        catch (SAXException saxe) {
            throw new ObjectIntegrityException("Parse error parsing DC XML Metadata: " + saxe.getMessage());
        }
        catch (IOException ioe) {
            throw new StreamIOException("Stream error parsing DC XML Metadata: " + ioe.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        this.m_currentContent = new StringBuffer();
        this.m_lang = attrs.getValue("http://www.w3.org/XML/1998/namespace", "lang");
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.m_currentContent.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("title")) {
            this.titles().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("creator")) {
            this.creators().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("subject")) {
            this.subjects().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("description")) {
            this.descriptions().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("publisher")) {
            this.publishers().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("contributor")) {
            this.contributors().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("date")) {
            this.dates().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("type")) {
            this.types().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("format")) {
            this.formats().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("identifier")) {
            this.identifiers().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("source")) {
            this.sources().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("language")) {
            this.languages().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("relation")) {
            this.relations().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("coverage")) {
            this.coverages().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        } else if (localName.equals("rights")) {
            this.rights().add(new DCField(this.m_currentContent.toString().trim(), this.m_lang));
        }
    }

    public Map<RDFName, List<DCField>> getMap() {
        HashMap<RDFName, List<DCField>> map = new HashMap<RDFName, List<DCField>>();
        map.put(DCFields.DC.TITLE, this.m_titles);
        map.put(DCFields.DC.CREATOR, this.m_creators);
        map.put(DCFields.DC.SUBJECT, this.m_subjects);
        map.put(DCFields.DC.DESCRIPTION, this.m_descriptions);
        map.put(DCFields.DC.PUBLISHER, this.m_publishers);
        map.put(DCFields.DC.CONTRIBUTOR, this.m_contributors);
        map.put(DCFields.DC.DATE, this.m_dates);
        map.put(DCFields.DC.TYPE, this.m_types);
        map.put(DCFields.DC.FORMAT, this.m_formats);
        map.put(DCFields.DC.IDENTIFIER, this.m_identifiers);
        map.put(DCFields.DC.SOURCE, this.m_sources);
        map.put(DCFields.DC.LANGUAGE, this.m_languages);
        map.put(DCFields.DC.RELATION, this.m_relations);
        map.put(DCFields.DC.COVERAGE, this.m_coverages);
        map.put(DCFields.DC.RIGHTS, this.m_rights);
        return map;
    }

    public List<DCField> titles() {
        return this.m_titles;
    }

    public List<DCField> creators() {
        return this.m_creators;
    }

    public List<DCField> subjects() {
        return this.m_subjects;
    }

    public List<DCField> descriptions() {
        return this.m_descriptions;
    }

    public List<DCField> publishers() {
        return this.m_publishers;
    }

    public List<DCField> contributors() {
        return this.m_contributors;
    }

    public List<DCField> dates() {
        return this.m_dates;
    }

    public List<DCField> types() {
        return this.m_types;
    }

    public List<DCField> formats() {
        return this.m_formats;
    }

    public List<DCField> identifiers() {
        return this.m_identifiers;
    }

    public List<DCField> sources() {
        return this.m_sources;
    }

    public List<DCField> languages() {
        return this.m_languages;
    }

    public List<DCField> relations() {
        return this.m_relations;
    }

    public List<DCField> coverages() {
        return this.m_coverages;
    }

    public List<DCField> rights() {
        return this.m_rights;
    }

    public String getAsXML() {
        return this.getAsXML(null);
    }

    public String getAsXML(String targetPid) {
        boolean addPid;
        boolean bl = addPid = targetPid != null;
        if (addPid) {
            for (DCField dcField : this.identifiers()) {
                if (!dcField.getValue().equals(targetPid)) continue;
                addPid = false;
            }
        }
        StringBuffer out = new StringBuffer();
        out.append("<" + DCFields.OAI_DC.prefix + ":dc" + " xmlns:" + DCFields.OAI_DC.prefix + "=\"" + DCFields.OAI_DC.uri + "\"" + "\nxmlns:" + DCFields.DC.prefix + "=\"" + DCFields.DC.uri + "\"\nxmlns:xsi=\"" + DCFields.XSI.uri + "\"\nxsi:schemaLocation=\"" + DCFields.OAI_DC.uri + " " + DCFields.OAI_DC2_0.xsdLocation + "\">\n");
        this.appendXML(this.titles(), "title", out);
        this.appendXML(this.creators(), "creator", out);
        this.appendXML(this.subjects(), "subject", out);
        this.appendXML(this.descriptions(), "description", out);
        this.appendXML(this.publishers(), "publisher", out);
        this.appendXML(this.contributors(), "contributor", out);
        this.appendXML(this.dates(), "date", out);
        this.appendXML(this.types(), "type", out);
        this.appendXML(this.formats(), "format", out);
        if (addPid) {
            this.appendXML(new DCField(targetPid), "identifier", out);
        }
        this.appendXML(this.identifiers(), "identifier", out);
        this.appendXML(this.sources(), "source", out);
        this.appendXML(this.languages(), "language", out);
        this.appendXML(this.relations(), "relation", out);
        this.appendXML(this.coverages(), "coverage", out);
        this.appendXML(this.rights(), "rights", out);
        out.append("</oai_dc:dc>\n");
        return out.toString();
    }

    private void appendXML(List<DCField> values, String name, StringBuffer out) {
        for (DCField value : values) {
            this.appendXML(value, name, out);
        }
    }

    private void appendXML(DCField value, String name, StringBuffer out) {
        out.append("  <dc:" + name);
        if (value.getLang() != null) {
            out.append(" xml:lang=\"" + value.getLang() + "\"");
        }
        out.append(">");
        out.append(StreamUtility.enc(value.getValue()));
        out.append("</dc:" + name + ">\n");
    }
}

