/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fcrepo.server.utilities.ColumnSpec;
import org.fcrepo.server.utilities.DDLConverter;
import org.fcrepo.server.utilities.TableSpec;

public class DerbyDDLConverter
implements DDLConverter {
    @Override
    public List<String> getDDL(TableSpec spec) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder out = new StringBuilder();
        out.append("CREATE TABLE " + spec.getName() + " (\n");
        Iterator<ColumnSpec> csi = spec.columnSpecIterator();
        int csNum = 0;
        while (csi.hasNext()) {
            if (csNum > 0) {
                out = this.removeTrailingWhitespace(out);
                out.append(",\n");
            }
            ++csNum;
            ColumnSpec cs = csi.next();
            out.append((CharSequence)this.getColumnName(cs));
            out.append(this.getDataType(cs));
            out.append(this.getColumnConstraint(cs));
            out.append((CharSequence)this.getDefaultValue(cs));
            if (cs.getIndexName() == null) continue;
            l.add(this.createIndexStatement(spec, cs));
        }
        out = this.removeTrailingWhitespace(out);
        if (spec.getPrimaryColumnName() != null) {
            out.append(",\n");
            out.append((CharSequence)this.getTableConstraint(spec));
        }
        out.append(')');
        l.add(0, out.toString());
        return l;
    }

    private StringBuilder removeTrailingWhitespace(StringBuilder out) {
        while (out.charAt(out.length() - 1) == ' ') {
            out.deleteCharAt(out.length() - 1);
        }
        return out;
    }

    private StringBuilder getColumnName(ColumnSpec cs) {
        StringBuilder out = new StringBuilder();
        out.append("  ");
        out.append(cs.getName());
        out.append(' ');
        return out;
    }

    private Object getDataType(ColumnSpec cs) {
        StringBuilder out = new StringBuilder();
        if (this.isNumberType(cs)) {
            out.append(this.getTypeWithoutByteLength(cs));
        } else if (cs.getType().equalsIgnoreCase("text")) {
            out.append("CLOB");
        } else {
            out.append(cs.getType());
        }
        out.append(' ');
        return out;
    }

    private boolean isNumberType(ColumnSpec cs) {
        return cs.getType().toLowerCase().indexOf("int") != -1;
    }

    private String getTypeWithoutByteLength(ColumnSpec cs) {
        int end = cs.getType().indexOf(40);
        if (end == -1) {
            end = cs.getType().length();
        }
        return cs.getType().substring(0, end);
    }

    private Object getColumnConstraint(ColumnSpec cs) {
        StringBuilder out = new StringBuilder();
        if (cs.isUnique()) {
            out.append("UNIQUE ");
        }
        if (cs.isNotNull()) {
            out.append("NOT NULL ");
        }
        if (cs.isAutoIncremented() && this.isNumberType(cs)) {
            out.append("GENERATED ALWAYS AS IDENTITY ");
        }
        return out;
    }

    private StringBuilder getDefaultValue(ColumnSpec cs) {
        StringBuilder out = new StringBuilder();
        if (cs.getDefaultValue() != null) {
            out.append("DEFAULT ");
            if (!this.isNumberType(cs)) {
                out.append("'");
            }
            out.append(cs.getDefaultValue());
            if (!this.isNumberType(cs)) {
                out.append("'");
            }
            out.append(' ');
        }
        return out;
    }

    private StringBuilder getTableConstraint(TableSpec ts) {
        StringBuilder out = new StringBuilder();
        if (ts.getPrimaryColumnName() != null) {
            out.append("  PRIMARY KEY (");
            out.append(ts.getPrimaryColumnName());
            out.append(")");
        }
        return out;
    }

    private String createIndexStatement(TableSpec ts, ColumnSpec cs) {
        StringBuilder out = new StringBuilder();
        if (cs.getIndexName() != null) {
            out.append("CREATE INDEX " + ts.getName() + "_" + cs.getName() + " ON " + ts.getName() + " (" + cs.getName() + ")");
        }
        return out.toString();
    }
}

