/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.util.Map;
import java.util.Set;
import org.jrdf.graph.Triple;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;

public class FilteredTripleIterator
extends TripleIterator {
    TripleIterator m_baseIter;
    boolean m_add;
    Triple m_filter;
    Triple m_next;
    boolean m_changeMade = false;

    public FilteredTripleIterator(TripleIterator baseIter, Triple filter, boolean add) throws TrippiException {
        this.m_baseIter = baseIter;
        this.m_filter = filter;
        this.m_add = add;
        this.m_next = this.getNext();
    }

    public FilteredTripleIterator(Map<String, String> aliasMap, Triple filter, boolean add) throws TrippiException {
        this.m_baseIter = null;
        this.m_filter = filter;
        this.m_add = add;
        this.m_next = this.getNext();
    }

    public boolean hasNext() throws TrippiException {
        return this.m_next != null;
    }

    public Triple next() throws TrippiException {
        Triple last = this.m_next;
        this.m_next = this.getNext();
        return last;
    }

    private Triple getNext() throws TrippiException {
        if (!this.m_add) {
            Triple next = this.m_baseIter.next();
            while (next != null && this.matches(next, this.m_filter)) {
                this.m_changeMade = true;
                next = this.m_baseIter.next();
            }
            return next;
        }
        if (this.m_baseIter == null) {
            this.m_changeMade = true;
            Triple next = this.m_filter;
            this.m_filter = null;
            return next;
        }
        Triple next = this.m_baseIter.next();
        if (this.matches(next, this.m_filter)) {
            this.m_filter = null;
        }
        if (next == null) {
            if (this.m_filter != null) {
                this.m_changeMade = true;
            }
            next = this.m_filter;
            this.m_filter = null;
        }
        return next;
    }

    private boolean matches(Triple next, Triple filter) {
        if (filter == null || next == null) {
            return false;
        }
        return this.partMatches(next.getSubject().toString(), filter.getSubject().toString()) && this.partMatches(next.getPredicate().toString(), filter.getPredicate().toString()) && this.partMatches(next.getObject().toString(), filter.getObject().toString());
    }

    private boolean partMatches(String next, String filter) {
        if (next.equals(filter)) {
            return true;
        }
        Map map = this.getAliasMap();
        Set keys = map.keySet();
        for (String key : keys) {
            if (next.startsWith(key + ":")) {
                next = next.replaceFirst(key + ":", (String)map.get(key));
            }
            if (filter.startsWith(key + ":")) {
                filter = filter.replaceFirst(key + ":", (String)map.get(key));
            }
            if (!next.equals(filter)) continue;
            return true;
        }
        return false;
    }

    public void close() throws TrippiException {
        this.m_filter = null;
        if (this.m_baseIter != null) {
            this.m_baseIter.close();
        }
    }

    public boolean wasChangeMade() {
        return this.m_changeMade;
    }
}

