/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PIDStreamIterableWrapper
implements Iterable<String> {
    private final PIDStreamIterator m_iterator;

    public PIDStreamIterableWrapper(InputStream stream) throws IOException {
        this.m_iterator = new PIDStreamIterator(stream);
    }

    @Override
    public Iterator<String> iterator() {
        return this.m_iterator;
    }

    private class PIDStreamIterator
    implements Iterator<String> {
        boolean m_isXML = false;
        boolean m_started = false;
        BufferedReader m_reader;
        String m_nextPID = null;
        String m_nextLine = null;
        private static final String XML_START = "<pid>";
        private static final String XML_END = "</pid>";

        private PIDStreamIterator() {
        }

        public PIDStreamIterator(InputStream stream) throws IOException {
            this.m_reader = new BufferedReader(new InputStreamReader(stream));
            this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.m_nextPID != null;
        }

        @Override
        public String next() {
            if (this.m_nextPID != null) {
                String next = this.m_nextPID;
                try {
                    this.getNext();
                }
                catch (IOException e) {
                    throw new RuntimeException("IO Error reading PIDs from stream", e);
                }
                return next;
            }
            throw new NoSuchElementException("End of PIDs");
        }

        @Override
        public void remove() {
            throw new RuntimeException("method remove() called on" + PIDStreamIterator.class.getCanonicalName());
        }

        private void getNext() throws IOException {
            this.m_nextPID = null;
            while ((this.m_nextLine = this.m_reader.readLine()) != null) {
                String nextPID;
                if (this.m_nextLine.trim().equals("")) continue;
                if (!this.m_started) {
                    this.m_isXML = this.m_nextLine.contains("<");
                    this.m_started = true;
                }
                if ((nextPID = this.getPID(this.m_nextLine)) == null) continue;
                this.m_nextPID = nextPID;
                break;
            }
            if (this.m_nextPID == null) {
                this.m_reader.close();
            }
        }

        private String getPID(String line) {
            if (this.m_isXML) {
                int start = line.indexOf(XML_START);
                int end = line.indexOf(XML_END);
                if (start == -1 || end == -1) {
                    return null;
                }
                return line.substring(start + XML_START.length(), end);
            }
            if (line.trim().equals("")) {
                return null;
            }
            return line.trim();
        }

        protected void finalize() throws Throwable {
            this.m_reader.close();
        }
    }
}

