/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.fcrepo.common.FaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamUtility {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtility.class);

    public static String enc(String in) {
        String inStr = in;
        if (inStr == null) {
            inStr = "";
        }
        StringBuffer out = new StringBuffer();
        StreamUtility.enc(inStr, out);
        return out.toString();
    }

    public static void enc(String in, StringBuffer out) {
        for (int i = 0; i < in.length(); ++i) {
            StreamUtility.enc(in.charAt(i), out);
        }
    }

    public static void enc(char[] in, int start, int length, StringBuffer out) {
        for (int i = start; i < length + start; ++i) {
            StreamUtility.enc(in[i], out);
        }
    }

    public static void enc(char in, StringBuffer out) {
        if (in == '&') {
            out.append("&amp;");
        } else if (in == '<') {
            out.append("&lt;");
        } else if (in == '>') {
            out.append("&gt;");
        } else if (in == '\"') {
            out.append("&quot;");
        } else if (in == '\'') {
            out.append("&apos;");
        } else {
            out.append(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipeStream(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            int len;
            byte[] buf = new byte[bufSize];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (IOException e) {
                logger.warn("Unable to close stream", (Throwable)e);
            }
        }
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtility.pipeStream(in, out, 4096);
        return out.toByteArray();
    }

    public static InputStream getStream(String string) {
        try {
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
    }
}

