/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.server.errors.InconsistentTableSpecException;
import org.fcrepo.server.utilities.ColumnSpec;
import org.fcrepo.server.utilities.TableSpecDeserializer;
import org.xml.sax.helpers.DefaultHandler;

public class TableSpec {
    private final String m_name;
    private final List<ColumnSpec> m_columnSpecs;
    private final String m_primaryColumnName;
    private String m_type;

    public TableSpec(String name, List<ColumnSpec> columnSpecs, String primaryColumnName) throws InconsistentTableSpecException {
        this.m_name = name;
        this.m_columnSpecs = columnSpecs;
        this.m_primaryColumnName = primaryColumnName;
        this.assertConsistent();
    }

    public TableSpec(String name, List<ColumnSpec> columnSpecs, String primaryColumnName, String type) throws InconsistentTableSpecException {
        this.m_name = name;
        this.m_columnSpecs = columnSpecs;
        this.m_primaryColumnName = primaryColumnName;
        this.m_type = type;
        this.assertConsistent();
    }

    public static List<TableSpec> getTableSpecs(InputStream in) throws InconsistentTableSpecException, IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            TableSpecDeserializer tsd = new TableSpecDeserializer();
            parser.parse(in, (DefaultHandler)tsd);
            tsd.assertTableSpecsConsistent();
            return tsd.getTableSpecs();
        }
        catch (InconsistentTableSpecException itse) {
            throw itse;
        }
        catch (Exception e) {
            throw new IOException("Error parsing XML: " + e.getMessage());
        }
    }

    public void assertConsistent() throws InconsistentTableSpecException {
    }

    public String getName() {
        return this.m_name;
    }

    public String getPrimaryColumnName() {
        return this.m_primaryColumnName;
    }

    public String getType() {
        return this.m_type;
    }

    public Iterator<ColumnSpec> columnSpecIterator() {
        return this.m_columnSpecs.iterator();
    }
}

