/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.util.ArrayList;
import java.util.List;
import org.fcrepo.server.errors.InconsistentTableSpecException;
import org.fcrepo.server.utilities.ColumnSpec;
import org.fcrepo.server.utilities.TableSpec;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TableSpecDeserializer
extends DefaultHandler {
    private final ArrayList<TableSpec> m_tableSpecList = new ArrayList();
    private InconsistentTableSpecException m_itse;
    private ArrayList<ColumnSpec> m_columnSpecList = new ArrayList();
    private String m_table_name;
    private String m_table_primaryKey;
    private String m_table_type;
    private String m_column_name;
    private String m_column_type;
    private boolean m_column_binary;
    private boolean m_column_autoIncrement;
    private String m_column_index;
    private boolean m_column_notNull;
    private boolean m_column_unique;
    private String m_column_default;
    private String m_column_foreignKey_foreignTableName;
    private String m_column_foreignKey_columnName;
    private String m_column_foreignKey_onDeleteAction;

    protected TableSpecDeserializer() {
    }

    public List<TableSpec> getTableSpecs() {
        return this.m_tableSpecList;
    }

    public void assertTableSpecsConsistent() throws InconsistentTableSpecException {
        if (this.m_itse != null) {
            throw this.m_itse;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) throws SAXException {
        if (localName.equals("table")) {
            this.m_table_name = a.getValue("name");
            if (this.m_table_name == null) {
                throw new SAXException("table element must have a name attribute");
            }
            this.m_table_primaryKey = a.getValue("primaryKey");
            this.m_table_type = a.getValue("type");
        } else if (localName.equals("column")) {
            this.m_column_name = a.getValue("name");
            if (this.m_column_name == null) {
                throw new SAXException("column element must have a name attribute");
            }
            this.m_column_type = a.getValue("type");
            if (this.m_column_type == null) {
                throw new SAXException("column element must have a type attribute");
            }
            if (a.getValue("binary") != null && a.getValue("binary").equalsIgnoreCase("true")) {
                this.m_column_binary = true;
            }
            this.m_column_autoIncrement = this.getBoolean(a, "autoIncrement");
            this.m_column_index = a.getValue("index");
            this.m_column_notNull = this.getBoolean(a, "notNull");
            this.m_column_unique = this.getBoolean(a, "unique");
            this.m_column_default = a.getValue("default");
            String f = a.getValue("foreignKey");
            if (f == null) {
                f = a.getValue("foriegnKey");
            }
            if (f != null) {
                int dotPos = f.indexOf(".");
                if (dotPos == -1) {
                    throw new SAXException("table.column not given in foreignKey attribute");
                }
                this.m_column_foreignKey_foreignTableName = f.substring(0, dotPos);
                int spacePos = f.indexOf(" ");
                if (spacePos == -1) {
                    this.m_column_foreignKey_columnName = f.substring(dotPos + 1);
                } else {
                    this.m_column_foreignKey_columnName = f.substring(dotPos + 1, spacePos);
                    this.m_column_foreignKey_onDeleteAction = f.substring(spacePos + 1);
                }
            }
        }
    }

    private boolean getBoolean(Attributes a, String name) {
        String v = a.getValue(name);
        if (v == null) {
            return false;
        }
        return v.equalsIgnoreCase("true") || v.equalsIgnoreCase("yes");
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("table")) {
            try {
                this.m_tableSpecList.add(new TableSpec(this.m_table_name, this.m_columnSpecList, this.m_table_primaryKey, this.m_table_type));
            }
            catch (InconsistentTableSpecException itse) {
                this.m_itse = itse;
            }
            this.m_table_name = null;
            this.m_table_primaryKey = null;
            this.m_table_type = null;
            this.m_columnSpecList = new ArrayList();
        } else if (localName.equals("column")) {
            this.m_columnSpecList.add(new ColumnSpec(this.m_column_name, this.m_column_type, this.m_column_binary, this.m_column_default, this.m_column_autoIncrement, this.m_column_index, this.m_column_unique, this.m_column_notNull, this.m_column_foreignKey_foreignTableName, this.m_column_foreignKey_columnName, this.m_column_foreignKey_onDeleteAction));
            this.m_column_name = null;
            this.m_column_type = null;
            this.m_column_binary = false;
            this.m_column_default = null;
            this.m_column_autoIncrement = false;
            this.m_column_index = null;
            this.m_column_unique = false;
            this.m_column_notNull = false;
            this.m_column_foreignKey_foreignTableName = null;
            this.m_column_foreignKey_columnName = null;
            this.m_column_foreignKey_onDeleteAction = null;
        }
    }
}

