/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities.rebuild;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.config.DatastoreConfiguration;
import org.fcrepo.server.config.ModuleConfiguration;
import org.fcrepo.server.config.Parameter;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.errors.InitializationException;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ObjectNotFoundException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StorageDeviceException;
import org.fcrepo.server.management.PIDGenerator;
import org.fcrepo.server.search.FieldSearch;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.ConnectionPoolManager;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.lowlevel.ILowlevelStorage;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.utilities.TableSpec;
import org.fcrepo.server.utilities.rebuild.Rebuild;
import org.fcrepo.server.utilities.rebuild.Rebuilder;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLRebuilder
implements Rebuilder {
    private static final Logger logger = LoggerFactory.getLogger(Rebuilder.class);
    private ServerConfiguration m_serverConfig;
    private Server m_server;
    private ConnectionPool m_connectionPool;
    private Context m_context;

    @Override
    public String getAction() {
        return "Rebuild SQL database.";
    }

    @Override
    public boolean shouldStopServer() {
        return true;
    }

    @Override
    public void setServerConfiguration(ServerConfiguration serverConfig) {
        this.m_serverConfig = serverConfig;
    }

    @Override
    public void setServerDir(File serverBaseDir) {
    }

    @Override
    public void init() {
    }

    @Override
    public Map<String, String> getOptions() {
        HashMap<String, String> m = new HashMap<String, String>();
        return m;
    }

    @Override
    public void start(Map<String, String> options) throws Exception {
        this.blankExistingTables();
        try {
            this.m_server = Rebuild.getServer();
            ConnectionPoolManager cpm = (ConnectionPoolManager)((Object)this.m_server.getModule("org.fcrepo.server.storage.ConnectionPoolManager"));
            if (cpm == null) {
                throw new ModuleInitializationException("ConnectionPoolManager not loaded.", "ConnectionPoolManager");
            }
            this.m_connectionPool = cpm.getPool();
            this.m_context = ReadOnlyContext.getContext("utility", "fedoraAdmin", "", false);
            String registryClassTemp = this.m_server.getParameter("registry");
            ILowlevelStorage llstore = (ILowlevelStorage)((Object)this.m_server.getModule("org.fcrepo.server.storage.lowlevel.ILowlevelStorage"));
            try {
                llstore.rebuildObject();
                llstore.rebuildDatastream();
            }
            catch (LowlevelStorageException e) {
                e.printStackTrace();
            }
        }
        catch (InitializationException ie) {
            logger.error("Error initializing", (Throwable)ie);
            throw ie;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getExistingTables(Connection conn) throws SQLException {
        ArrayList<String> existing = new ArrayList<String>();
        DatabaseMetaData dbMeta = conn.getMetaData();
        ResultSet r = null;
        try {
            r = dbMeta.getTables(null, null, "%", null);
            while (r.next()) {
                existing.add(r.getString("TABLE_NAME"));
            }
            r.close();
            r = null;
            return existing;
        }
        catch (SQLException sqle) {
            throw new SQLException(sqle.getMessage());
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                r = null;
            }
            catch (Throwable throwable) {
                r = null;
                throw throwable;
            }
        }
    }

    public void blankExistingTables() {
        Connection connection = null;
        Statement s = null;
        try {
            connection = this.getDefaultConnection();
            List<String> existingTables = SQLRebuilder.getExistingTables(connection);
            List<String> fedoraTables = this.getFedoraTables();
            s = connection.createStatement();
            for (int i = 0; i < existingTables.size(); ++i) {
                String origTableName = existingTables.get(i);
                String tableName = origTableName.toUpperCase();
                if (!fedoraTables.contains(tableName) || tableName.startsWith("RI")) continue;
                System.out.println("Cleaning up table: " + origTableName);
                try {
                    s.executeUpdate("DELETE FROM " + origTableName);
                    continue;
                }
                catch (Exception lle) {
                    System.err.println(lle.getMessage());
                    System.err.flush();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("DB error while blanking existing tables", e);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                    s = null;
                }
                connection.close();
            }
            catch (Exception e) {}
        }
    }

    private List<String> getFedoraTables() {
        try {
            String dbSpecLocation = "org/fcrepo/server/storage/resources/DefaultDOManager.dbspec";
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(dbSpecLocation);
            List<TableSpec> specs = TableSpec.getTableSpecs(in);
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < specs.size(); ++i) {
                TableSpec spec = specs.get(i);
                names.add(spec.getName().toUpperCase());
            }
            return names;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unexpected error reading dbspec file", e);
        }
    }

    @Override
    public void addObject(DigitalObject obj) {
        Date nowUTC = new Date();
        DOManager manager = (DOManager)((Object)this.m_server.getModule("org.fcrepo.server.storage.DOManager"));
        FieldSearch fieldSearch = (FieldSearch)((Object)this.m_server.getModule("org.fcrepo.server.search.FieldSearch"));
        PIDGenerator pidGenerator = (PIDGenerator)((Object)this.m_server.getModule("org.fcrepo.server.management.PIDGenerator"));
        logger.debug("Rebuild: Setting object/component states and create dates if unset...");
        if (obj.getState() == null || obj.getState().equals("")) {
            obj.setState("A");
        }
        if (obj.getCreateDate() == null || obj.getCreateDate().equals("")) {
            obj.setCreateDate(nowUTC);
        }
        obj.setLastModDate(nowUTC);
        logger.debug("Rebuild: Setting object/component states and create dates if unset...");
        if (obj.getState() == null || obj.getState().equals("")) {
            obj.setState("A");
        }
        if (obj.getCreateDate() == null || obj.getCreateDate().equals("")) {
            obj.setCreateDate(nowUTC);
        }
        obj.setLastModDate(nowUTC);
        Iterator<String> dsIter = obj.datastreamIdIterator();
        while (dsIter.hasNext()) {
            for (Datastream ds : obj.datastreams(dsIter.next())) {
                if (ds.DSCreateDT == null || ds.DSCreateDT.equals("")) {
                    ds.DSCreateDT = nowUTC;
                }
                if (ds.DSState != null && !ds.DSState.equals("")) continue;
                ds.DSState = "A";
            }
        }
        logger.debug("INGEST: Stream contained PID with retainable namespace-id... will use PID from stream.");
        try {
            pidGenerator.neverGeneratePID(obj.getPid());
        }
        catch (IOException e) {
            throw new RuntimeException("Error calling pidGenerator.neverGeneratePID(): " + e.getMessage(), e);
        }
        try {
            this.registerObject(obj);
        }
        catch (StorageDeviceException e) {
            // empty catch block
        }
        try {
            logger.info("COMMIT: Attempting replication: " + obj.getPid());
            DOReader reader = manager.getReader(false, this.m_context, obj.getPid());
            logger.info("COMMIT: Updating FieldSearch indexes...");
            fieldSearch.update(reader);
        }
        catch (ServerException se) {
            System.out.println("Error while replicating: " + se.getClass().getName() + ": " + se.getMessage());
            se.printStackTrace();
        }
        catch (Throwable th) {
            System.out.println("Error while replicating: " + th.getClass().getName() + ": " + th.getMessage());
            th.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerObject(DigitalObject obj) throws StorageDeviceException {
        String pid = obj.getPid();
        String userId = "the userID field is no longer used";
        String label = "the label field is no longer used";
        Connection conn = null;
        Statement s1 = null;
        try {
            String query = "INSERT INTO doRegistry (doPID, ownerId, label) VALUES (?, ?, ?)";
            conn = this.m_connectionPool.getReadWriteConnection();
            s1 = conn.prepareStatement(query);
            s1.setString(1, pid);
            s1.setString(2, userId);
            s1.setString(3, label);
            s1.executeUpdate();
            if (obj.hasContentModel((ObjectNode)Models.SERVICE_DEPLOYMENT_3_0)) {
                this.updateDeploymentMap(obj, conn);
            }
        }
        catch (SQLException sqle) {
            throw new StorageDeviceException("Unexpected error from SQL database while registering object: " + sqle.getMessage());
        }
        finally {
            try {
                try {
                    if (s1 != null) {
                        s1.close();
                    }
                    s1 = null;
                }
                catch (Exception sqle) {
                    throw new StorageDeviceException("Unexpected error from SQL database while registering object: " + sqle.getMessage());
                }
            }
            catch (Throwable throwable) {
                s1 = null;
                throw throwable;
            }
        }
        PreparedStatement s2 = null;
        ResultSet results = null;
        try {
            logger.debug("COMMIT: Updating registry...");
            String query = "SELECT systemVersion FROM doRegistry WHERE doPID=?";
            s2 = conn.prepareStatement(query);
            s2.setString(1, pid);
            results = s2.executeQuery();
            if (!results.next()) {
                throw new ObjectNotFoundException("Error creating replication job: The requested object doesn't exist in the registry.");
            }
            int systemVersion = results.getInt("systemVersion");
            query = "UPDATE doRegistry SET systemVersion=? WHERE doPID=?";
            s2 = conn.prepareStatement(query);
            s2.setInt(1, ++systemVersion);
            s2.setString(2, pid);
            s2.executeUpdate();
            return;
        }
        catch (SQLException sqle) {
            throw new StorageDeviceException("Error creating replication job: " + sqle.getMessage());
        }
        catch (ObjectNotFoundException e) {
            e.printStackTrace();
            return;
        }
        finally {
            try {
                try {
                    if (results != null) {
                        results.close();
                    }
                    if (s2 != null) {
                        s2.close();
                    }
                    if (conn != null) {
                        this.m_connectionPool.free(conn);
                    }
                    results = null;
                    s2 = null;
                }
                catch (SQLException sqle) {
                    throw new StorageDeviceException("Unexpected error from SQL database: " + sqle.getMessage());
                }
            }
            catch (Throwable throwable) {
                results = null;
                s2 = null;
                throw throwable;
            }
        }
    }

    @Override
    public void finish() {
    }

    private Connection getDefaultConnection() {
        ModuleConfiguration poolConfig = this.m_serverConfig.getModuleConfiguration("org.fcrepo.server.storage.ConnectionPoolManager");
        String datastoreID = poolConfig.getParameter("defaultPoolName", Parameter.class).getValue();
        DatastoreConfiguration dbConfig = this.m_serverConfig.getDatastoreConfiguration(datastoreID);
        return SQLRebuilder.getConnection(dbConfig.getParameter("jdbcDriverClass", Parameter.class).getValue(), dbConfig.getParameter("jdbcURL", Parameter.class).getValue(), dbConfig.getParameter("dbUsername", Parameter.class).getValue(), dbConfig.getParameter("dbPassword", Parameter.class).getValue());
    }

    private static Connection getConnection(String driverClass, String url, String username, String password) {
        try {
            Class.forName(driverClass);
            return DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting database connection", e);
        }
    }

    private synchronized void updateDeploymentMap(DigitalObject obj, Connection c) throws SQLException {
        Set<RelationshipTuple> sDefs = obj.getRelationships((PredicateNode)Constants.MODEL.IS_DEPLOYMENT_OF, null);
        Set<RelationshipTuple> models = obj.getRelationships((PredicateNode)Constants.MODEL.IS_CONTRACTOR_OF, null);
        for (RelationshipTuple sDefTuple : sDefs) {
            String sDef = sDefTuple.getObjectPID();
            for (RelationshipTuple cModelTuple : models) {
                String cModel = cModelTuple.getObjectPID();
                this.addDeployment(cModel, sDef, obj, c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeployment(String cModel, String sDef, DigitalObject sDep, Connection c) throws SQLException {
        String query = "INSERT INTO modelDeploymentMap (cModel, sDef, sDep) VALUES (?, ?, ?)";
        PreparedStatement s = c.prepareStatement(query);
        try {
            s.setString(1, cModel);
            s.setString(2, sDef);
            s.setString(3, sDep.getPid());
            s.executeUpdate();
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }
}

