/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.util.HashMap;
import java.util.Map;
import org.fcrepo.server.Context;
import org.fcrepo.server.Module;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ObjectValidityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.validation.DOObjectValidator;
import org.fcrepo.server.validation.DOValidatorModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOObjectValidatorModule
extends Module
implements DOObjectValidator {
    private static final Logger logger = LoggerFactory.getLogger(DOValidatorModule.class);
    private final Map<String, DOObjectValidator> m_validators = new HashMap<String, DOObjectValidator>();
    private boolean m_enabled = false;

    public DOObjectValidatorModule(Map<String, String> moduleParameters, Server server, String role) throws ModuleInitializationException {
        super(moduleParameters, server, role);
    }

    @Override
    public void postInitModule() throws ModuleInitializationException {
    }

    @Override
    public void validate(Context context, DOReader reader) throws ServerException {
        if (this.m_enabled) {
            for (DOObjectValidator validator : this.m_validators.values()) {
                try {
                    validator.validate(context, reader);
                }
                catch (ObjectValidityException e) {
                    logger.error("Object validation error " + reader.GetObjectPID() + ": " + e.getMessage());
                    throw e;
                }
            }
        }
    }

    public void setValidators(Map<String, ? extends DOObjectValidator> validators) {
        logger.info("Adding " + validators.size() + " object validators");
        this.m_validators.putAll(validators);
        if (this.m_validators.size() > 0) {
            this.m_enabled = true;
        }
    }
}

