/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectValidityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.validation.DOValidator;
import org.fcrepo.server.validation.DOValidatorSchematron;
import org.fcrepo.server.validation.DOValidatorXMLSchema;
import org.fcrepo.utilities.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOValidatorImpl
implements DOValidator {
    private static final Logger logger = LoggerFactory.getLogger(DOValidatorImpl.class);
    protected static boolean debug = true;
    protected static String tempDir = null;
    protected static String xmlSchemaPath = null;
    protected static String schematronPreprocessorPath = null;
    protected static String schematronSchemaPath = null;
    private final Map<String, String> m_xmlSchemaMap;
    private final Map<String, String> m_ruleSchemaMap;

    public DOValidatorImpl(String tempDir, Map<String, String> xmlSchemaMap, String schematronPreprocessorPath, Map<String, String> ruleSchemaMap) throws ServerException {
        logger.debug("VALIDATE: Initializing object validation...");
        this.m_xmlSchemaMap = xmlSchemaMap;
        this.m_ruleSchemaMap = ruleSchemaMap;
        if (tempDir == null) {
            throw new ObjectValidityException("[DOValidatorImpl] ERROR in constructor: tempDir is null.");
        }
        if (schematronPreprocessorPath == null) {
            throw new ObjectValidityException("[DOValidatorImpl] ERROR in constructor. schematronPreprocessorPath is null.");
        }
        DOValidatorImpl.tempDir = tempDir;
        DOValidatorImpl.schematronPreprocessorPath = schematronPreprocessorPath;
    }

    @Override
    public void validate(InputStream objectAsStream, String format, int validationType, String phase) throws ObjectValidityException {
        if (validationType == -1) {
            return;
        }
        this.checkFormat(format);
        try {
            File objectAsFile = this.streamtoFile(tempDir, objectAsStream);
            this.validate(objectAsFile, format, validationType, phase);
        }
        catch (ObjectValidityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectValidityException("[DOValidatorImpl]: ERROR in validate objectAsStream. " + e.getMessage());
        }
    }

    @Override
    public void validate(File objectAsFile, String format, int validationType, String phase) throws ObjectValidityException, GeneralException {
        logger.debug("Validation phase=" + phase + " format=" + format);
        logger.debug("VALIDATE: Initiating validation:  phase=" + phase + " format=" + format);
        if (validationType == -1) {
            return;
        }
        this.checkFormat(format);
        if (format.equals(Constants.ATOM_ZIP1_1.uri)) {
            try {
                ZipEntry entry;
                File manifest = null;
                ZipInputStream zip = new ZipInputStream(new FileInputStream(objectAsFile));
                while ((entry = zip.getNextEntry()) != null) {
                    if (!entry.getName().equals("atommanifest.xml")) continue;
                    manifest = this.streamtoFile(tempDir, zip);
                    break;
                }
                zip.close();
                objectAsFile = manifest;
            }
            catch (IOException e) {
                throw new GeneralException(e.getMessage(), e);
            }
        }
        if (validationType == 0) {
            this.validateByRules(objectAsFile, this.m_ruleSchemaMap.get(format), schematronPreprocessorPath, phase);
            this.validateXMLSchema(objectAsFile, this.m_xmlSchemaMap.get(format));
        } else if (validationType == 1) {
            this.validateXMLSchema(objectAsFile, this.m_xmlSchemaMap.get(format));
        } else if (validationType == 2) {
            this.validateByRules(objectAsFile, this.m_ruleSchemaMap.get(format), schematronPreprocessorPath, phase);
        } else {
            String msg = "VALIDATE: ERROR - missing or invalid validationType";
            logger.error(msg);
            this.cleanUp(objectAsFile);
            throw new GeneralException("[DOValidatorImpl] " + msg + ":" + validationType);
        }
        this.cleanUp(objectAsFile);
    }

    private void checkFormat(String format) throws ObjectValidityException {
        if (!this.m_xmlSchemaMap.containsKey(format)) {
            Validation validation = new Validation("unknown");
            ArrayList<String> probs = new ArrayList<String>();
            probs.add("Unsupported format: " + format);
            validation.setObjectProblems(probs);
            throw new ObjectValidityException("Unsupported format: " + format, validation);
        }
    }

    private void validateXMLSchema(File objectAsFile, String xmlSchemaPath) throws ObjectValidityException, GeneralException {
        try {
            DOValidatorXMLSchema xsv = new DOValidatorXMLSchema(xmlSchemaPath);
            xsv.validate(objectAsFile);
        }
        catch (ObjectValidityException e) {
            logger.error("VALIDATE: ERROR - failed XML Schema validation.", (Throwable)e);
            this.cleanUp(objectAsFile);
            throw e;
        }
        catch (Exception e) {
            logger.error("VALIDATE: ERROR - failed XML Schema validation.", (Throwable)e);
            this.cleanUp(objectAsFile);
            throw new ObjectValidityException("[DOValidatorImpl]: validateXMLSchema. " + e.getMessage());
        }
        logger.debug("VALIDATE: SUCCESS - passed XML Schema validation.");
    }

    private void validateByRules(File objectAsFile, String ruleSchemaPath, String preprocessorPath, String phase) throws ObjectValidityException, GeneralException {
        try {
            DOValidatorSchematron schtron = new DOValidatorSchematron(ruleSchemaPath, preprocessorPath, phase);
            schtron.validate(objectAsFile);
        }
        catch (ObjectValidityException e) {
            logger.error("VALIDATE: ERROR - failed Schematron rules validation.", (Throwable)e);
            this.cleanUp(objectAsFile);
            throw e;
        }
        catch (Exception e) {
            logger.error("VALIDATE: ERROR - failed Schematron rules validation.", (Throwable)e);
            this.cleanUp(objectAsFile);
            throw new ObjectValidityException("[DOValidatorImpl]: failed Schematron rules validation. " + e.getMessage());
        }
        logger.debug("VALIDATE: SUCCESS - passed Schematron rules validation.");
    }

    private File streamtoFile(String dirname, InputStream objectAsStream) throws IOException {
        File objectAsFile = null;
        try {
            FileOutputStream fos;
            File tempDir = new File(dirname);
            File fileLocation = null;
            if ((tempDir.exists() || tempDir.mkdirs()) && FileUtils.copy((InputStream)objectAsStream, (OutputStream)(fos = new FileOutputStream(fileLocation = File.createTempFile("validation", "tmp", tempDir))))) {
                objectAsFile = fileLocation;
            }
        }
        catch (IOException e) {
            if (objectAsFile.exists()) {
                objectAsFile.delete();
            }
            throw e;
        }
        return objectAsFile;
    }

    private void cleanUp(File f) {
        if (f.getParentFile() != null && new File(tempDir).getAbsolutePath().equalsIgnoreCase(f.getParentFile().getAbsolutePath())) {
            f.delete();
        }
    }
}

