/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.server.errors.ObjectValidityException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.validation.DOValidatorSchematronResult;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOValidatorSchematron {
    private static final Logger logger = LoggerFactory.getLogger(DOValidatorSchematron.class);
    private StreamSource rulesSource;
    private StreamSource preprocessorSource;
    private final StreamSource validatingStyleSheet;
    private static Map<String, ByteArrayOutputStream> generatedStyleSheets = new HashMap<String, ByteArrayOutputStream>();

    public DOValidatorSchematron(String schemaPath, String preprocessorPath, String phase) throws ObjectValidityException {
        this.validatingStyleSheet = this.setUp(preprocessorPath, schemaPath, phase);
    }

    public void validate(File objectAsFile) throws ServerException {
        this.validate(new StreamSource(objectAsFile));
    }

    public void validate(InputStream objectAsStream) throws ServerException {
        this.validate(new StreamSource(objectAsStream));
    }

    public void validate(StreamSource objectSource) throws ServerException {
        DOValidatorSchematronResult result = null;
        try {
            TransformerFactory tfactory = XmlTransformUtility.getTransformerFactory();
            Transformer vtransformer = tfactory.newTransformer(this.validatingStyleSheet);
            DOMResult validationResult = new DOMResult();
            vtransformer.transform(objectSource, validationResult);
            result = new DOValidatorSchematronResult(validationResult);
        }
        catch (Exception e) {
            Validation validation = new Validation("unknown");
            ArrayList<String> probs = new ArrayList<String>();
            probs.add("Schematron validation failed:" + e.getMessage());
            validation.setObjectProblems(probs);
            logger.error("Schematron validation failed", (Throwable)e);
            throw new ObjectValidityException(e.getMessage(), validation);
        }
        if (!result.isValid()) {
            String msg = null;
            try {
                msg = result.getXMLResult();
            }
            catch (Exception e) {
                logger.warn("Error getting XML result of schematron validation failure", (Throwable)e);
            }
            Validation validation = new Validation("unknown");
            ArrayList<String> probs = new ArrayList<String>();
            if (msg != null) {
                probs.add(msg);
            } else {
                probs.add("Unknown schematron error.  Error getting XML results of schematron validation");
            }
            throw new ObjectValidityException(msg, validation);
        }
    }

    private StreamSource setUp(String preprocessorPath, String fedoraschemaPath, String phase) throws ObjectValidityException {
        String key = fedoraschemaPath + "#" + phase;
        ByteArrayOutputStream out = generatedStyleSheets.get(key);
        if (out == null) {
            this.rulesSource = DOValidatorSchematron.fileToStreamSource(fedoraschemaPath);
            this.preprocessorSource = DOValidatorSchematron.fileToStreamSource(preprocessorPath);
            out = this.createValidatingStyleSheet(this.rulesSource, this.preprocessorSource, phase);
            generatedStyleSheets.put(key, out);
        }
        return new StreamSource(new ByteArrayInputStream(out.toByteArray()));
    }

    private ByteArrayOutputStream createValidatingStyleSheet(StreamSource rulesSource, StreamSource preprocessorSource, String phase) throws ObjectValidityException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            TransformerFactory tfactory = XmlTransformUtility.getTransformerFactory();
            Transformer ptransformer = tfactory.newTransformer(preprocessorSource);
            ptransformer.setParameter("phase", phase);
            ptransformer.transform(rulesSource, new StreamResult(out));
        }
        catch (TransformerException e) {
            logger.error("Schematron validation failed", (Throwable)e);
            throw new ObjectValidityException(e.getMessage());
        }
        return out;
    }

    public static StreamSource fileToStreamSource(String str) {
        return DOValidatorSchematron.fileToStreamSource(new File(str));
    }

    public static StreamSource fileToStreamSource(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            String url = new URL("file", null, path).toString();
            return new StreamSource(url);
        }
        catch (MalformedURLException e) {
            throw new Error("unexpected MalformedURLException");
        }
    }
}

