/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fcrepo.utilities.XmlTransformUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOValidatorSchematronResult {
    private static final Logger logger = LoggerFactory.getLogger(DOValidatorSchematronResult.class);
    private final StringBuffer string = new StringBuffer();
    private final Element rootElement;

    public DOValidatorSchematronResult(DOMResult result) {
        this.rootElement = (Element)result.getNode().getFirstChild();
    }

    public String getXMLResult() throws TransformerException, TransformerConfigurationException, ParserConfigurationException {
        StringWriter w = new StringWriter();
        PrintWriter out = new PrintWriter(w);
        TransformerFactory tfactory = XmlTransformUtility.getTransformerFactory();
        Transformer transformer = tfactory.newTransformer();
        Properties transProps = new Properties();
        transProps.put("method", "xml");
        transProps.put("indent", "yes");
        transformer.setOutputProperties(transProps);
        transformer.transform(new DOMSource(this.rootElement), new StreamResult(out));
        out.close();
        return ((Object)w).toString();
    }

    public boolean isValid() {
        return this.rootElement.getElementsByTagName("ASSERT").getLength() == 0 && this.rootElement.getElementsByTagName("REPORT").getLength() == 0;
    }

    public String serializeResult(Writer out) {
        return this.serializeNode(this.rootElement, out);
    }

    private String serializeNode(Node node, Writer out) {
        try {
            if (node == null) {
                return null;
            }
            short type = node.getNodeType();
            switch (type) {
                case 9: {
                    out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    this.string.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n");
                    this.serializeNode(((Document)node).getDocumentElement(), out);
                    break;
                }
                case 1: {
                    this.string.append("<");
                    this.string.append(node.getNodeName());
                    out.write("<");
                    out.write(node.getNodeName());
                    NamedNodeMap attrs = node.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        this.string.append(" ");
                        this.string.append(attrs.item(i).getNodeName());
                        this.string.append("=\"");
                        this.string.append(attrs.item(i).getNodeValue());
                        this.string.append("\"");
                        out.write(" ");
                        out.write(attrs.item(i).getNodeName());
                        out.write("=\"");
                        out.write(attrs.item(i).getNodeValue());
                        out.write("\"");
                    }
                    this.string.append(">");
                    out.write(">");
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.serializeNode(children.item(i), out);
                    }
                    break;
                }
                case 3: {
                    this.string.append(node.getNodeValue());
                    out.write(node.getNodeValue());
                }
            }
            if (type == 1) {
                this.string.append("</");
                this.string.append(node.getNodeName());
                this.string.append(">");
                out.write("</");
                out.write(node.getNodeName());
                out.write(">");
            }
            out.flush();
        }
        catch (Exception e) {
            logger.error("Error serializing node", (Throwable)e);
        }
        return this.string.toString();
    }
}

