/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.errors.ObjectValidityException;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.validation.DOValidatorXMLErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DOValidatorXMLSchema
implements Constants,
EntityResolver {
    private static final Logger logger = LoggerFactory.getLogger(DOValidatorXMLSchema.class);
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private URI schemaURI = null;

    public DOValidatorXMLSchema(String schemaPath) throws GeneralException {
        try {
            this.schemaURI = new File(schemaPath).toURI();
        }
        catch (Exception e) {
            logger.error("Error constructing validator", (Throwable)e);
            throw new GeneralException(e.getMessage());
        }
    }

    public void validate(File objectAsFile) throws ObjectValidityException, GeneralException {
        try {
            this.validate(new InputSource(new FileInputStream(objectAsFile)));
        }
        catch (IOException e) {
            String msg = "DOValidatorXMLSchema returned error.\nThe underlying exception was a " + e.getClass().getName() + ".\n" + "The message was " + "\"" + e.getMessage() + "\"";
            throw new GeneralException(msg);
        }
    }

    public void validate(InputStream objectAsStream) throws ObjectValidityException, GeneralException {
        this.validate(new InputSource(objectAsStream));
    }

    private void validate(InputSource objectAsSource) throws ObjectValidityException, GeneralException {
        InputSource doXML = objectAsSource;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(true);
            SAXParser sp = spf.newSAXParser();
            sp.setProperty(JAXP_SCHEMA_LANGUAGE, DOValidatorXMLSchema.XML_XSD.uri);
            sp.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.schemaURI.toString());
            XMLReader xmlreader = sp.getXMLReader();
            xmlreader.setErrorHandler(new DOValidatorXMLErrorHandler());
            xmlreader.setEntityResolver(this);
            xmlreader.parse(doXML);
        }
        catch (ParserConfigurationException e) {
            String msg = "DOValidatorXMLSchema returned parser error.\nThe underlying exception was a " + e.getClass().getName() + ".\n" + "The message was " + "\"" + e.getMessage() + "\"";
            throw new GeneralException(msg, e);
        }
        catch (SAXException e) {
            String msg = "DOValidatorXMLSchema returned validation exception.\nThe underlying exception was a " + e.getClass().getName() + ".\n" + "The message was " + "\"" + e.getMessage() + "\"";
            Validation validation = new Validation("unknown");
            ArrayList<String> problems = new ArrayList<String>();
            problems.add(msg);
            validation.setObjectProblems(problems);
            throw new ObjectValidityException(msg, validation, e);
        }
        catch (Exception e) {
            String msg = "DOValidatorXMLSchema returned error.\nThe underlying error was a " + e.getClass().getName() + ".\n" + "The message was " + "\"" + e.getMessage() + "\"";
            throw new GeneralException(msg, e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null && systemId.startsWith("file:")) {
            return null;
        }
        return new InputSource();
    }
}

