/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.utils.XMLChar;
import org.fcrepo.common.Constants;
import org.fcrepo.common.FaultException;
import org.fcrepo.common.PID;
import org.fcrepo.server.errors.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RelsValidator
extends DefaultHandler
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(RelsValidator.class);
    private String m_doURI;
    private String m_dsId;
    private boolean m_rootRDFFound;
    private int m_descriptionCount;
    private boolean m_withinDescription;
    private int m_depth;
    private String m_literalType;
    private StringBuffer m_literalValue;
    private final SAXParser m_parser;
    private static final String RELS_EXT = "RELS-EXT";
    private static final String RELS_INT = "RELS-INT";

    public RelsValidator() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            this.m_parser = spf.newSAXParser();
        }
        catch (Exception wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
    }

    public void validate(PID pid, String dsId, InputStream content) throws ValidationException {
        try {
            this.m_rootRDFFound = false;
            this.m_descriptionCount = 0;
            this.m_withinDescription = false;
            this.m_depth = 0;
            this.m_doURI = pid.toURI();
            if (!dsId.equals(RELS_EXT) && !dsId.equals(RELS_INT)) {
                throw new ValidationException("Relationships datastream ID must be RELS-EXT or RELS-INT (" + dsId + ")");
            }
            this.m_dsId = dsId;
            this.m_parser.parse(content, (DefaultHandler)this);
        }
        catch (Exception e) {
            throw new ValidationException(dsId + " validation failed: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String nsURI, String localName, String qName, Attributes a) throws SAXException {
        if (nsURI.equals(RelsValidator.RDF.uri) && localName.equalsIgnoreCase("RDF")) {
            this.m_rootRDFFound = true;
            return;
        } else {
            if (!this.m_rootRDFFound) throw new SAXException("RelsExtValidator: The 'RDF' root element was not found  in the RELS-EXT datastream.\n Relationship metadata must be encoded using RDF/XML.");
            if (nsURI.equals(RelsValidator.RDF.uri) && localName.equalsIgnoreCase("Description")) {
                if (this.m_withinDescription) throw new SAXException("RelsExtValidator: RDF <Description> elements may not be nested in the " + this.m_dsId + " datastream.");
                this.m_withinDescription = true;
                ++this.m_descriptionCount;
                ++this.m_depth;
                if (this.m_descriptionCount > 1 && this.m_dsId.equals(RELS_EXT)) {
                    throw new SAXException("RelsExtValidator: Only ONE RDF <Description> element is allowed in the RELS-EXT datastream.");
                }
                this.checkDepth(this.m_depth, qName);
                this.checkAboutURI(RelsValidator.grab(a, RelsValidator.RDF.uri, "about"));
                return;
            } else {
                if (!this.m_withinDescription) throw new SAXException("RelsExtValidator: Invalid element " + localName + " found in the RELS-EXT datastream.\n" + " Relationship assertions must be built" + " upon an RDF <Description> element.");
                ++this.m_depth;
                this.checkDepth(this.m_depth, qName);
                this.checkBadAssertion(nsURI, localName, qName);
                String resourceURI = RelsValidator.grab(a, RelsValidator.RDF.uri, "resource");
                if (resourceURI.length() > 0) {
                    this.checkResourceURI(resourceURI, qName);
                    this.m_literalType = null;
                    this.m_literalValue = null;
                    return;
                } else {
                    if (nsURI.equals(RelsValidator.MODEL.uri) && (localName.equals(RelsValidator.MODEL.HAS_SERVICE.localName) || localName.equals(RelsValidator.MODEL.HAS_MODEL.localName) || localName.equals(RelsValidator.MODEL.IS_CONTRACTOR_OF.localName) || localName.equals(RelsValidator.MODEL.IS_DEPLOYMENT_OF.localName))) {
                        throw new SAXException("RelsExtValidator: Target of " + qName + " statement " + "MUST be an rdf:resource");
                    }
                    String datatypeURI = RelsValidator.grab(a, RelsValidator.RDF.uri, "datatype");
                    this.m_literalType = datatypeURI.length() == 0 ? null : datatypeURI;
                    this.m_literalValue = new StringBuffer();
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.m_literalValue != null) {
            this.m_literalValue.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String nsURI, String localName, String qName) throws SAXException {
        if (this.m_rootRDFFound) {
            --this.m_depth;
        }
        if (nsURI.equals(RelsValidator.RDF.uri) && localName.equalsIgnoreCase("Description")) {
            this.m_withinDescription = false;
        }
        if (this.m_literalType != null && this.m_literalValue != null) {
            this.checkTypedValue(this.m_literalType, this.m_literalValue.toString(), qName);
        }
        this.m_literalType = null;
        this.m_literalValue = null;
    }

    private static String grab(Attributes a, String namespace, String elementName) {
        String ret = a.getValue(namespace, elementName);
        if (ret == null) {
            ret = a.getValue(elementName);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    private void checkDepth(int depth, String qName) throws SAXException {
        if (depth > 2) {
            throw new SAXException("RelsExtValidator: The RELS-EXT datastream has improper nesting in its relationship assertions.\n (The XML depth is " + depth + " which must not exceed a depth of 2.\n" + " The root <RDF> element should be level 0," + " the <Description> element should be level 1," + " and relationship elements should be level 2.)");
        }
    }

    private void checkBadAssertion(String nsURI, String localName, String qName) throws SAXException {
        if (this.m_dsId.equals(RELS_EXT) && (nsURI.equals(RelsValidator.DC.uri) || nsURI.equals(RelsValidator.OAI_DC.uri))) {
            throw new SAXException("RelsExtValidator: The RELS-EXT datastream has improper relationship assertion: " + qName + ".\n" + " No Dublin Core assertions allowed" + " in Fedora relationship metadata.");
        }
        if (nsURI.equals(RelsValidator.MODEL.uri)) {
            if (this.m_dsId.equals(RELS_INT) && !localName.equals(RelsValidator.MODEL.DOWNLOAD_FILENAME.localName) || this.m_dsId.equals(RELS_EXT) && !localName.equals(RelsValidator.MODEL.HAS_SERVICE.localName) && !localName.equals(RelsValidator.MODEL.IS_CONTRACTOR_OF.localName) && !localName.equals(RelsValidator.MODEL.HAS_MODEL.localName) && !localName.equals(RelsValidator.MODEL.IS_DEPLOYMENT_OF.localName)) {
                throw new SAXException("RelsExtValidator: Disallowed predicate in " + this.m_dsId + ": " + qName + "\n" + " The only predicates from the fedora-model namespace" + " allowed in RELS-EXT are " + RelsValidator.MODEL.HAS_SERVICE.localName + ", " + RelsValidator.MODEL.IS_CONTRACTOR_OF.localName + ", " + RelsValidator.MODEL.HAS_MODEL.localName + ", " + RelsValidator.MODEL.IS_DEPLOYMENT_OF.localName + ".  The only predicate allowed " + "in RELS-INT is " + RelsValidator.MODEL.DOWNLOAD_FILENAME.localName + ".");
            }
        } else if (nsURI.equals(RelsValidator.VIEW.uri)) {
            throw new SAXException("RelsExtValidator: Disallowed predicate in RELS-EXT: " + qName + "\n" + " The fedora-view namespace is reserved by Fedora.");
        }
    }

    private void checkAboutURI(String aboutURI) throws SAXException {
        if (this.m_dsId.equals(RELS_EXT)) {
            if (!this.m_doURI.equals(aboutURI)) {
                throw new SAXException("RelsExtValidator: The RELS-EXT datastream refers to an improper URI in the 'about' attribute of the RDF <Description> element.\n The URI must be that of the digital object in which the RELS-EXT datastream resides (" + this.m_doURI + ").");
            }
        } else if (this.m_dsId.equals(RELS_INT)) {
            if (!aboutURI.startsWith(this.m_doURI + "/")) {
                throw new SAXException("RelsExtValidator: The RELS-INT datastream refers to an improper URI in the 'about' attribute of the RDF <Description> element.\n The URI must be a datastream in the digital object in which the RELS-INT datastream resides (" + this.m_doURI + ", " + aboutURI + ").");
            }
            String dsId = aboutURI.replace(this.m_doURI + "/", "");
            if (dsId.length() > 64 || dsId.length() < 1 || !RelsValidator.isValid(dsId)) {
                throw new SAXException("RelsExtValidator: The RELS-INT datastream refers to an improper URI in the 'about' attribute of the RDF <Description> element.\n " + dsId + " is not a valid datastream ID");
            }
        }
    }

    private static boolean isValid(String stValue) {
        boolean bValid = true;
        for (int scan = 0; scan < stValue.length() && (bValid = scan == 0 ? XMLChar.isNCNameStart((int)stValue.charAt(scan)) : XMLChar.isNCName((int)stValue.charAt(scan))); ++scan) {
        }
        return bValid;
    }

    private void checkResourceURI(String resourceURI, String relName) throws SAXException {
        URI uri;
        try {
            uri = new URI(resourceURI);
        }
        catch (Exception e) {
            throw new SAXException("RelsExtValidator:Error in relationship '" + relName + "'." + " The RDF 'resource' is not a valid URI.");
        }
        if (!uri.isAbsolute()) {
            throw new SAXException("RelsValidator:Error in relationship '" + relName + "'." + " The specified RDF 'resource' is not an absolute URI.");
        }
    }

    private void checkTypedValue(String datatypeURI, String value, String relName) throws SAXException {
        if (datatypeURI.equals(RelsValidator.RDF_XSD.INT.uri)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new SAXException("RelsExtValidator: The value specified for " + relName + " is not a valid 'int' value");
            }
        } else if (datatypeURI.equals(RelsValidator.RDF_XSD.LONG.uri)) {
            try {
                Long.parseLong(value);
            }
            catch (Exception e) {
                throw new SAXException("RelsExtValidator: The value specified for " + relName + " is not a valid 'long' value");
            }
        } else if (datatypeURI.equals(RelsValidator.RDF_XSD.FLOAT.uri)) {
            try {
                Float.parseFloat(value);
            }
            catch (Exception e) {
                throw new SAXException("RelsExtValidator: The value specified for " + relName + " is not a valid 'float' value");
            }
        } else if (datatypeURI.equals(RelsValidator.RDF_XSD.DOUBLE.uri)) {
            try {
                Double.parseDouble(value);
            }
            catch (Exception e) {
                throw new SAXException("RelsExtValidator: The value specified for " + relName + " is not a valid 'double' value");
            }
        } else if (datatypeURI.equals(RelsValidator.RDF_XSD.DATE_TIME.uri)) {
            if (!RelsValidator.isValidDateTime(value)) {
                throw new SAXException("RelsExtValidator: The value specified for " + relName + " is not a valid 'dateTime' value.\n" + "The following dateTime formats are allowed:\n" + "  yyyy-MM-ddTHH:mm:ss\n" + "  yyyy-MM-ddTHH:mm:ss.S\n" + "  yyyy-MM-ddTHH:mm:ss.SS\n" + "  yyyy-MM-ddTHH:mm:ss.SSS\n" + "  yyyy-MM-ddTHH:mm:ss.SSSZ");
            }
        } else {
            throw new SAXException("RelsExtValidator: Error in relationship '" + relName + "'.\n" + " The RELS-EXT datastream does not support the specified" + " datatype.\n" + "If specified, the RDF 'datatype' must be the URI of one of\n" + "the following W3C XML Schema data types: int, long, float,\n" + "double, or dateTime");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidDateTime(String lex) {
        SimpleDateFormat format;
        block16: {
            int length;
            block17: {
                block18: {
                    format = new SimpleDateFormat();
                    format.setTimeZone(TimeZone.getTimeZone("UTC"));
                    length = lex.length();
                    if (lex.startsWith("-")) {
                        --length;
                    }
                    if (!lex.endsWith("Z")) break block17;
                    if (length != 20) break block18;
                    format.applyPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    break block16;
                }
                if (length == 22) {
                    format.applyPattern("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
                    break block16;
                } else if (length == 23) {
                    format.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
                    break block16;
                } else {
                    if (length != 24) {
                        logger.warn("Not a valid dateTime: " + lex);
                        return false;
                    }
                    format.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                }
                break block16;
            }
            if (length == 19) {
                format.applyPattern("yyyy-MM-dd'T'HH:mm:ss");
            } else if (length == 21) {
                format.applyPattern("yyyy-MM-dd'T'HH:mm:ss.S");
            } else if (length == 22) {
                format.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SS");
            } else {
                if (length != 23) {
                    logger.warn("Not a valid dateTime: " + lex);
                    return false;
                }
                format.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
            }
        }
        try {
            format.parse(lex);
            if (logger.isTraceEnabled()) {
                logger.trace("Validated dateTime: " + lex);
            }
            return true;
        }
        catch (ParseException e) {
            logger.warn("Not a valid dateTime: " + lex);
            return false;
        }
    }
}

