/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.fcrepo.common.FaultException;
import org.fcrepo.common.PID;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.security.PolicyParser;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.validation.RelsValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidationUtility {
    private static final Logger logger = LoggerFactory.getLogger(ValidationUtility.class);
    private static PolicyParser policyParser;
    private static PolicyParser feslPolicyParser;
    private static boolean validateFeslPolicy;

    public static void validateURL(String url, String controlGroup) throws ValidationException {
        if (!controlGroup.equalsIgnoreCase("M") && !controlGroup.equalsIgnoreCase("E") && url.startsWith("file:")) {
            throw new ValidationException("Malformed URL (file: not allowed for control group " + controlGroup + ") " + url);
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            if (url.startsWith("uploaded://")) {
                return;
            }
            throw new ValidationException("Malformed URL: " + url, e);
        }
    }

    public static void setPolicyParser(PolicyParser parser) {
        policyParser = parser;
    }

    public static void setFeslPolicyParser(PolicyParser parser) {
        feslPolicyParser = parser;
    }

    public static void setValidateFeslPolicy(boolean validate) {
        validateFeslPolicy = validate;
    }

    public static void validateReservedDatastreams(DOReader reader) throws ValidationException {
        try {
            for (Datastream ds : reader.GetDatastreams(null, null)) {
                if (!"X".equals(ds.DSControlGrp) && !"M".equals(ds.DSControlGrp)) continue;
                ValidationUtility.validateReservedDatastream(PID.getInstance((String)reader.GetObjectPID()), ds.DatastreamID, ds);
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (ServerException e) {
            throw new FaultException((Throwable)e);
        }
    }

    public static void validateReservedDatastream(PID pid, String dsId, Datastream ds) throws ValidationException {
        InputStream content = null;
        try {
            if ("POLICY".equals(dsId)) {
                content = ds.getContentStream();
                ValidationUtility.validatePOLICY(content);
            } else if ("FESLPOLICY".equals(dsId)) {
                content = ds.getContentStream();
                ValidationUtility.validateFESLPOLICY(content);
            } else if ("RELS-EXT".equals(dsId) || "RELS-INT".equals(dsId)) {
                content = ds.getContentStream();
                ValidationUtility.validateRELS(pid, dsId, content);
            }
        }
        catch (StreamIOException e) {
            throw new ValidationException("Failed to get content stream for " + pid + "/" + dsId + ": " + e.getMessage(), e);
        }
        if (content != null) {
            try {
                content.close();
            }
            catch (IOException e) {
                throw new ValidationException("Error closing content stream for " + pid + "/" + dsId + ": " + e.getMessage(), e);
            }
        }
    }

    private static void validatePOLICY(InputStream content) throws ValidationException {
        logger.debug("Validating POLICY datastream");
        policyParser.copy().parse(content, true);
        logger.debug("POLICY datastream is valid");
    }

    private static void validateFESLPOLICY(InputStream content) throws ValidationException {
        if (feslPolicyParser != null) {
            logger.debug("Validating FESLPOLICY datastream");
            feslPolicyParser.copy().parse(content, validateFeslPolicy);
            logger.debug("FESLPOLICY datastream is valid");
        }
    }

    private static void validateRELS(PID pid, String dsId, InputStream content) throws ValidationException {
        logger.debug("Validating " + dsId + " datastream");
        new RelsValidator().validate(pid, dsId, content);
        logger.debug(dsId + " datastream is valid");
    }

    static {
        validateFeslPolicy = false;
    }
}

