/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation.ecm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXB;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.validation.ecm.Errors;
import org.fcrepo.server.validation.ecm.FormValidator;
import org.fcrepo.server.validation.ecm.SchemaValidator;
import org.fcrepo.server.validation.ecm.jaxb.DsCompositeModel;
import org.fcrepo.server.validation.ecm.jaxb.DsTypeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastreamValidator {
    private SchemaValidator schemaValidator;
    private FormValidator formValidator;
    private RepositoryReader doMgr;
    private static final Logger logger = LoggerFactory.getLogger(DatastreamValidator.class);

    public DatastreamValidator(RepositoryReader doMgr) {
        this.doMgr = doMgr;
        this.schemaValidator = new SchemaValidator(doMgr);
        this.formValidator = new FormValidator();
    }

    public void validate(Context context, DOReader currentObjectReader, Date asOfDateTime, Validation validation, ExternalContentManager m_exExternalContentManager) throws ServerException {
        List<String> contentmodels = currentObjectReader.getContentModels();
        for (String contentmodel : contentmodels) {
            DOReader contentmodelReader = this.doMgr.getReader(false, context, contentmodel = contentmodel.substring("info:fedora/".length()));
            Datastream dscompmodelDS = contentmodelReader.GetDatastream("DS-COMPOSITE-MODEL", asOfDateTime);
            if (dscompmodelDS == null) continue;
            DsCompositeModel dscompobject = (DsCompositeModel)JAXB.unmarshal((InputStream)dscompmodelDS.getContentStream(), DsCompositeModel.class);
            for (DsTypeModel typeModel : dscompobject.getDsTypeModel()) {
                String DSID = typeModel.getID();
                Datastream objectDatastream = currentObjectReader.GetDatastream(DSID, asOfDateTime);
                if (objectDatastream == null) {
                    Boolean optional = typeModel.isOptional();
                    if (optional != null && optional.booleanValue()) continue;
                    this.reportMissingDatastreamError(contentmodel, DSID, validation);
                    continue;
                }
                this.formValidator.checkFormAndMime(typeModel, objectDatastream, validation, contentmodelReader);
                this.schemaValidator.validate(context, typeModel, objectDatastream, validation, contentmodelReader, asOfDateTime, m_exExternalContentManager);
            }
        }
    }

    private void reportMissingDatastreamError(String contentmodel, String dsid, Validation validation) {
        List<String> problems = validation.getDatastreamProblems().get(dsid);
        if (problems == null) {
            problems = new ArrayList<String>();
            validation.getDatastreamProblems().put(dsid, problems);
        }
        problems.add(Errors.missingRequiredDatastream(dsid, contentmodel));
        validation.setValid(false);
    }
}

