/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation.ecm;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXB;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.validation.ecm.Errors;
import org.fcrepo.server.validation.ecm.jaxb.DsCompositeModel;
import org.fcrepo.server.validation.ecm.jaxb.DsTypeModel;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologySetProvider;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;
import org.semanticweb.owlapi.util.OWLOntologyMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwlValidator {
    private RepositoryReader doMgr;
    private static final Logger logger = LoggerFactory.getLogger(OwlValidator.class);

    public OwlValidator(RepositoryReader doMgr) {
        this.doMgr = doMgr;
    }

    public void validate(Context context, Date asOfDateTime, DOReader currentObjectReader, Validation validation) throws ServerException {
        OWLOntologyManager owlManager = OWLManager.createOWLOntologyManager();
        List<String> contentmodels = currentObjectReader.getContentModels();
        for (String contentmodel : contentmodels) {
            Datastream ontologyDS;
            DOReader contentmodelReader;
            contentmodel = contentmodel.substring("info:fedora/".length());
            try {
                contentmodelReader = this.doMgr.getReader(false, context, contentmodel);
            }
            catch (LowlevelStorageException e) {
                continue;
            }
            if (asOfDateTime != null && !contentmodelReader.getCreateDate().before(asOfDateTime) || (ontologyDS = contentmodelReader.GetDatastream("ONTOLOGY", asOfDateTime)) == null) continue;
            InputStream ontologyStream = ontologyDS.getContentStream();
            try {
                owlManager.loadOntologyFromOntologyDocument(ontologyStream);
            }
            catch (OWLOntologyCreationException e) {
                logger.debug("Failed to load ontology for object " + currentObjectReader.GetObjectPID(), (Throwable)e);
            }
        }
        OWLOntologyMerger merger = new OWLOntologyMerger((OWLOntologySetProvider)owlManager);
        IRI mergedOntologyIRI = IRI.create((String)"http://www.semanticweb.com/mymergedont");
        OWLOntology mergedOntology = null;
        try {
            mergedOntology = merger.createMergedOntology(owlManager, mergedOntologyIRI);
        }
        catch (OWLOntologyCreationException e) {
            logger.debug("Failed to load ontology for object " + currentObjectReader.GetObjectPID(), (Throwable)e);
        }
        RestrictionVisitor restrictionVisitor = new RestrictionVisitor(Collections.singleton(mergedOntology));
        Set<RelationshipTuple> relations = currentObjectReader.getRelationships();
        for (String contentmodel : contentmodels) {
            List<String> datastreamNames = this.getDatastreamNames(context, contentmodel, asOfDateTime);
            for (String datastreamName : datastreamNames) {
                IRI datastreamDeclaration = this.toIRI(contentmodel, datastreamName);
                OWLClass datastreamClass = owlManager.getOWLDataFactory().getOWLClass(datastreamDeclaration);
                for (OWLSubClassOfAxiom ax : mergedOntology.getSubClassAxiomsForSubClass(datastreamClass)) {
                    OWLClassExpression superCls = ax.getSuperClass();
                    superCls.accept((OWLClassExpressionVisitor)restrictionVisitor);
                }
                String datastream = "info:fedora/" + currentObjectReader.GetObjectPID() + "/" + datastreamName;
                Set<RelationshipTuple> relationsAbout = this.getRelationsSubjectTo(relations, datastream);
                this.checkMinCardinality(datastream, relationsAbout, restrictionVisitor, validation);
                this.checkMaxCardinality(datastream, relationsAbout, restrictionVisitor, validation);
                this.checkExactCardinality(datastream, relationsAbout, restrictionVisitor, validation);
                this.checkSomeValuesFrom(datastream, relationsAbout, restrictionVisitor, validation, context);
                this.checkAllValuesFrom(datastream, relationsAbout, restrictionVisitor, validation, context);
                restrictionVisitor.reset();
            }
        }
        for (String contentmodel : contentmodels) {
            IRI objectDeclaration = this.toIRI(contentmodel, null);
            OWLClass objectClass = owlManager.getOWLDataFactory().getOWLClass(objectDeclaration);
            for (OWLSubClassOfAxiom ax : mergedOntology.getSubClassAxiomsForSubClass(objectClass)) {
                OWLClassExpression superCls = ax.getSuperClass();
                superCls.accept((OWLClassExpressionVisitor)restrictionVisitor);
            }
            String pid = "info:fedora/" + currentObjectReader.GetObjectPID();
            Set<RelationshipTuple> relationsAbout = this.getRelationsSubjectTo(relations, pid);
            this.checkMinCardinality(pid, relationsAbout, restrictionVisitor, validation);
            this.checkMaxCardinality(pid, relationsAbout, restrictionVisitor, validation);
            this.checkExactCardinality(pid, relationsAbout, restrictionVisitor, validation);
            this.checkSomeValuesFrom(pid, relationsAbout, restrictionVisitor, validation, context);
            this.checkAllValuesFrom(pid, relationsAbout, restrictionVisitor, validation, context);
            restrictionVisitor.reset();
        }
    }

    private Set<RelationshipTuple> getRelationsSubjectTo(Set<RelationshipTuple> relations, String datastream) {
        HashSet<RelationshipTuple> found = new HashSet<RelationshipTuple>();
        for (RelationshipTuple relation : relations) {
            if (!relation.subject.equals(datastream)) continue;
            found.add(relation);
        }
        return found;
    }

    private void checkAllValuesFrom(String subject, Set<RelationshipTuple> relations, RestrictionVisitor restrictionVisitor, Validation validation, Context context) throws ServerException {
        Map<OWLObjectProperty, OWLClass> map = restrictionVisitor.getAllValuesFrom();
        for (OWLObjectProperty owlObjectProperty : map.keySet()) {
            String ontologyrelation = owlObjectProperty.getIRI().toString();
            OWLClass requiredclass = map.get(owlObjectProperty);
            String requiredTarget = requiredclass.getIRI().toString();
            for (RelationshipTuple relation : relations) {
                List<String> classes;
                String objectRelationName = relation.predicate;
                if (!objectRelationName.equals(ontologyrelation)) continue;
                String target = relation.object;
                try {
                    classes = this.getClassesOfTarget(target, context);
                }
                catch (ServerException e) {
                    validation.setValid(false);
                    validation.getObjectProblems().add(Errors.missingObjectViolation(subject, objectRelationName, requiredTarget, target));
                    continue;
                }
                boolean found = false;
                for (String aClass : classes) {
                    if (!aClass.equals(requiredclass.getIRI().toString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                validation.setValid(false);
                validation.getObjectProblems().add(Errors.allValuesFromViolation(subject, ontologyrelation, requiredTarget));
            }
        }
    }

    private List<String> getClassesOfTarget(String target, Context context) throws ServerException {
        String targetPid;
        ArrayList<String> classes = new ArrayList<String>();
        if (!target.startsWith("info:fedora/")) {
            return new ArrayList<String>();
        }
        target = target.substring("info:fedora/".length());
        int lastIndexOfSlash = target.lastIndexOf("/");
        String dsname = "";
        if (lastIndexOfSlash > 0) {
            targetPid = target.substring(0, lastIndexOfSlash);
            dsname = "datastreams/" + target.substring(lastIndexOfSlash + 1) + "/";
        } else {
            targetPid = target;
        }
        DOReader targetReader = this.doMgr.getReader(false, context, targetPid);
        List<String> targetContentModels = targetReader.getContentModels();
        for (String targetContentModel : targetContentModels) {
            targetContentModel = targetContentModel + "#" + dsname + "class";
            classes.add(targetContentModel);
        }
        return classes;
    }

    private void checkSomeValuesFrom(String subject, Set<RelationshipTuple> relations, RestrictionVisitor restrictionVisitor, Validation validation, Context context) throws ServerException {
        Map<OWLObjectProperty, OWLClass> map = restrictionVisitor.getSomeValuesFrom();
        for (OWLObjectProperty owlObjectProperty : map.keySet()) {
            String ontologyrelation = owlObjectProperty.getIRI().toString();
            OWLClass requiredclass = map.get(owlObjectProperty);
            String requiredTarget = requiredclass.getIRI().toString();
            int count = this.countRelations(ontologyrelation, relations);
            if (count < 1) {
                validation.setValid(false);
                validation.getObjectProblems().add(Errors.someValuesFromViolationNoSuchRelation(subject, ontologyrelation, requiredTarget));
                continue;
            }
            boolean found = false;
            block3: for (RelationshipTuple relation : relations) {
                List<String> classes;
                String objectRelationName = relation.predicate;
                if (!objectRelationName.equals(ontologyrelation)) continue;
                String target = relation.object;
                try {
                    classes = this.getClassesOfTarget(target, context);
                }
                catch (ServerException e) {
                    continue;
                }
                for (String aClass : classes) {
                    if (!aClass.equals(requiredclass.getIRI().toString())) continue;
                    found = true;
                    continue block3;
                }
            }
            if (found) continue;
            validation.setValid(false);
            validation.getObjectProblems().add(Errors.someValuesFromViolationWrongClassOfTarget(subject, ontologyrelation, requiredTarget));
        }
    }

    private void checkMinCardinality(String subject, Set<RelationshipTuple> relations, RestrictionVisitor restrictionVisitor, Validation validation) {
        Map<OWLObjectProperty, Integer> map = restrictionVisitor.getMinCardinality();
        for (OWLObjectProperty owlObjectProperty : map.keySet()) {
            int min;
            String ontologyrelation = owlObjectProperty.getIRI().toString();
            int count = this.countRelations(ontologyrelation, relations);
            if (count >= (min = map.get(owlObjectProperty).intValue())) continue;
            validation.setValid(false);
            validation.getObjectProblems().add(Errors.minCardinalityViolation(subject, ontologyrelation, min));
        }
    }

    private void checkMaxCardinality(String subject, Set<RelationshipTuple> relations, RestrictionVisitor restrictionVisitor, Validation validation) {
        Map<OWLObjectProperty, Integer> map = restrictionVisitor.getMaxCardinality();
        for (OWLObjectProperty owlObjectProperty : map.keySet()) {
            int max;
            String ontologyrelation = owlObjectProperty.getIRI().toString();
            int count = this.countRelations(ontologyrelation, relations);
            if (count <= (max = map.get(owlObjectProperty).intValue())) continue;
            validation.setValid(false);
            validation.getObjectProblems().add(Errors.maxCardinalityViolation(subject, ontologyrelation, max));
        }
    }

    private void checkExactCardinality(String subject, Set<RelationshipTuple> relations, RestrictionVisitor restrictionVisitor, Validation validation) {
        Map<OWLObjectProperty, Integer> map = restrictionVisitor.getCardinality();
        for (OWLObjectProperty owlObjectProperty : map.keySet()) {
            Integer exact;
            String ontologyrelation = owlObjectProperty.getIRI().toString();
            int count = this.countRelations(ontologyrelation, relations);
            if (count == (exact = map.get(owlObjectProperty))) continue;
            validation.setValid(false);
            validation.getObjectProblems().add(Errors.exactCardinalityViolation(subject, ontologyrelation, exact));
        }
    }

    private int countRelations(String relationName, Set<RelationshipTuple> objectRelations) {
        int count = 0;
        if (objectRelations == null) {
            return 0;
        }
        for (RelationshipTuple objectRelation : objectRelations) {
            if (!objectRelation.predicate.equals(relationName)) continue;
            ++count;
        }
        return count;
    }

    private IRI toIRI(String contentmodel, String datastreamName) {
        if (!contentmodel.startsWith("info:fedora/")) {
            contentmodel = "info:fedora/" + contentmodel;
        }
        datastreamName = datastreamName != null ? "datastreams/" + datastreamName + "/" : "";
        return IRI.create((String)(contentmodel + "#" + datastreamName + "class"));
    }

    private List<String> getDatastreamNames(Context context, String contentmodel, Date asOfDateTime) throws ServerException {
        DOReader reader;
        Datastream dscompmodelDS;
        ArrayList<String> names = new ArrayList<String>();
        if (contentmodel.startsWith("info:fedora/")) {
            contentmodel = contentmodel.substring("info:fedora/".length());
        }
        if ((dscompmodelDS = (reader = this.doMgr.getReader(false, context, contentmodel)).GetDatastream("DS-COMPOSITE-MODEL", asOfDateTime)) == null) {
            return names;
        }
        DsCompositeModel dscompobject = (DsCompositeModel)JAXB.unmarshal((InputStream)dscompmodelDS.getContentStream(context), DsCompositeModel.class);
        for (DsTypeModel typeModel : dscompobject.getDsTypeModel()) {
            names.add(typeModel.getID());
        }
        return names;
    }

    private static class RestrictionVisitor
    extends OWLClassExpressionVisitorAdapter {
        private boolean processInherited = true;
        private Set<OWLClass> processedClasses;
        private Map<OWLObjectProperty, OWLClass> someValuesFrom = new HashMap<OWLObjectProperty, OWLClass>();
        private Map<OWLObjectProperty, OWLClass> allValuesFrom = new HashMap<OWLObjectProperty, OWLClass>();
        private Map<OWLObjectProperty, Integer> minCardinality = new HashMap<OWLObjectProperty, Integer>();
        private Map<OWLObjectProperty, Integer> cardinality = new HashMap<OWLObjectProperty, Integer>();
        private Map<OWLObjectProperty, Integer> maxCardinality = new HashMap<OWLObjectProperty, Integer>();
        private Set<OWLOntology> onts;

        public RestrictionVisitor(Set<OWLOntology> onts) {
            this.processedClasses = new HashSet<OWLClass>();
            this.onts = onts;
        }

        public void setProcessInherited(boolean processInherited) {
            this.processInherited = processInherited;
        }

        public void visit(OWLClass desc) {
            if (this.processInherited && !this.processedClasses.contains(desc)) {
                this.processedClasses.add(desc);
                for (OWLOntology ont : this.onts) {
                    for (OWLSubClassOfAxiom ax : ont.getSubClassAxiomsForSubClass(desc)) {
                        ax.getSuperClass().accept((OWLClassExpressionVisitor)this);
                    }
                }
            }
        }

        public void reset() {
            this.processedClasses.clear();
            this.someValuesFrom.clear();
            this.allValuesFrom.clear();
            this.minCardinality.clear();
            this.cardinality.clear();
            this.maxCardinality.clear();
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.cardinality.put(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty(), desc.getCardinality());
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.maxCardinality.put(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty(), desc.getCardinality());
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.minCardinality.put(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty(), desc.getCardinality());
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            this.allValuesFrom.put(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty(), ((OWLClassExpression)desc.getFiller()).asOWLClass());
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            this.someValuesFrom.put(((OWLObjectPropertyExpression)desc.getProperty()).asOWLObjectProperty(), ((OWLClassExpression)desc.getFiller()).asOWLClass());
        }

        public void visit(OWLDataSomeValuesFrom desc) {
        }

        public void visit(OWLDataAllValuesFrom desc) {
        }

        public void visit(OWLDataMinCardinality desc) {
        }

        public void visit(OWLDataExactCardinality desc) {
        }

        public void visit(OWLDataMaxCardinality desc) {
        }

        public Map<OWLObjectProperty, OWLClass> getSomeValuesFrom() {
            return this.someValuesFrom;
        }

        public Map<OWLObjectProperty, OWLClass> getAllValuesFrom() {
            return this.allValuesFrom;
        }

        public Map<OWLObjectProperty, Integer> getMinCardinality() {
            return this.minCardinality;
        }

        public Map<OWLObjectProperty, Integer> getCardinality() {
            return this.cardinality;
        }

        public Map<OWLObjectProperty, Integer> getMaxCardinality() {
            return this.maxCardinality;
        }
    }
}

