/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.validation.ecm;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.ContentManagerParams;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.ExternalContentManager;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.MIMETypedStream;
import org.fcrepo.server.storage.types.Validation;
import org.fcrepo.server.validation.ecm.Errors;
import org.fcrepo.server.validation.ecm.jaxb.DsTypeModel;
import org.fcrepo.server.validation.ecm.jaxb.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaValidator {
    private RepositoryReader doMgr;
    private static final Logger logger = LoggerFactory.getLogger(SchemaValidator.class);

    public SchemaValidator(RepositoryReader doMgr) {
        this.doMgr = doMgr;
    }

    /*
     * WARNING - void declaration
     */
    void validate(Context context, DsTypeModel typeModel, Datastream objectDatastream, Validation validation, DOReader contentmodelReader, Date asOfDateTime, ExternalContentManager m_exExternalContentManager) throws ServerException {
        List<Extension> extensions = typeModel.getExtension();
        ArrayList<List<String>> schemaStreamsToProblemsMap = new ArrayList<List<String>>();
        for (Extension extension : extensions) {
            Schema schema;
            void var13_17;
            String string = extension.getName();
            Object var13_18 = null;
            Source source = null;
            if (!"SCHEMA".equals(string)) continue;
            List<Element> contents = extension.getAny();
            for (Element content : contents) {
                String tagname = content.getTagName();
                if (!tagname.equals("reference")) continue;
                Element element = content;
                break;
            }
            if (var13_17 == null) {
                boolean found = false;
                for (Element content : contents) {
                    if (content.getNodeType() != 1) continue;
                    source = new DOMSource(content);
                    found = true;
                    break;
                }
                if (!found) {
                    List<String> validationProblems = validation.getDatastreamProblems(objectDatastream.DatastreamID);
                    validationProblems.add(Errors.schemaNotFound(contentmodelReader.GetObjectPID()));
                    validation.setValid(false);
                }
            } else {
                String type = var13_17.getAttribute("type");
                String value = var13_17.getAttribute("value");
                if ("datastream".equalsIgnoreCase(type)) {
                    Datastream schemaDS = contentmodelReader.GetDatastream(value, asOfDateTime);
                    if (schemaDS == null) continue;
                    InputStream schemaStream = schemaDS.getContentStream();
                    source = new StreamSource(schemaStream);
                } else if ("url".equalsIgnoreCase(type)) {
                    ContentManagerParams params = new ContentManagerParams(value);
                    MIMETypedStream externalContent = m_exExternalContentManager.getExternalContent(params);
                    InputStream schemaStream = externalContent.getStream();
                    source = new StreamSource(schemaStream);
                } else {
                    List<String> validationProblems = validation.getDatastreamProblems(objectDatastream.DatastreamID);
                    validationProblems.add(Errors.schemaNotFound(contentmodelReader.GetObjectPID()));
                    validation.setValid(false);
                    continue;
                }
            }
            ResourceResolver resourceResolver = new ResourceResolver(context, this.doMgr, contentmodelReader, asOfDateTime);
            try {
                schema = this.parseAsSchema(source, resourceResolver);
            }
            catch (SAXException e) {
                List<String> validationProblems = validation.getDatastreamProblems(objectDatastream.DatastreamID);
                validationProblems.add(Errors.schemaCannotParse(contentmodelReader.GetObjectPID(), objectDatastream.DatastreamID, e));
                validation.setValid(false);
                continue;
            }
            List<String> problems = this.checkSchema(objectDatastream.getContentStream(), schema, contentmodelReader.GetObjectPID(), objectDatastream.DatastreamID);
            schemaStreamsToProblemsMap.add(problems);
            if (!problems.isEmpty()) continue;
            break;
        }
        boolean foundProblem = false;
        for (List list : schemaStreamsToProblemsMap) {
            if (list.isEmpty()) continue;
            foundProblem = true;
            break;
        }
        if (foundProblem) {
            validation.setValid(false);
            List<String> validationProblems = validation.getDatastreamProblems(objectDatastream.DatastreamID);
            for (List list : schemaStreamsToProblemsMap) {
                validationProblems.addAll(list);
            }
        }
    }

    private Schema parseAsSchema(Source input, LSResourceResolver resolver) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(resolver);
        Schema schema = schemaFactory.newSchema(input);
        return schema;
    }

    public List<String> checkSchema(InputStream objectStream, Schema schema, String contentModel, String datastreamID) {
        ArrayList<String> problems = new ArrayList<String>();
        ReportingErrorHandler errorhandler = new ReportingErrorHandler(problems, contentModel, datastreamID);
        try {
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorhandler);
            validator.validate(new StreamSource(objectStream));
        }
        catch (SAXException e) {
            problems.add(Errors.invalidContentInDatastream(datastreamID, contentModel, e));
        }
        catch (IOException e) {
            problems.add(Errors.unableToReadDatastream(datastreamID, e));
        }
        return problems;
    }

    public static class ReportingErrorHandler
    implements ErrorHandler {
        private List<String> problems;
        private String contentModel;
        private String datastreamID;

        public ReportingErrorHandler(List<String> problems, String contentModel, String datastreamID) {
            this.problems = problems;
            this.contentModel = contentModel;
            this.datastreamID = datastreamID;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.problems.add(Errors.schemaValidationWarning(this.datastreamID, this.contentModel, exception));
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.problems.add(Errors.schemaValidationError(this.datastreamID, this.contentModel, exception));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.problems.add(Errors.schemaValidationFatalError(this.datastreamID, this.contentModel, exception));
        }
    }

    public static class ResourceResolver
    implements LSResourceResolver {
        private Context context;
        private RepositoryReader doMgr;
        private DOReader contentmodelReader;
        private Date asOfDateTime;

        public ResourceResolver(Context context, RepositoryReader doMgr, DOReader contentmodelReader, Date asOfDateTime) {
            this.context = context;
            this.doMgr = doMgr;
            this.contentmodelReader = contentmodelReader;
            this.asOfDateTime = asOfDateTime;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            if (systemId == null) {
                return null;
            }
            if (systemId.startsWith("$THIS$/")) {
                String[] tokens = systemId.split("/");
                try {
                    Datastream schemastream = this.contentmodelReader.GetDatastream(tokens[1], this.asOfDateTime);
                    MyLSInput input = new MyLSInput(schemastream);
                    input.setBaseURI(baseURI);
                    input.setPublicId(publicId);
                    input.setBaseURI(baseURI);
                    return input;
                }
                catch (ServerException e) {
                    return null;
                }
            }
            return null;
        }

        public static class MyLSInput
        implements LSInput {
            Datastream stream;
            private String systemId;
            private String publicId;
            private String baseURI;

            public MyLSInput(Datastream stream) {
                this.stream = stream;
            }

            @Override
            public Reader getCharacterStream() {
                return null;
            }

            @Override
            public void setCharacterStream(Reader characterStream) {
            }

            @Override
            public InputStream getByteStream() {
                try {
                    return this.stream.getContentStream();
                }
                catch (StreamIOException e) {
                    return null;
                }
            }

            @Override
            public void setByteStream(InputStream byteStream) {
            }

            @Override
            public String getStringData() {
                return null;
            }

            @Override
            public void setStringData(String stringData) {
            }

            @Override
            public String getSystemId() {
                return this.systemId;
            }

            @Override
            public void setSystemId(String systemId) {
                this.systemId = systemId;
            }

            @Override
            public String getPublicId() {
                return this.publicId;
            }

            @Override
            public void setPublicId(String publicId) {
                this.publicId = publicId;
            }

            @Override
            public String getBaseURI() {
                return this.baseURI;
            }

            @Override
            public void setBaseURI(String baseURI) {
                this.baseURI = baseURI;
            }

            @Override
            public String getEncoding() {
                return null;
            }

            @Override
            public void setEncoding(String encoding) {
            }

            @Override
            public boolean getCertifiedText() {
                return false;
            }

            @Override
            public void setCertifiedText(boolean certifiedText) {
            }
        }
    }
}

