/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLEventWriter;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multicast.TransportParent;

public abstract class Transport {
    protected final Map<String, String> parameters;
    protected final boolean crucial;
    protected final TransportParent parent;
    private State currentState = State.FILE_CLOSED;

    public Transport(Map<String, String> parameters, boolean crucial, TransportParent parent) throws JournalException {
        this.parameters = parameters;
        this.crucial = crucial;
        this.parent = parent;
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isCrucial() {
        return this.crucial;
    }

    public void testStateChange(State desiredState) throws JournalException {
        if (this.currentState == State.FILE_CLOSED && desiredState == State.FILE_CLOSED) {
            throw new JournalException("Request to close Transport when not open.");
        }
        if (this.currentState == State.FILE_OPEN && desiredState == State.FILE_OPEN) {
            throw new JournalException("Request to open Transport when already open.");
        }
        if (this.currentState == State.FILE_OPEN && desiredState == State.SHUTDOWN) {
            throw new JournalException("Request to shutdown Transport with file open.");
        }
        if (this.currentState == State.SHUTDOWN && desiredState == State.FILE_OPEN) {
            throw new JournalException("Request to open Transport after shutdown.");
        }
        if (this.currentState == State.SHUTDOWN && desiredState == State.FILE_CLOSED) {
            throw new JournalException("Request to close Transport after shutdown.");
        }
    }

    protected void testWriterState() throws JournalException {
        if (this.currentState == State.FILE_CLOSED) {
            throw new JournalException("Trying to write to a Transport that is not open.");
        }
        if (this.currentState == State.SHUTDOWN) {
            throw new JournalException("Trying to write to a Transport after shutdown.");
        }
    }

    public void setState(State newState) throws JournalException {
        this.testStateChange(newState);
        this.currentState = newState;
    }

    public State getState() {
        return this.currentState;
    }

    public abstract void openFile(String var1, String var2, Date var3) throws JournalException;

    public abstract XMLEventWriter getWriter() throws JournalException;

    public abstract void closeFile() throws JournalException;

    public abstract void shutdown() throws JournalException;

    public static enum State {
        FILE_CLOSED,
        FILE_OPEN,
        SHUTDOWN;

    }
}

