/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast.rmi;

import java.io.File;

public class RmiJournalReceiverArguments {
    private static final int DEFAULT_REGISTRY_PORT_NUMBER = 1099;
    private static final int DEFAULT_SERVER_PORT_NUMBER = 1100;
    private final File directoryPath;
    private final int registryPortNumber;
    private final int serverPortNumber;

    public RmiJournalReceiverArguments(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("usage: RmiJournalReceiver [fullDirectoryPath] {registryPort} {serverPort}");
        }
        this.directoryPath = this.parseDirectoryPath(args);
        this.registryPortNumber = this.parseRegistryPortNumber(args);
        this.serverPortNumber = this.parseServerPortNumber(args);
    }

    private File parseDirectoryPath(String[] args) {
        File path = new File(args[0]);
        if (!path.exists()) {
            throw new IllegalArgumentException("'" + path.getAbsolutePath() + "' does not exist.");
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException("'" + path.getAbsolutePath() + "' is not a directory.");
        }
        if (!path.canWrite()) {
            throw new IllegalArgumentException("Cannot write to '" + path.getAbsolutePath() + "'.");
        }
        return path;
    }

    private int parseRegistryPortNumber(String[] args) {
        if (args.length < 2) {
            return 1099;
        }
        try {
            return Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("'" + args[1] + "' is not a valid integer.");
        }
    }

    private int parseServerPortNumber(String[] args) {
        if (args.length < 3) {
            return 1100;
        }
        try {
            return Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("'" + args[2] + "' is not a valid integer.");
        }
    }

    public File getDirectoryPath() {
        return this.directoryPath;
    }

    public int getRegistryPortNumber() {
        return this.registryPortNumber;
    }

    public int getServerPortNumber() {
        return this.serverPortNumber;
    }
}

