/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import org.fcrepo.server.BasicServer;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.errors.ServerInitializationException;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.utilities.SQLUtility;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={SQLUtility.class})
public class BasicServerTest {
    private static TemporaryFolder tmpFolder;
    @Mock
    private Connection mockDefaultConnection;
    @Mock
    private Connection mockRWConnection;
    @Mock
    private ConnectionPool mockPool;
    private static File fedoraHomeFixture;
    private BasicServer test;

    @AfterClass
    public static void cleanUp() {
        if (fedoraHomeFixture != null) {
            fedoraHomeFixture.delete();
        }
        tmpFolder.delete();
    }

    @BeforeClass
    public static void bootstrap() throws IOException {
        tmpFolder = new TemporaryFolder();
        tmpFolder.create();
        fedoraHomeFixture = BasicServerTest.fakeFedoraHome();
    }

    private static File fakeFedoraHome() throws IOException {
        File fake = tmpFolder.newFolder(new String[]{"fedoraHome"});
        System.setProperty("fedora.home", fake.getAbsolutePath());
        new File(fake, "server/management/uplaods").mkdirs();
        new File(fake, "server/logs").mkdir();
        new File(fake, "server/config").mkdir();
        File fcfg = new File(fake, "server/config/fedora.fcfg");
        FileWriter writer = new FileWriter(fcfg);
        writer.write("<xml></xml>");
        writer.close();
        return fake;
    }

    @Before
    public void setUp() throws Exception {
        fedoraHomeFixture = BasicServerTest.fakeFedoraHome();
        PowerMockito.mockStatic(SQLUtility.class, (Class[])new Class[0]);
        Mockito.when((Object)SQLUtility.getConnectionPool((ServerConfiguration)((ServerConfiguration)Matchers.any(ServerConfiguration.class)))).thenReturn((Object)this.mockPool);
        Mockito.when((Object)this.mockPool.getReadWriteConnection()).thenReturn((Object)this.mockRWConnection);
        Mockito.when((Object)SQLUtility.getDefaultConnection((ServerConfiguration)((ServerConfiguration)Matchers.any(ServerConfiguration.class)))).thenReturn((Object)this.mockDefaultConnection);
        this.test = new BasicServer(new HashMap(), fedoraHomeFixture);
    }

    @Test
    public void testFirstRunEmptyDatabase() throws Exception {
        Mockito.when((Object)SQLUtility.getMostRecentRebuild((Connection)this.mockRWConnection)).thenReturn((Object)-1L);
        this.test.checkRebuildHasRun(true);
        PowerMockito.verifyStatic();
        SQLUtility.recordSuccessfulRebuild((Connection)((Connection)Matchers.eq((Object)this.mockRWConnection)), (long)((Long)Matchers.any(Long.class)));
    }

    @Test
    public void testFirstRunNonemptyDatabase() throws Exception {
        long now = System.currentTimeMillis();
        Mockito.when((Object)SQLUtility.getMostRecentRebuild((Connection)this.mockRWConnection)).thenReturn((Object)now);
        Mockito.when((Object)SQLUtility.getRebuildStatus((Connection)this.mockRWConnection, (long)now)).thenReturn((Object)true);
        this.test.checkRebuildHasRun(true);
        PowerMockito.verifyStatic();
        SQLUtility.getRebuildStatus((Connection)this.mockRWConnection, (long)now);
    }

    @Test(expected=ServerInitializationException.class)
    public void testSubsequentRunEmptyDatabase() throws Exception {
        Mockito.when((Object)SQLUtility.getMostRecentRebuild((Connection)this.mockRWConnection)).thenReturn((Object)-1L);
        this.test.checkRebuildHasRun(false);
    }

    @Test(expected=ServerInitializationException.class)
    public void testSubsequentRunBadRebuild() throws Exception {
        long now = System.currentTimeMillis();
        Mockito.when((Object)SQLUtility.getMostRecentRebuild((Connection)this.mockRWConnection)).thenReturn((Object)now);
        Mockito.when((Object)SQLUtility.getRebuildStatus((Connection)((Connection)Matchers.eq((Object)this.mockRWConnection)), (long)((Long)Matchers.any(Long.class)))).thenReturn((Object)false);
        this.test.checkRebuildHasRun(false);
    }

    @Test
    public void testSubsequentRunGoodRebuild() throws Exception {
        long now = System.currentTimeMillis();
        Mockito.when((Object)SQLUtility.getMostRecentRebuild((Connection)this.mockRWConnection)).thenReturn((Object)now);
        Mockito.when((Object)SQLUtility.getRebuildStatus((Connection)this.mockRWConnection, (long)now)).thenReturn((Object)true);
        this.test.checkRebuildHasRun(false);
        PowerMockito.verifyStatic();
        SQLUtility.getRebuildStatus((Connection)this.mockRWConnection, (long)now);
    }
}

