/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.common.FedoraTestConstants;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.config.ServerConfigurationParser;
import org.w3c.dom.Document;

public class TestServerConfiguration
extends XMLTestCase
implements FedoraTestConstants {
    private static final File FCFG_BASE = new File("../fcrepo-server/src/main/resources/fcfg/server/fedora-base.fcfg");
    private static final String NS_FCFG_PREFIX = "fcfg";
    private DocumentBuilder builder;
    private ByteArrayOutputStream out;

    protected void setUp() throws Exception {
        this.out = new ByteArrayOutputStream();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.builder = factory.newDocumentBuilder();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(NS_FCFG_PREFIX, "http://www.fedora.info/definitions/1/0/config/");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
        XMLUnit.setIgnoreWhitespace((boolean)false);
    }

    protected void tearDown() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
        XMLUnit.setIgnoreWhitespace((boolean)false);
        this.out.close();
    }

    public void testApplyProperties() throws Exception {
        ServerConfiguration config = new ServerConfigurationParser((InputStream)new FileInputStream(FCFG_BASE)).parse();
        String testVal = "9999";
        String xpath = "/fcfg:server/fcfg:param[@name='fedoraServerPort'][@value='" + testVal + "']";
        config.serialize((OutputStream)this.out);
        this.assertXpathNotExists(xpath, this.getDocument(this.out));
        this.out.reset();
        Properties props = new Properties();
        props.put("server:fedoraServerPort", testVal);
        config.applyProperties(props);
        config.serialize((OutputStream)this.out);
        this.assertXpathExists(xpath, this.getDocument(this.out));
    }

    public void testSerialize() throws Exception {
        ServerConfiguration config = new ServerConfigurationParser((InputStream)new FileInputStream(FCFG_BASE)).parse();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        config.serialize((OutputStream)out);
        Document original = this.builder.parse(FCFG_BASE);
        Document generated = this.builder.parse(new ByteArrayInputStream(out.toByteArray()));
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Diff diff = new Diff(original, generated);
        diff.overrideElementQualifier((ElementQualifier)new ElementNameAndAttributeQualifier());
        this.assertXMLEqual(diff, true);
    }

    private Document getDocument(ByteArrayOutputStream out) throws Exception {
        return XMLUnit.buildControlDocument((String)new String(out.toByteArray(), "UTF-8"));
    }
}

