/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.junit.Assert;

public class AbstractJournalTester {
    protected void deleteDirectoryContents(File directory) {
        File[] children = directory.listFiles();
        if (children != null) {
            for (File child : children) {
                boolean deleted;
                if (child.isDirectory()) {
                    this.deleteDirectoryContents(child);
                }
                if (deleted = child.delete()) continue;
                throw new IllegalStateException("Failed to delete: " + child);
            }
        }
    }

    protected void assertFileExists(File file) {
        if (!file.exists()) {
            Assert.fail((String)("File '" + file.getAbsolutePath() + "' does not exist."));
        }
    }

    protected void assertFileDoesNotExist(File file) {
        if (file.exists()) {
            Assert.fail((String)("File '" + file.getAbsolutePath() + "' should not exist."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertFileContents(String expected, File file) {
        BufferedReader reader = null;
        try {
            StringBuffer contents = new StringBuffer();
            reader = new BufferedReader(new FileReader(file));
            int howMany = 0;
            char[] buffer = new char[4096];
            while (-1 != (howMany = reader.read(buffer))) {
                contents.append(buffer, 0, howMany);
            }
            Assert.assertEquals((String)("checking file contents for " + file), (Object)expected, (Object)contents.toString());
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)e.toString());
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Assert.fail((String)e.toString());
                }
            }
        }
    }
}

