/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalWriter;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.CreatorJournalEntry;

public class MockJournalWriter
extends JournalWriter {
    private static String buffer;
    private final StringWriter stringWriter = new StringWriter();
    private final XMLEventWriter xmlWriter = new IndentingXMLEventWriter(XMLOutputFactory.newInstance().createXMLEventWriter(this.stringWriter));
    private boolean firstEntry = true;

    public static String getBuffer() {
        return buffer;
    }

    public MockJournalWriter(Map<String, String> parameters, String role, ServerInterface server) throws XMLStreamException, FactoryConfigurationError {
        super(parameters, role, server);
    }

    public void prepareToWriteJournalEntry() throws JournalException {
        if (this.firstEntry) {
            super.writeDocumentHeader(this.xmlWriter);
            this.firstEntry = false;
        }
    }

    public void shutdown() throws JournalException {
        try {
            super.writeDocumentTrailer(this.xmlWriter);
            this.xmlWriter.close();
            this.stringWriter.close();
            buffer = this.stringWriter.toString();
        }
        catch (XMLStreamException e) {
            throw new JournalException((Throwable)e);
        }
        catch (IOException e) {
            throw new JournalException((Throwable)e);
        }
    }

    public void writeJournalEntry(CreatorJournalEntry journalEntry) throws JournalException {
        super.writeJournalEntry(journalEntry, this.xmlWriter);
    }
}

