/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.helpers;

import java.util.HashSet;
import junit.framework.TestCase;
import org.fcrepo.server.journal.helpers.PasswordCipher;

public class TestPasswordCipher
extends TestCase {
    private static final String CIPHER_TYPE_1 = "1";
    private static final String KEY_1 = "Now is the time for all";
    private static final String KEY_2 = "X";
    private static final String KEY_3 = "@lk<>2lkj-\u1234***";
    private static final String[] KEYS = new String[]{"Now is the time for all", "X", "@lk<>2lkj-\u1234***"};
    private static final String TEXT_1 = "Silly boys!";
    private static final String TEXT_2 = "234!@#$@#$@%$^&*";
    private static final String TEXT_3 = "FRED\u6655";
    private static final String[] TEXTS = new String[]{"Silly boys!", "234!@#$@#$@%$^&*", "FRED\u6655"};

    public TestPasswordCipher(String name) {
        super(name);
    }

    public void testUniqueArgumentsOnEncipher() {
        try {
            PasswordCipher.encipher(null, (String)TEXT_1);
            TestPasswordCipher.fail((String)"Expected a NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        String cipher1 = PasswordCipher.encipher((String)KEY_1, null);
        TestPasswordCipher.assertNull((Object)cipher1);
        String cipher2 = PasswordCipher.encipher((String)"", (String)TEXT_1);
        TestPasswordCipher.assertEquals((String)TEXT_1, (String)cipher2);
    }

    public void testUniqueArgumentsOnDecipher() {
        String clear1 = PasswordCipher.decipher((String)KEY_1, null, (String)CIPHER_TYPE_1);
        TestPasswordCipher.assertNull((Object)clear1);
        String clear2 = PasswordCipher.decipher(null, (String)TEXT_1, (String)CIPHER_TYPE_1);
        TestPasswordCipher.assertEquals((String)TEXT_1, (String)clear2);
        String clear3 = PasswordCipher.decipher((String)"", (String)TEXT_2, (String)CIPHER_TYPE_1);
        TestPasswordCipher.assertEquals((String)TEXT_2, (String)clear3);
        String clear4 = PasswordCipher.decipher((String)KEY_2, (String)TEXT_1, null);
        TestPasswordCipher.assertEquals((String)TEXT_1, (String)clear4);
        String clear5 = PasswordCipher.decipher((String)KEY_2, (String)TEXT_2, (String)"");
        TestPasswordCipher.assertEquals((String)TEXT_2, (String)clear5);
    }

    public void testCipherDoesSomething() {
        for (String element : KEYS) {
            for (String element2 : TEXTS) {
                String cipher = PasswordCipher.encipher((String)element, (String)element2);
                TestPasswordCipher.assertFalse((boolean)element2.equals(cipher));
            }
        }
    }

    public void testNullCipherDoesNothing() {
        for (String element : KEYS) {
            for (String element2 : TEXTS) {
                String deciphered = PasswordCipher.decipher((String)element, (String)element2, null);
                TestPasswordCipher.assertEquals((String)element2, (String)deciphered);
            }
        }
    }

    public void testCipherIsReversible() {
        for (String element : KEYS) {
            for (String element2 : TEXTS) {
                String cipher = PasswordCipher.encipher((String)element, (String)element2);
                String clear = PasswordCipher.decipher((String)element, (String)cipher, (String)CIPHER_TYPE_1);
                TestPasswordCipher.assertEquals((String)element2, (String)clear);
            }
        }
    }

    public void testCipherIsWellDistributed() {
        HashSet<String> ciphers = new HashSet<String>();
        for (String element : KEYS) {
            for (String element2 : TEXTS) {
                String cipher = PasswordCipher.encipher((String)element, (String)element2);
                TestPasswordCipher.assertTrue((String)("Set of ciphers already contains '" + cipher + "'"), (boolean)ciphers.add(cipher));
            }
        }
    }
}

