/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multicast.Transport;
import org.fcrepo.server.journal.readerwriter.multicast.TransportParent;

public class MockTransport
extends Transport {
    private int howManyOpenFileRequests;
    private int howManyGetWriterRequests;
    private int howManyCloseFileRequests;
    private int howManyShutdownRequests;
    private String repositoryHash;
    private String filename;
    private Date currentDate;
    private StringWriter stringWriter;
    private XMLEventWriter xmlWriter;
    private boolean throwExceptionOnGetWriter;

    public MockTransport(Map<String, String> parameters, boolean crucial, TransportParent parent) throws JournalException {
        super(parameters, crucial, parent);
    }

    public int getHowManyCloseFileRequests() {
        return this.howManyCloseFileRequests;
    }

    public int getHowManyGetWriterRequests() {
        return this.howManyGetWriterRequests;
    }

    public int getHowManyOpenFileRequests() {
        return this.howManyOpenFileRequests;
    }

    public int getHowManyShutdownRequests() {
        return this.howManyShutdownRequests;
    }

    public String getFilename() {
        return this.filename;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public String getRepositoryHash() {
        return this.repositoryHash;
    }

    public String getFileContents() {
        return this.stringWriter.getBuffer().toString();
    }

    public void setThrowExceptionOnGetWriter(boolean throwExceptionOnGetWriter) {
        this.throwExceptionOnGetWriter = throwExceptionOnGetWriter;
    }

    public void openFile(String repositoryHash, String filename, Date currentDate) throws JournalException {
        ++this.howManyOpenFileRequests;
        this.repositoryHash = repositoryHash;
        this.filename = filename;
        this.currentDate = currentDate;
        try {
            this.stringWriter = new StringWriter();
            this.xmlWriter = new IndentingXMLEventWriter(XMLOutputFactory.newInstance().createXMLEventWriter(this.stringWriter));
        }
        catch (XMLStreamException e) {
            throw new JournalException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new JournalException((Throwable)e);
        }
    }

    public XMLEventWriter getWriter() throws JournalException {
        ++this.howManyGetWriterRequests;
        if (this.throwExceptionOnGetWriter) {
            throw new JournalException("forced Exception on getWriter()");
        }
        return this.xmlWriter;
    }

    public void closeFile() throws JournalException {
        ++this.howManyCloseFileRequests;
    }

    public void shutdown() throws JournalException {
        ++this.howManyShutdownRequests;
    }
}

