/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast.rmi;

import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverInterface;

public class MockRmiJournalReceiver
extends UnicastRemoteObject
implements RmiJournalReceiverInterface {
    private static boolean trace;
    private int howManyCallsToOpenFile;
    private int howManyCallsToWriteText;
    private int howManyCallsToClosefile;
    private boolean openFileThrowsException;
    private boolean writeTextThrowsException;
    private boolean closeFileThrowsException;
    private String repositoryHash;
    private String filename;
    private String indexedHash;
    private String text;

    public int howManyCallsToClosefile() {
        return this.howManyCallsToClosefile;
    }

    public int howManyCallsToOpenFile() {
        return this.howManyCallsToOpenFile;
    }

    public int howManyCallsToWriteText() {
        return this.howManyCallsToWriteText;
    }

    public void setCloseFileThrowsException(boolean closeFileThrowsException) {
        this.closeFileThrowsException = closeFileThrowsException;
    }

    public void setOpenFileThrowsException(boolean openFileThrowsException) {
        this.openFileThrowsException = openFileThrowsException;
    }

    public void setWriteTextThrowsException(boolean writeTextThrowsException) {
        this.writeTextThrowsException = writeTextThrowsException;
    }

    public String getRepositoryHash() {
        return this.repositoryHash;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getIndexedHash() {
        return this.indexedHash;
    }

    public String getText() {
        return this.text;
    }

    public void openFile(String repositoryHash, String filename) throws RemoteException, JournalException {
        ++this.howManyCallsToOpenFile;
        if (this.openFileThrowsException) {
            throw new RemoteException("openFile throws exception");
        }
        this.repositoryHash = repositoryHash;
        this.filename = filename;
        if (trace) {
            System.out.println("openFile(" + repositoryHash + ", " + filename + ")");
        }
    }

    public void writeText(String indexedHash, String text) throws RemoteException, JournalException {
        ++this.howManyCallsToWriteText;
        if (this.writeTextThrowsException) {
            throw new RemoteException("writeText throws exception");
        }
        this.indexedHash = indexedHash;
        this.text = text;
        if (trace) {
            System.out.println("writeText(" + indexedHash + ", " + text + ")");
        }
    }

    public void closeFile() throws RemoteException, JournalException {
        ++this.howManyCallsToClosefile;
        if (this.closeFileThrowsException) {
            throw new JournalException("closeFile throws exception");
        }
        if (trace) {
            System.out.println("closeFile()");
        }
    }

    public static void main(String[] args) throws RemoteException, AlreadyBoundException {
        trace = true;
        try {
            MockRmiJournalReceiver receiver = new MockRmiJournalReceiver();
            if (Arrays.asList(args).contains("throwException")) {
                receiver.setOpenFileThrowsException(true);
            }
            Registry registry = LocateRegistry.createRegistry(1099);
            registry.bind("RmiJournalReceiver", receiver);
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

