/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multifile;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalConstants;
import org.fcrepo.server.journal.JournalConsumer;
import org.fcrepo.server.journal.MockJournalRecoveryLog;
import org.fcrepo.server.journal.MockServerForJournalTesting;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.readerwriter.multifile.LockingFollowingJournalReader;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalConstants;
import org.fcrepo.server.journal.readerwriter.multifile.MultiFileJournalHelper;
import org.fcrepo.server.management.ManagementDelegate;
import org.fcrepo.server.management.MockManagementDelegate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLockingFollowingJournalReader
implements Constants,
JournalConstants,
MultiFileJournalConstants {
    private static Logger LOGGER = LoggerFactory.getLogger(TestLockingFollowingJournalReader.class);
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private static final int WAIT_INTERVAL = 5;
    private static final String JOURNAL_FILENAME_PREFIX = "unit";
    private static final String DUMMY_HASH_VALUE = "Dummy Hash";
    private File journalDirectory;
    private File archiveDirectory;
    private File lockRequestFile;
    private File lockAcceptedFile;
    private Map<String, String> parameters;
    private ServerInterface server;
    private final String role = "DumbGrunt";
    private MyMockManagementDelegate delegate;
    private int initialNumberOfThreads;

    @Before
    public void setUp() throws Exception {
        this.journalDirectory = this.createTempDirectory("fedoraTestingJournalFiles");
        this.archiveDirectory = this.createTempDirectory("fedoraTestingArchiveFiles");
        this.lockRequestFile = new File(this.journalDirectory.getPath() + File.separator + "lockRequested");
        this.lockRequestFile.delete();
        this.lockAcceptedFile = new File(this.journalDirectory.getPath() + File.separator + "lockAccepted");
        this.lockAcceptedFile.delete();
        this.delegate = new MyMockManagementDelegate();
        this.server = new MockServerForJournalTesting(this.delegate, DUMMY_HASH_VALUE);
        this.parameters = new HashMap<String, String>();
        this.parameters.put("journalRecoveryLogClassname", MockJournalRecoveryLog.class.getName());
        this.parameters.put("journalReaderClassname", LockingFollowingJournalReader.class.getName());
        this.parameters.put("journalDirectory", this.journalDirectory.getPath());
        this.parameters.put("archiveDirectory", this.archiveDirectory.getPath());
        this.parameters.put("followPollingInterval", "1");
        this.parameters.put("journalFilenamePrefix", JOURNAL_FILENAME_PREFIX);
        this.parameters.put("lockRequestedFilename", this.lockRequestFile.getPath());
        this.parameters.put("lockAcceptedFilename", this.lockAcceptedFile.getPath());
        this.initialNumberOfThreads = this.getNumberOfCurrentThreads();
    }

    @After
    public void cleanUp() throws Exception {
        boolean deleted;
        this.delegate.reset();
        if (this.lockRequestFile.delete()) {
            LOGGER.info("Cleaned up lockRequestFile file at {}", (Object)this.lockRequestFile.getPath());
        }
        if (this.lockAcceptedFile.delete()) {
            LOGGER.info("Cleaned up lockAcceptedFile file at {}", (Object)this.lockAcceptedFile.getPath());
        }
        for (File file : this.journalDirectory.listFiles()) {
            deleted = file.delete();
            LOGGER.info("{} Cleaned up a journalDirectory file: {}", (Object)deleted, (Object)file.getPath());
        }
        for (File file : this.archiveDirectory.listFiles()) {
            deleted = file.delete();
            LOGGER.info("{} Cleaned up a archiveDirectory file: {}", (Object)deleted, (Object)file.getPath());
        }
    }

    @Test
    public void testSimpleNoLocking() {
        try {
            this.createJournalFileFromString(this.getSimpleIngestString());
            this.createJournalFileFromString(this.getSimpleIngestString());
            this.createJournalFileFromString(this.getSimpleIngestString());
            JournalConsumer consumer = new JournalConsumer(this.parameters, "DumbGrunt", this.server);
            this.startConsumerThread(consumer);
            this.waitWhileThreadRuns(5);
            consumer.shutdown();
            Assert.assertEquals((String)"Expected to see 3 ingests", (long)3L, (long)this.delegate.getCallCount());
            Assert.assertEquals((String)"Journal files not all gone", (long)0L, (long)this.howManyFilesInDirectory(this.journalDirectory));
            Assert.assertEquals((String)"Wrong number of archive files", (long)3L, (long)this.howManyFilesInDirectory(this.archiveDirectory));
        }
        catch (Throwable e) {
            this.processException(e);
        }
    }

    @Ignore
    public void testLockBeforeStartingAndResume() throws Exception {
        this.createJournalFileFromString(this.getSimpleIngestString());
        this.createJournalFileFromString(this.getSimpleIngestString());
        this.createJournalFileFromString(this.getSimpleIngestString());
        this.createLockRequest();
        JournalConsumer consumer = new JournalConsumer(this.parameters, "DumbGrunt", this.server);
        this.startConsumerThread(consumer);
        this.waitForLockAccepted();
        this.waitWhileThreadRuns(5);
        Assert.assertEquals((String)"Journal files should not be processed", (long)0L, (long)this.delegate.getCallCount());
        Assert.assertEquals((String)"Journal files should not be processed", (long)3L, (long)this.howManyFilesInDirectory(this.journalDirectory));
        Assert.assertEquals((String)"Journal files should not be processed", (long)0L, (long)this.howManyFilesInDirectory(this.archiveDirectory));
        int lockMessageIndex = this.assertLockMessageInLog();
        this.removeLockRequest();
        this.waitForLockReleased();
        this.waitWhileThreadRuns(5);
        consumer.shutdown();
        Assert.assertEquals((String)"Expected to see 3 ingests", (long)3L, (long)this.delegate.getCallCount());
        Assert.assertEquals((String)"Journal files not all gone", (long)0L, (long)this.howManyFilesInDirectory(this.journalDirectory));
        Assert.assertEquals((String)"Wrong number of archive files", (long)3L, (long)this.howManyFilesInDirectory(this.archiveDirectory));
        this.assertUnlockMessageInLog(lockMessageIndex);
    }

    @Test
    public void testLockWhileProcessingAndResume() throws Exception {
        this.createJournalFileFromString(this.getSimpleIngestString());
        this.createJournalFileFromString(this.getSimpleIngestString());
        this.createJournalFileFromString(this.getSimpleIngestString());
        this.delegate.setIngestOperation(new LockAfterSecondIngest());
        JournalConsumer consumer = new JournalConsumer(this.parameters, "DumbGrunt", this.server);
        this.startConsumerThread(consumer);
        this.waitForLockAccepted();
        this.waitWhileThreadRuns(5);
        Assert.assertEquals((String)"We should stop after the second ingest", (long)2L, (long)this.delegate.getCallCount());
        Assert.assertEquals((String)"One Journal file should not be processed", (long)1L, (long)this.howManyFilesInDirectory(this.journalDirectory));
        Assert.assertEquals((String)"Only two Journal files should be processed", (long)2L, (long)this.howManyFilesInDirectory(this.archiveDirectory));
        int lockMessageIndex = this.assertLockMessageInLog();
        this.removeLockRequest();
        this.waitForLockReleased();
        this.waitWhileThreadRuns(5);
        consumer.shutdown();
        Assert.assertEquals((String)"Expected to see 3 ingests", (long)3L, (long)this.delegate.getCallCount());
        Assert.assertEquals((String)"Journal files not all gone", (long)0L, (long)this.howManyFilesInDirectory(this.journalDirectory));
        Assert.assertEquals((String)"Wrong number of archive files", (long)3L, (long)this.howManyFilesInDirectory(this.archiveDirectory));
        this.assertUnlockMessageInLog(lockMessageIndex);
    }

    @Ignore
    public void testSimpleFirst() throws Exception {
        this.testSimpleNoLocking();
        this.cleanUp();
        this.setUp();
        this.testLockWhileProcessingAndResume();
    }

    @Ignore
    public void testSimpleLast() throws Exception {
        this.testLockWhileProcessingAndResume();
        this.cleanUp();
        this.setUp();
        this.testSimpleNoLocking();
    }

    @Ignore
    public void testLockWhilePollingAndResume() {
        try {
            this.createJournalFileFromString(this.getSimpleIngestString());
            JournalConsumer consumer = new JournalConsumer(this.parameters, "DumbGrunt", this.server);
            this.startConsumerThread(consumer);
            this.waitWhileThreadRuns(5);
            Assert.assertEquals((String)"The first file should have been processed.", (long)1L, (long)this.delegate.getCallCount());
            Assert.assertEquals((String)"The first file should have been processed.", (long)0L, (long)this.howManyFilesInDirectory(this.journalDirectory));
            Assert.assertEquals((String)"The first file should have been processed.", (long)1L, (long)this.howManyFilesInDirectory(this.archiveDirectory));
            this.createLockRequest();
            this.waitForLockAccepted();
            this.createJournalFileFromString(this.getSimpleIngestString());
            this.waitWhileThreadRuns(5);
            Assert.assertEquals((String)"The second file should not have been processed.", (long)1L, (long)this.delegate.getCallCount());
            Assert.assertEquals((String)"The second file should not have been processed.", (long)1L, (long)this.howManyFilesInDirectory(this.journalDirectory));
            Assert.assertEquals((String)"The second file should not have been processed.", (long)1L, (long)this.howManyFilesInDirectory(this.archiveDirectory));
            int lockMessageIndex = this.assertLockMessageInLog();
            this.removeLockRequest();
            this.waitForLockReleased();
            this.waitWhileThreadRuns(5);
            consumer.shutdown();
            Assert.assertEquals((String)"Expected to see 2 ingests", (long)2L, (long)this.delegate.getCallCount());
            Assert.assertEquals((String)"Journal files not all gone", (long)0L, (long)this.howManyFilesInDirectory(this.journalDirectory));
            Assert.assertEquals((String)"Wrong number of archive files", (long)2L, (long)this.howManyFilesInDirectory(this.archiveDirectory));
            this.assertUnlockMessageInLog(lockMessageIndex);
        }
        catch (Throwable e) {
            this.processException(e);
        }
    }

    private void createLockRequest() throws IOException {
        this.lockRequestFile.createNewFile();
    }

    private void removeLockRequest() {
        this.lockRequestFile.delete();
    }

    private int howManyFilesInDirectory(File directory) {
        return MultiFileJournalHelper.getSortedArrayOfJournalFiles((File)directory, (String)JOURNAL_FILENAME_PREFIX).length;
    }

    private void waitWhileThreadRuns(int maxSecondsToWait) {
        for (int i = 0; i < maxSecondsToWait; ++i) {
            if (this.getNumberOfCurrentThreads() == this.initialNumberOfThreads) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void waitForLockAccepted() {
        int maxWait = 10;
        for (int i = 0; i < maxWait; ++i) {
            if (this.lockAcceptedFile.exists()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.fail((String)("Lock was not accepted after " + maxWait + " seconds."));
    }

    private void waitForLockReleased() {
        int maxWait = 10;
        for (int i = 0; i < maxWait; ++i) {
            if (!this.lockAcceptedFile.exists()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.fail((String)("Lock was not released after " + maxWait + " seconds."));
    }

    private void startConsumerThread(JournalConsumer consumer) {
        consumer.setManagementDelegate((ManagementDelegate)this.delegate);
    }

    private int getNumberOfCurrentThreads() {
        int i = Thread.currentThread().getThreadGroup().enumerate(new Thread[500]);
        return i;
    }

    private void createJournalFileFromString(String text) throws IOException {
        File journal = File.createTempFile(JOURNAL_FILENAME_PREFIX, null, this.journalDirectory);
        journal.deleteOnExit();
        FileWriter writer = new FileWriter(journal);
        writer.write(text);
        writer.close();
    }

    private int assertLockMessageInLog() {
        List<String> messages = MockJournalRecoveryLog.getMessages();
        int lastMessageIndex = messages.size() - 1;
        String lastMessage = messages.get(lastMessageIndex);
        this.assertStringStartsWith(lastMessage, "Lock request detected:");
        return lastMessageIndex;
    }

    private void assertUnlockMessageInLog(int lockMessageIndex) {
        List<String> messages = MockJournalRecoveryLog.getMessages();
        int unlockMessageIndex = lockMessageIndex + 1;
        Assert.assertTrue((messages.size() > unlockMessageIndex ? 1 : 0) != 0);
        String unlockMessage = messages.get(unlockMessageIndex);
        this.assertStringStartsWith(unlockMessage, "Lock request removed");
    }

    private void assertStringStartsWith(String string, String prefix) {
        if (!string.startsWith(prefix)) {
            Assert.fail((String)("String does not start as expected: string='" + string + "', prefix='" + prefix + "'"));
        }
    }

    private void processException(Throwable e) {
        if (e instanceof ServerException) {
            StackTraceElement[] traces;
            System.err.println("ServerException: code='" + ((ServerException)e).getCode() + "', class='" + e.getClass().getName() + "'");
            for (StackTraceElement element : traces = e.getStackTrace()) {
                System.err.println(element);
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                cause.printStackTrace();
            }
            Assert.fail((String)"Threw a ServerException");
        } else {
            e.printStackTrace();
            Assert.fail((String)"Threw an exception");
        }
    }

    private File createTempDirectory(String name) throws IOException {
        return this.tmpFolder.newFolder(new String[]{name});
    }

    private String getSimpleIngestString() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<FedoraJournal repositoryHash=\"Dummy Hash\" timestamp=\"2006-08-11T11:14:43.011-0400\">\n  <JournalEntry method=\"ingest\" timestamp=\"2006-08-11T11:14:42.690-0400\" clientIpAddress=\"128.84.103.30\" loginId=\"fedoraAdmin\">\n    <context>\n      <password>junk</password>\n      <noOp>false</noOp>\n      <now>2006-08-11T11:14:42.690-0400</now>\n      <multimap name=\"environment\">\n        <multimapkey name=\"urn:fedora:names:fedora:2.1:environment:httpRequest:authType\">\n          <multimapvalue>BASIC</multimapvalue>\n        </multimapkey>\n      </multimap>\n      <multimap name=\"subject\"></multimap>\n      <multimap name=\"action\"> </multimap>\n      <multimap name=\"resource\"></multimap>\n      <multimap name=\"recovery\"></multimap>\n    </context>\n    <argument name=\"serialization\" type=\"stream\">PD94</argument>\n    <argument name=\"message\" type=\"string\">Minimal Ingest sample</argument>\n    <argument name=\"format\" type=\"string\">" + TestLockingFollowingJournalReader.FOXML1_1.uri + "</argument>\n" + "    <argument name=\"encoding\" type=\"string\">UTF-8</argument>\n" + "    <argument name=\"pid\" type=\"string\">new</argument>\n" + "  </JournalEntry>\n" + "</FedoraJournal>\n";
    }

    private static class MyMockManagementDelegate
    extends MockManagementDelegate {
        private Runnable ingestOperation;

        private MyMockManagementDelegate() {
        }

        public void setIngestOperation(Runnable ingestOperation) {
            this.ingestOperation = ingestOperation;
        }

        @Override
        public String ingest(Context context, InputStream serialization, String logMessage, String format, String encoding, String pid) throws ServerException {
            String result = super.ingest(context, serialization, logMessage, format, encoding, pid);
            if (this.ingestOperation != null) {
                this.ingestOperation.run();
            }
            return result;
        }
    }

    private final class LockAfterSecondIngest
    implements Runnable {
        private LockAfterSecondIngest() {
        }

        @Override
        public void run() {
            if (TestLockingFollowingJournalReader.this.delegate.getCallCount() == 2) {
                try {
                    TestLockingFollowingJournalReader.this.createLockRequest();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

