/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.xmlhelpers;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import junit.framework.TestCase;
import org.fcrepo.server.MultiValueMap;
import org.fcrepo.server.journal.entry.JournalEntryContext;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.xmlhelpers.ContextXmlReader;
import org.fcrepo.server.journal.xmlhelpers.ContextXmlWriter;

public class TestContextXmlWriterAndReader
extends TestCase {
    private StringWriter xmlStringWriter;
    private XMLEventWriter xmlWriter;

    public TestContextXmlWriterAndReader(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.xmlStringWriter = new StringWriter();
        this.xmlWriter = this.createXmlWriter();
    }

    public void testBasicWriteAndRead() throws Exception {
        JournalEntryContext context1 = new JournalEntryContext();
        context1.setPassword("SuperSecret");
        context1.setNoOp(true);
        context1.setEnvironmentAttributes(this.createMap("envAttr", "envValue"));
        context1.setSubjectAttributes(this.createMap(new String[][]{{"subAttr1", "subValue1"}, {"subAttr2", "subValue2"}}));
        context1.setActionAttributes(this.createMap(new String[][]{{"ActionAttribute", "ActionValue"}}));
        context1.setRecoveryAttributes(this.createMap("recoveryAttribute", new String[]{"recoveryValue", "recoveryValue2"}));
        ContextXmlWriter contextWriter = new ContextXmlWriter();
        contextWriter.writeContext(context1, this.xmlWriter);
        String xmlString = this.xmlStringWriter.toString();
        XMLEventReader xmlReader = this.createXmlReaderAndPosition(xmlString);
        ContextXmlReader contextReader = new ContextXmlReader();
        JournalEntryContext context2 = contextReader.readContext(xmlReader);
        this.assertContextsAreEqual(context1, context2);
    }

    public void testReadObsoletePasswordCipherType() throws Exception {
        JournalEntryContext context1 = new JournalEntryContext();
        context1.setPassword("ShoopShoop");
        context1.setNoOp(true);
        String xmlString = "<context>\n  <password>ShoopShoop</password>\n  <noOp>true</noOp>\n  <now>" + JournalHelper.formatDate((Date)context1.now()) + "</now>\n" + "  <multimap name=\"environment\"></multimap>\n" + "  <multimap name=\"subject\"></multimap>\n" + "  <multimap name=\"action\"></multimap>\n" + "  <multimap name=\"resource\"></multimap>\n" + "  <multimap name=\"recovery\"></multimap>\n" + "</context>\n";
        XMLEventReader xmlReader = this.createXmlReaderAndPosition(xmlString);
        ContextXmlReader contextReader = new ContextXmlReader();
        JournalEntryContext context2 = contextReader.readContext(xmlReader);
        this.assertContextsAreEqual(context1, context2);
    }

    private XMLEventReader createXmlReaderAndPosition(String xmlString) throws FactoryConfigurationError, XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader xmlReader = factory.createXMLEventReader(new StringReader(xmlString));
        this.advanceToContext(xmlReader);
        return xmlReader;
    }

    private XMLEventWriter createXmlWriter() throws FactoryConfigurationError, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        return new IndentingXMLEventWriter(factory.createXMLEventWriter(this.xmlStringWriter));
    }

    private MultiValueMap createMap(String key, String value) {
        return this.createMap(key, new String[]{value});
    }

    private MultiValueMap createMap(String key, String[] value) {
        MultiValueMap map = new MultiValueMap();
        map.set(key, value);
        return map;
    }

    private MultiValueMap createMap(String[][] key_value) {
        MultiValueMap map = new MultiValueMap();
        for (String[] pair : key_value) {
            map.set(pair[0], pair[1]);
        }
        return map;
    }

    private void advanceToContext(XMLEventReader reader) throws XMLStreamException {
        XMLEvent event = reader.peek();
        if (event.isStartDocument()) {
            reader.nextEvent();
        } else {
            TestContextXmlWriterAndReader.fail((String)"Document does not begin with a 'StartDocument' event.");
        }
    }

    private void assertContextsAreEqual(JournalEntryContext context1, JournalEntryContext context2) {
        TestContextXmlWriterAndReader.assertEquals((String)context1.getPassword(), (String)context2.getPassword());
        TestContextXmlWriterAndReader.assertEquals((boolean)context1.getNoOp(), (boolean)context2.getNoOp());
        TestContextXmlWriterAndReader.assertEquals((Object)context1.now(), (Object)context2.now());
        this.assertEqualMultiMaps(context1.getEnvironmentAttributes(), context2.getEnvironmentAttributes());
        this.assertEqualMultiMaps(context1.getSubjectAttributes(), context2.getSubjectAttributes());
        this.assertEqualMultiMaps(context1.getActionAttributes(), context2.getActionAttributes());
        this.assertEqualMultiMaps(context1.getResourceAttributes(), context2.getResourceAttributes());
        this.assertEqualMultiMaps(context1.getRecoveryAttributes(), context2.getRecoveryAttributes());
    }

    private void assertEqualMultiMaps(MultiValueMap map1, MultiValueMap map2) {
        Iterator names1 = map1.names();
        Iterator names2 = map2.names();
        while (names1.hasNext() && names2.hasNext()) {
            String name1 = (String)names1.next();
            String name2 = (String)names2.next();
            TestContextXmlWriterAndReader.assertEquals((String)name1, (String)name2);
            String[] values1 = map1.getStringArray(name1);
            String[] values2 = map1.getStringArray(name2);
            this.assertEqualSets(new HashSet<String>(Arrays.asList(values1)), new HashSet<String>(Arrays.asList(values2)));
        }
    }

    private void assertEqualSets(Set<String> set1, Set<String> set2) {
        TestContextXmlWriterAndReader.assertEquals(set1, set2);
    }
}

